/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class SQLBoolean
extends DataType
implements BooleanDataValue {
    static final int BOOLEAN_LENGTH = 1;
    private static final SQLBoolean BOOLEAN_TRUE = new SQLBoolean(true);
    private static final SQLBoolean BOOLEAN_FALSE = new SQLBoolean(false);
    static final SQLBoolean UNKNOWN = new SQLBoolean();
    private static final int BASE_MEMORY_USAGE;
    private boolean value;
    private boolean isnull;
    private boolean immutable;

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    private static int makeInt(boolean b) {
        return b ? 1 : 0;
    }

    @Override
    public byte getByte() {
        return (byte)SQLBoolean.makeInt(this.value);
    }

    @Override
    public short getShort() {
        return (short)SQLBoolean.makeInt(this.value);
    }

    @Override
    public int getInt() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public long getLong() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public float getFloat() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public double getDouble() {
        return SQLBoolean.makeInt(this.value);
    }

    @Override
    public int typeToBigDecimal() {
        return -5;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public String getTypeName() {
        return "BOOLEAN";
    }

    @Override
    public DataValueDescriptor recycle() {
        if (this.immutable) {
            return new SQLBoolean();
        }
        return super.recycle();
    }

    @Override
    public int getTypeFormatId() {
        return 77;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeBoolean(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = in.readBoolean();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = false;
        this.isnull = true;
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -other.compare(this);
        }
        boolean thisNull = this.isNull();
        boolean otherNull = other.isNull();
        if (thisNull || otherNull) {
            if (!thisNull) {
                return -1;
            }
            if (!otherNull) {
                return 1;
            }
            return 0;
        }
        boolean otherValue = false;
        boolean thisValue = this.getBoolean();
        if (thisValue == (otherValue = other.getBoolean())) {
            return 0;
        }
        if (thisValue && !otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    @Override
    public DataValueDescriptor cloneValue(boolean forceMaterialization) {
        return new SQLBoolean(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBoolean();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getBoolean(colNumber);
        this.isnull = isNullable && resultSet.wasNull();
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -7);
            return;
        }
        ps.setBoolean(position, this.value);
    }

    public SQLBoolean() {
        this.isnull = true;
    }

    public SQLBoolean(boolean val) {
        this.value = val;
    }

    public SQLBoolean(Boolean obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    private SQLBoolean(boolean val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    @Override
    public void setValue(boolean theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(Boolean theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.value = false;
            this.isnull = true;
        } else {
            this.value = theValue;
            this.isnull = false;
        }
    }

    @Override
    public void setValue(byte theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    @Override
    public void setValue(short theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0;
        this.isnull = false;
    }

    @Override
    public void setValue(long theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0L;
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0.0f;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        this.value = theValue != 0.0;
        this.isnull = false;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (bigDecimal == null) {
            this.value = false;
            this.isnull = true;
        } else {
            this.value = BigDecimal.ZERO.compareTo(bigDecimal) != 0;
            this.isnull = false;
        }
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        SanityManager.ASSERT(!this.immutable, "Attempt to set the value of an immutable SQLBoolean");
        if (theValue == null) {
            this.value = false;
            this.isnull = true;
        } else {
            String cleanedValue = StringUtil.SQLToUpperCase(theValue.trim());
            if (cleanedValue.equals("TRUE")) {
                this.value = true;
                this.isnull = false;
            } else if (cleanedValue.equals("FALSE")) {
                this.value = false;
                this.isnull = false;
            } else if (cleanedValue.equals("UNKNOWN")) {
                this.value = false;
                this.isnull = true;
            } else {
                throw this.invalidFormat();
            }
        }
    }

    @Override
    void setObject(Object theValue) {
        this.setValue((Boolean)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLChar) {
            this.setValue(theValue.getString());
        } else if (theValue instanceof SQLBoolean) {
            this.setValue(theValue.getBoolean());
        } else {
            throw StandardException.newException("XCL12.S", theValue.getTypeName(), this.getTypeName());
        }
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getBoolean() == right.getBoolean());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getBoolean() != right.getBoolean());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, !leftBoolean && rightBoolean);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, leftBoolean && !rightBoolean);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, !leftBoolean || rightBoolean);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean leftBoolean = left.getBoolean();
        boolean rightBoolean = right.getBoolean();
        return SQLBoolean.truthValue(left, right, leftBoolean || !rightBoolean);
    }

    @Override
    public BooleanDataValue and(BooleanDataValue otherValue) {
        if (this.equals(false) || otherValue.equals(false)) {
            return BOOLEAN_FALSE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)otherValue, this.getBoolean() && otherValue.getBoolean());
    }

    @Override
    public BooleanDataValue or(BooleanDataValue otherValue) {
        if (this.equals(true) || otherValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        return SQLBoolean.truthValue((DataValueDescriptor)this, (DataValueDescriptor)otherValue, this.getBoolean() || otherValue.getBoolean());
    }

    @Override
    public BooleanDataValue is(BooleanDataValue otherValue) {
        if (this.equals(true) && otherValue.equals(true)) {
            return BOOLEAN_TRUE;
        }
        if (this.equals(false) && otherValue.equals(false)) {
            return BOOLEAN_TRUE;
        }
        if (this.isNull() && otherValue.isNull()) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    @Override
    public BooleanDataValue isNot(BooleanDataValue otherValue) {
        BooleanDataValue isValue = this.is(otherValue);
        if (isValue.equals(true)) {
            return BOOLEAN_FALSE;
        }
        return BOOLEAN_TRUE;
    }

    @Override
    public BooleanDataValue throwExceptionIfFalse(String sqlState, String tableName, String constraintName) throws StandardException {
        if (!this.isNull() && !this.value) {
            throw StandardException.newException(sqlState, tableName, constraintName);
        }
        return this;
    }

    @Override
    public BooleanDataValue throwExceptionIfImmediateAndFalse(String sqlState, String tableName, String constraintName, Activation a, int savedUUIDIdx) throws StandardException {
        if (!this.isNull() && !this.value) {
            ExecPreparedStatement ps = a.getPreparedStatement();
            UUID constrId = (UUID)ps.getSavedObject(savedUUIDIdx);
            LanguageConnectionContext lcc = a.getLanguageConnectionContext();
            boolean isDeferred = lcc.isEffectivelyDeferred(lcc.getCurrentSQLSessionContext(a), constrId);
            if (!isDeferred) {
                throw StandardException.newException(sqlState, tableName, constraintName);
            }
            DMLWriteResultSet rs = (DMLWriteResultSet)a.getResultSet();
            rs.rememberConstraint(constrId);
        }
        return this;
    }

    @Override
    public int typePrecedence() {
        return 130;
    }

    public static SQLBoolean truthValue(DataValueDescriptor leftOperand, DataValueDescriptor rightOperand, boolean truth) {
        if (leftOperand.isNull() || rightOperand.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        if (truth) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(DataValueDescriptor leftOperand, DataValueDescriptor rightOperand, Boolean truth) {
        if (leftOperand.isNull() || rightOperand.isNull() || truth == null) {
            return SQLBoolean.unknownTruthValue();
        }
        if (truth == Boolean.TRUE) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean truthValue(boolean value) {
        if (value) {
            return BOOLEAN_TRUE;
        }
        return BOOLEAN_FALSE;
    }

    public static SQLBoolean unknownTruthValue() {
        return UNKNOWN;
    }

    @Override
    public boolean equals(boolean val) {
        if (this.isNull()) {
            return false;
        }
        return this.value == val;
    }

    @Override
    public BooleanDataValue getImmutable() {
        if (this.isNull()) {
            return UNKNOWN;
        }
        return this.value ? BOOLEAN_TRUE : BOOLEAN_FALSE;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.value) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        if (this.isNull()) {
            return -1;
        }
        return this.value ? 1 : 0;
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    static {
        SQLBoolean.BOOLEAN_TRUE.immutable = true;
        SQLBoolean.BOOLEAN_FALSE.immutable = true;
        SQLBoolean.UNKNOWN.immutable = true;
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLBoolean.class);
    }
}

