/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.AbstractElement;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;
import org.eclipse.net4j.util.security.IPasswordCredentials;

public class CDORepositoryProperties
extends Properties<CDORepository> {
    public static final IProperties<CDORepository> INSTANCE = new CDORepositoryProperties();
    public static final String CATEGORY_REPOSITORY = "Repository";

    private CDORepositoryProperties() {
        super(CDORepository.class);
        this.add((Property)new Property<CDORepository>("state"){

            protected Object eval(CDORepository repository) {
                return repository.getState();
            }
        });
        this.add((Property)new Property<CDORepository>("error"){

            protected Object eval(CDORepository repository) {
                return repository.getError();
            }
        });
        this.add((Property)new Property<CDORepository>("hasError"){

            protected Object eval(CDORepository repository) {
                return !StringUtil.isEmpty((String)repository.getError());
            }
        });
        this.add((Property)new Property<CDORepository>("sessionRefs"){

            protected Object eval(CDORepository repository) {
                return ((CDORepositoryImpl)repository).getSessionRefCount();
            }
        });
        this.add((Property)new Property<CDORepository>("connected", "Connected", "Whether this repository is connected", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                return repository.isConnected();
            }
        });
        this.add((Property)new Property<CDORepository>("type", "Type", "The type of this repository", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                return repository.getType();
            }
        });
        this.add((Property)new Property<CDORepository>("id", "ID", "The ID of this repository", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                return repository.getID();
            }
        });
        this.add((Property)new Property<CDORepository>("label", "Label", "The label of this repository", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                return repository.getLabel();
            }
        });
        this.add((Property)new Property<CDORepository>("folder", "Folder", "The folder of this repository", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                return ((AbstractElement)((Object)repository)).getFolder();
            }
        });
        this.add((Property)new Property<CDORepository>("uri", "URI", "The URI of this repository", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                return repository.getURI();
            }
        });
        this.add((Property)new Property<CDORepository>("authenticating", "Authenticating", "Whether this repository is authenticating", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                return repository.isAuthenticating();
            }
        });
        this.add((Property)new Property<CDORepository>("userID", "User", "The user ID of this repository", CATEGORY_REPOSITORY){

            protected Object eval(CDORepository repository) {
                IPasswordCredentials credentials = repository.getCredentials();
                return credentials == null ? null : credentials.getUserID();
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    public static final class Tester
    extends DefaultPropertyTester<CDORepository> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.explorer.repository";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

