/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryElement;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryManagerImpl;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;

public class CDOExplorerAdapterFactory
implements IAdapterFactory {
    private static final Class<CDORepositoryElement> CLASS_CDOREPOSITORYELEMENT = CDORepositoryElement.class;
    private static final Class<?>[] CLASSES = new Class[]{CLASS_CDOREPOSITORYELEMENT};

    public Class<?>[] getAdapterList() {
        return CLASSES;
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == CLASS_CDOREPOSITORYELEMENT) {
            if (adaptableObject instanceof CDOBranch) {
                adaptableObject = ((CDOBranch)adaptableObject).getHead();
            }
            if (adaptableObject instanceof CDOBranchPoint) {
                CDOBranchPoint branchPoint = (CDOBranchPoint)adaptableObject;
                final CDOBranch branch = branchPoint.getBranch();
                final long timeStamp = branchPoint.getTimeStamp();
                CDOCommonRepository commonRepository = branch.getBranchManager().getRepository();
                if (commonRepository instanceof CDORepositoryInfo) {
                    CDORepositoryInfo repositoryInfo = (CDORepositoryInfo)commonRepository;
                    final CDOID objectID = repositoryInfo.getRootResourceID();
                    CDORepositoryManagerImpl repositoryManager = (CDORepositoryManagerImpl)CDOExplorerUtil.getRepositoryManager();
                    final CDORepository repository = repositoryManager.getRepository(repositoryInfo.getSession());
                    if (repository != null) {
                        return (T)new CDORepositoryElement(){

                            @Override
                            public CDORepository getRepository() {
                                return repository;
                            }

                            @Override
                            public int getBranchID() {
                                return branch.getID();
                            }

                            public long getTimeStamp() {
                                return timeStamp;
                            }

                            @Override
                            public CDOID getObjectID() {
                                return objectID;
                            }
                        };
                    }
                }
            }
        }
        return null;
    }
}

