/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.security.NoPermissionException;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.SystemElement;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.IAssemblyManager;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.internal.client.LMManager;
import org.eclipse.emf.cdo.lm.internal.client.SystemDescriptor;
import org.eclipse.emf.cdo.lm.internal.client.bundle.OM;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.om.job.OMJob;

public final class SystemManager
extends LMManager<CDORepository, CDORepositoryManager, ISystemDescriptor>
implements ISystemManager {
    public static final SystemManager INSTANCE = new SystemManager();
    private static final String PROP_OPEN = "open";
    private final Map<String, ISystemDescriptor> descriptorsBySystemName = new HashMap<String, ISystemDescriptor>();
    private final Set<CDORepository> analyzingRepositories = Collections.synchronizedSet(new HashSet());

    private SystemManager() {
        super(CDOExplorerUtil.getRepositoryManager(), CDORepository.class);
    }

    @Override
    public void refresh() {
        this.forEachExplorerElement(repository -> {
            ISystemDescriptor descriptor = (ISystemDescriptor)this.getDescriptor(repository);
            if (descriptor == SystemDescriptor.NO_SYSTEM) {
                this.deleteStateFolder(repository);
                descriptor = null;
            }
            if (descriptor == null) {
                this.addDescriptor((CDORepository)repository);
            }
        });
    }

    @Override
    public ISystemDescriptor[] getDescriptors() {
        Object[] array = (ISystemDescriptor[])super.getDescriptors();
        Arrays.sort(array);
        return array;
    }

    @Override
    protected boolean filterDescriptor(ISystemDescriptor descriptor) {
        return descriptor != SystemDescriptor.NO_SYSTEM;
    }

    protected ISystemDescriptor[] newArray(int size) {
        return new ISystemDescriptor[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISystemDescriptor getDescriptor(String systemName) {
        SystemManager systemManager = this;
        synchronized (systemManager) {
            return this.descriptorsBySystemName.get(systemName);
        }
    }

    @Override
    public ISystemDescriptor getDescriptor(String systemName, long timeout) throws TimeoutRuntimeException {
        long deadline = java.lang.System.currentTimeMillis() + timeout;
        SystemManager systemManager = this;
        synchronized (systemManager) {
            while (java.lang.System.currentTimeMillis() < deadline) {
                ISystemDescriptor descriptor = this.descriptorsBySystemName.get(systemName);
                if (descriptor != null) {
                    return descriptor;
                }
                try {
                    this.wait(10L);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    break;
                }
            }
            throw new TimeoutRuntimeException("System " + systemName + " is not available after " + timeout + " milliseconds");
        }
    }

    @Override
    public ISystemDescriptor getDescriptor(EObject object) {
        if (object instanceof System) {
            System system = (System)object;
            String systemName = system.getName();
            return this.getDescriptor(systemName);
        }
        SystemElement systemElement = (SystemElement)EMFUtil.getNearestObject((EObject)object, SystemElement.class);
        if (systemElement != null) {
            System system = systemElement.getSystem();
            String systemName = system.getName();
            return this.getDescriptor(systemName);
        }
        IAssemblyDescriptor assemblyDescriptor = IAssemblyManager.INSTANCE.getDescriptor(object);
        if (assemblyDescriptor != null) {
            return assemblyDescriptor.getSystemDescriptor();
        }
        return SystemManager.getSessionProperty(object, SystemDescriptor::getSystemDescriptor);
    }

    @Override
    public String getModuleName(EObject object) {
        return SystemManager.getSessionProperty(object, SystemDescriptor::getModuleName);
    }

    public void fireDescriptorStateEvent(ISystemDescriptor systemDescriptor, System system, boolean open) {
        CDORepository systemRepository = systemDescriptor.getSystemRepository();
        Properties properties = SystemManager.loadLMProperties(systemRepository);
        if (Boolean.parseBoolean(properties.getProperty(PROP_OPEN, "false")) != open) {
            properties.put(PROP_OPEN, Boolean.toString(open));
            this.saveLMProperties(systemRepository, properties);
        }
        this.fireEvent(new DescriptorStateEventImpl(this, systemDescriptor, system, open));
    }

    public void fireModuleCreatedEvent(SystemDescriptor systemDescriptor, Module newModule) {
        this.fireEvent(new ModuleCreatedEventImpl(this, systemDescriptor, newModule));
    }

    public void fireModuleDeletedEvent(SystemDescriptor systemDescriptor, CDOID deletedModuleID) {
        this.fireEvent(new ModuleDeletedEventImpl(this, systemDescriptor, deletedModuleID));
    }

    public void fireBaselineCreatedEvent(SystemDescriptor systemDescriptor, Baseline newBaseline) {
        this.fireEvent(new BaselineCreatedEventImpl(this, systemDescriptor, newBaseline));
    }

    public void fireStreamBranchChangedEvent(SystemDescriptor systemDescriptor, Stream stream, CDOBranchRef newBranch) {
        this.fireEvent(new StreamBranchChangedEventImpl(this, systemDescriptor, stream, newBranch));
    }

    public void scheduleOpenSystem(final ISystemDescriptor descriptor) {
        final String systemName = descriptor.getSystemName();
        SystemManager.schedule(new OMJob("Open " + systemName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    descriptor.open();
                }
                catch (Exception ex) {
                    OM.LOG.error("Failed to open system " + systemName, (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        });
    }

    @Override
    protected void explorerElementAdded(CDORepository repository) {
        ISystemDescriptor descriptor = (ISystemDescriptor)this.getDescriptor(repository);
        if (descriptor == null) {
            this.addDescriptor(repository);
        }
    }

    @Override
    protected void explorerElementRemoved(CDORepository repository) {
        RepositoryType repositoryType = RepositoryType.of(repository);
        if (repositoryType == RepositoryType.SYSTEM) {
            this.removeDescriptor(repository);
        } else if (repositoryType == RepositoryType.MODULE) {
            ISystemDescriptor[] iSystemDescriptorArray = this.getDescriptors();
            int n = iSystemDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISystemDescriptor descriptor = iSystemDescriptorArray[n2];
                if (((SystemDescriptor)descriptor).unregisterModuleRepository(repository)) break;
                ++n2;
            }
        }
    }

    protected void repositoryConnected(CDORepository repository) {
        RepositoryType repositoryType = RepositoryType.of(repository);
        if (repositoryType == RepositoryType.MODULE) {
            Properties lmProperties = SystemManager.loadLMProperties(repository);
            String systemName = lmProperties.getProperty("systemName");
            String moduleName = lmProperties.getProperty("moduleName");
            ISystemDescriptor systemDescriptor = this.getDescriptor(systemName);
            if (systemDescriptor != null) {
                CDOSession moduleSession = repository.getSession();
                SystemDescriptor.setSessionProperties(moduleSession, systemDescriptor, moduleName);
            }
            return;
        }
        ISystemDescriptor descriptor = (ISystemDescriptor)this.getDescriptor(repository);
        if (descriptor == null) {
            this.addDescriptor(repository);
        }
    }

    protected void repositoryDisconnected(CDORepository repository) {
        ISystemDescriptor descriptor = (ISystemDescriptor)this.getDescriptor(repository);
        if (descriptor != null && this.filterDescriptor(descriptor)) {
            descriptor.close();
        }
    }

    @Override
    protected void notifyExplorerElementEvent(IEvent event) {
        if (event instanceof CDORepositoryManager.RepositoryConnectionEvent) {
            CDORepositoryManager.RepositoryConnectionEvent e = (CDORepositoryManager.RepositoryConnectionEvent)event;
            if (e.isConnected()) {
                this.repositoryConnected(e.getRepository());
            } else {
                this.repositoryDisconnected(e.getRepository());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDescriptor(CDORepository repository) {
        RepositoryType repositoryType = RepositoryType.of(repository);
        if (repositoryType == null) {
            this.scheduleAnalyzeRepository(repository);
            return;
        }
        if (repositoryType != RepositoryType.SYSTEM) {
            SystemManager systemManager = this;
            synchronized (systemManager) {
                this.descriptors.put(repository, SystemDescriptor.NO_SYSTEM);
            }
            return;
        }
        Properties lmProperties = SystemManager.loadLMProperties(repository);
        String systemName = lmProperties.getProperty("systemName");
        SystemDescriptor descriptor = new SystemDescriptor(repository, systemName);
        boolean open = Boolean.parseBoolean(lmProperties.getProperty(PROP_OPEN, "false"));
        SystemManager systemManager = this;
        synchronized (systemManager) {
            this.descriptors.put(repository, descriptor);
            this.descriptorsBySystemName.put(systemName, descriptor);
            ++this.count;
            this.notifyAll();
        }
        this.fireElementAddedEvent(descriptor);
        if (open) {
            this.scheduleOpenSystem(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDescriptor(CDORepository repository) {
        ISystemDescriptor descriptor;
        SystemManager systemManager = this;
        synchronized (systemManager) {
            descriptor = (ISystemDescriptor)this.descriptors.remove(repository);
            if (descriptor != null && this.filterDescriptor(descriptor)) {
                --this.count;
                this.descriptorsBySystemName.remove(descriptor.getSystemName());
                this.notifyAll();
            }
        }
        if (descriptor != null && this.filterDescriptor(descriptor)) {
            this.fireElementRemovedEvent(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String querySystemName(CDORepository repository) throws RepositoryConnectionException {
        CDORepository cDORepository = repository;
        synchronized (cDORepository) {
            CDOSession session = null;
            try {
                EObject root;
                session = repository.acquireSession();
                CDOView view = session.openView();
                CDOResource resource = view.getResource("/system");
                EList contents = resource.getContents();
                if (!contents.isEmpty() && (root = (EObject)contents.get(0)) instanceof System) {
                    System system = (System)root;
                    String string = system.getName();
                    return string;
                }
            }
            catch (NoPermissionException | CDOResourceNodeNotFoundException | InvalidURIException view) {
            }
            catch (Exception ex) {
                throw new RepositoryConnectionException(ex);
            }
            finally {
                if (session != null) {
                    repository.releaseSession();
                }
            }
            return null;
        }
    }

    private void scheduleAnalyzeRepository(final CDORepository repository) {
        if (this.analyzingRepositories.add(repository)) {
            repository.connect();
            SystemManager.schedule(new OMJob("Analyze " + repository.getName()){

                /*
                 * Exception decompiling
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        }
    }

    private static void schedule(OMJob job) {
        job.setSystem(true);
        job.schedule();
    }

    private static <T> T getSessionProperty(EObject object, Function<CDOSession, T> function) {
        CDOSession session;
        CDOView view;
        CDOObject cdoObject = CDOUtil.getCDOObject((EObject)object);
        if (cdoObject != null && (view = cdoObject.cdoView()) != null && (session = view.getSession()) != null) {
            return function.apply(session);
        }
        return null;
    }

    private static final class BaselineCreatedEventImpl
    extends SystemEventImpl
    implements ISystemManager.BaselineCreatedEvent {
        private static final long serialVersionUID = 1L;
        private final Baseline newBaseline;

        public BaselineCreatedEventImpl(SystemManager manager, ISystemDescriptor systemDescriptor, Baseline newBaseline) {
            super(manager, systemDescriptor);
            this.newBaseline = newBaseline;
        }

        @Override
        public Baseline getNewBaseline() {
            return this.newBaseline;
        }

        protected String formatEventName() {
            return ISystemManager.BaselineCreatedEvent.class.getSimpleName();
        }

        @Override
        protected String formatAdditionalParameters() {
            return super.formatAdditionalParameters() + ", baseline=" + this.newBaseline.getName();
        }
    }

    private static final class DescriptorStateEventImpl
    extends SystemEventImpl
    implements ISystemManager.DescriptorStateEvent {
        private static final long serialVersionUID = 1L;
        private final System system;
        private final boolean open;

        public DescriptorStateEventImpl(SystemManager manager, ISystemDescriptor systemDescriptor, System system, boolean open) {
            super(manager, systemDescriptor);
            this.system = system;
            this.open = open;
        }

        @Override
        public System getSystem() {
            return this.system;
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        protected String formatEventName() {
            return ISystemManager.DescriptorStateEvent.class.getSimpleName();
        }

        @Override
        protected String formatAdditionalParameters() {
            return super.formatAdditionalParameters() + ", open=" + this.open;
        }
    }

    private static final class ModuleCreatedEventImpl
    extends SystemEventImpl
    implements ISystemManager.ModuleCreatedEvent {
        private static final long serialVersionUID = 1L;
        private final Module newModule;

        public ModuleCreatedEventImpl(SystemManager manager, ISystemDescriptor systemDescriptor, Module newModule) {
            super(manager, systemDescriptor);
            this.newModule = newModule;
        }

        @Override
        public Module getNewModule() {
            return this.newModule;
        }

        protected String formatEventName() {
            return ISystemManager.ModuleCreatedEvent.class.getSimpleName();
        }

        @Override
        protected String formatAdditionalParameters() {
            return super.formatAdditionalParameters() + ", module=" + this.newModule.getName();
        }
    }

    private static final class ModuleDeletedEventImpl
    extends SystemEventImpl
    implements ISystemManager.ModuleDeletedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOID deletedModuleID;

        public ModuleDeletedEventImpl(SystemManager manager, ISystemDescriptor systemDescriptor, CDOID deletedModuleID) {
            super(manager, systemDescriptor);
            this.deletedModuleID = deletedModuleID;
        }

        @Override
        public CDOID getDeletedModuleID() {
            return this.deletedModuleID;
        }

        protected String formatEventName() {
            return ISystemManager.ModuleDeletedEvent.class.getSimpleName();
        }

        @Override
        protected String formatAdditionalParameters() {
            return super.formatAdditionalParameters() + ", deletedModuleID=" + String.valueOf(this.deletedModuleID);
        }
    }

    private static final class RepositoryConnectionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RepositoryConnectionException(Throwable cause) {
            super(cause);
        }
    }

    public static enum RepositoryType {
        SYSTEM("org.eclipse.emf.cdo.lm.System"),
        MODULE("org.eclipse.emf.cdo.lm.Module"),
        UNRELATED("org.eclipse.emf.cdo.lm.Unrelated");

        private final String keyword;

        private RepositoryType(String keyword) {
            this.keyword = keyword;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public void addKeywordTo(CDORepository repository) {
            repository.addKeyword(this.keyword);
        }

        public static RepositoryType of(CDORepository repository) {
            RepositoryType[] repositoryTypeArray = RepositoryType.values();
            int n = repositoryTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryType repositoryType = repositoryTypeArray[n2];
                if (repository.hasKeyword(repositoryType.keyword)) {
                    return repositoryType;
                }
                ++n2;
            }
            return null;
        }
    }

    private static final class StreamBranchChangedEventImpl
    extends SystemEventImpl
    implements ISystemManager.StreamBranchChangedEvent {
        private static final long serialVersionUID = 1L;
        private final Stream stream;
        private final CDOBranchRef newBranch;

        public StreamBranchChangedEventImpl(SystemManager manager, ISystemDescriptor systemDescriptor, Stream stream, CDOBranchRef newBranch) {
            super(manager, systemDescriptor);
            this.stream = stream;
            this.newBranch = newBranch;
        }

        @Override
        public Stream getStream() {
            return this.stream;
        }

        @Override
        public CDOBranchRef getNewBranch() {
            return this.newBranch;
        }

        @Override
        protected String formatAdditionalParameters() {
            return super.formatAdditionalParameters() + ", stream=" + this.stream.getName() + ", newBranch=" + String.valueOf(this.newBranch);
        }
    }

    protected static abstract class SystemEventImpl
    extends Event
    implements ISystemManager.SystemEvent {
        private static final long serialVersionUID = 1L;
        private final ISystemDescriptor systemDescriptor;

        public SystemEventImpl(SystemManager manager, ISystemDescriptor systemDescriptor) {
            super((INotifier)manager);
            this.systemDescriptor = systemDescriptor;
        }

        @Override
        public final ISystemDescriptor getSystemDescriptor() {
            return this.systemDescriptor;
        }

        @Override
        public System getSystem() {
            return this.systemDescriptor.getSystem();
        }

        protected String formatAdditionalParameters() {
            return "system=" + String.valueOf(this.systemDescriptor);
        }
    }
}

