/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.emf.cdo.admin.CDOAdminClient;
import org.eclipse.emf.cdo.admin.CDOAdminClientManager;
import org.eclipse.emf.cdo.internal.admin.CDOAdminClientImpl;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.concurrent.ExecutorServiceFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.SetContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class CDOAdminClientManagerImpl
extends SetContainer<CDOAdminClient>
implements CDOAdminClientManager {
    private final IManagedContainer container;
    private final ExecutorService executorService;

    public CDOAdminClientManagerImpl(IManagedContainer container) {
        super(CDOAdminClient.class);
        this.container = container;
        this.executorService = ExecutorServiceFactory.get((IManagedContainer)container);
    }

    public final IManagedContainer getContainer() {
        return this.container;
    }

    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public CDOAdminClient[] getConnections() {
        return (CDOAdminClient[])this.getElements();
    }

    @Override
    public List<String> getConnectionURLs() {
        ArrayList<String> urls = new ArrayList<String>();
        CDOAdminClient[] cDOAdminClientArray = this.getConnections();
        int n = cDOAdminClientArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOAdminClient connection = cDOAdminClientArray[n2];
            urls.add(connection.getURL());
            ++n2;
        }
        return urls;
    }

    @Override
    public CDOAdminClient getConnection(String url) {
        CDOAdminClient[] cDOAdminClientArray = this.getConnections();
        int n = cDOAdminClientArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOAdminClient connection = cDOAdminClientArray[n2];
            if (ObjectUtil.equals((Object)connection.getURL(), (Object)url)) {
                return connection;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public int setConnections(Collection<String> urls) {
        HashSet<String> added = new HashSet<String>();
        for (String url : urls) {
            if (!added.add(url)) continue;
            this.addConnection(url);
        }
        CDOAdminClient[] cDOAdminClientArray = this.getConnections();
        int n = cDOAdminClientArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOAdminClient connection = cDOAdminClientArray[n2];
            if (!added.contains(connection.getURL())) {
                this.removeConnection(connection);
            }
            ++n2;
        }
        return added.size();
    }

    @Override
    public boolean setConnection(String url) {
        return this.setConnections(Collections.singleton(url)) == 1;
    }

    @Override
    public int addConnections(Collection<String> urls) {
        int count = 0;
        for (String url : urls) {
            if (!this.addConnection(url)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean addConnection(String url) {
        CDOAdminClientImpl connection;
        if (this.getConnection(url) == null && this.addElement(connection = new CDOAdminClientImpl(url, 10000L, this.container))) {
            LifecycleUtil.activate((Object)connection);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConnection(CDOAdminClient connection) {
        return this.removeElement(connection);
    }
}

