/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionImpl;
import org.eclipse.emf.cdo.internal.net4j.CDOSessionRecoveryEventImpl;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.net4j.CDOSessionRecoveryEvent;
import org.eclipse.emf.cdo.net4j.CDOSessionRecoveryException;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionEvent;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.internal.cdo.view.CDOViewImpl;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.heartbeat.HeartBeatProtocol;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public abstract class RecoveringCDOSessionImpl
extends CDONet4jSessionImpl {
    private IManagedContainer container;
    private String repositoryConnectorDescription;
    private boolean useHeartBeat;
    private long heartBeatPeriod = 1000L;
    private long heartBeatTimeout = 5000L;
    private long connectorTimeout = 10000L;

    public RecoveringCDOSessionImpl() {
        this.setExceptionHandler(new RecoveringExceptionHandler());
    }

    public long getConnectorTimeout() {
        return this.connectorTimeout;
    }

    public void setConnectorTimeout(long connectorTimeout) {
        this.connectorTimeout = connectorTimeout;
    }

    public void setContainer(IManagedContainer container) {
        this.container = container;
    }

    @Override
    public IManagedContainer getContainer() {
        return this.container;
    }

    public void setUseHeartBeat(boolean useHeartBeat) {
        this.useHeartBeat = useHeartBeat;
    }

    public boolean getUseHeartBeat() {
        return this.useHeartBeat;
    }

    public void setHeartBeatTimeout(long timeout) {
        this.heartBeatTimeout = timeout;
    }

    public long getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatPeriod(long period) {
        this.heartBeatPeriod = period;
    }

    public long getHeartBeatPeriod() {
        return this.heartBeatPeriod;
    }

    protected void sessionProtocolDeactivated() {
        this.recover(1, null);
    }

    protected void recover(int attempt, TransportException exception) {
        OM.LOG.info("Transport exception (" + attempt + ". attempt to recover)", (Throwable)exception);
        this.fireEvent((IEvent)this.createRecoveryStartedEvent(attempt, exception));
        this.recover();
        this.fireEvent((IEvent)this.createRecoveryFinishedEvent(attempt, exception));
    }

    protected void recover() {
        CDOSessionProtocol oldSessionProtocol = this.getSessionProtocol();
        this.unhookSessionProtocol();
        List<AfterRecoveryRunnable> runnables = this.recoverSession();
        CDOSessionProtocol newSessionProtocol = this.getSessionProtocol();
        if (newSessionProtocol != oldSessionProtocol) {
            this.handleProtocolChange(oldSessionProtocol, newSessionProtocol);
        }
        for (AfterRecoveryRunnable runnable : runnables) {
            runnable.run(newSessionProtocol);
        }
        boolean passiveUpdateEnabled = this.options().isPassiveUpdateEnabled();
        this.refresh(passiveUpdateEnabled);
    }

    protected void handleProtocolChange(CDOSessionProtocol oldProtocol, CDOSessionProtocol newProtocol) {
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        revisionManager.deactivate();
        revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)newProtocol);
        revisionManager.activate();
        InternalCDOBranchManager branchManager = this.getBranchManager();
        branchManager.deactivate();
        branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)newProtocol);
        branchManager.activate();
        InternalCDOCommitInfoManager commitInfoManager = this.getCommitInfoManager();
        commitInfoManager.deactivate();
        commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)newProtocol);
        commitInfoManager.activate();
    }

    @Deprecated
    protected CDOSessionEvent createRecoveryStartedEvent() {
        return this.createRecoveryStartedEvent(0, null);
    }

    protected CDOSessionEvent createRecoveryStartedEvent(int attempt, TransportException exception) {
        return new CDOSessionRecoveryEventImpl(this, CDOSessionRecoveryEvent.Type.STARTED, attempt, exception);
    }

    @Deprecated
    protected CDOSessionEvent createRecoveryFinishedEvent() {
        return this.createRecoveryFinishedEvent(0, null);
    }

    protected CDOSessionEvent createRecoveryFinishedEvent(int attempt, TransportException exception) {
        return new CDOSessionRecoveryEventImpl(this, CDOSessionRecoveryEvent.Type.FINISHED, attempt, exception);
    }

    protected IConnector createTCPConnector(boolean heartBeat) {
        IConnector connector = this.getTCPConnector(this.repositoryConnectorDescription);
        if (heartBeat) {
            new HeartBeatProtocol(connector, this.container).start(this.heartBeatPeriod, this.heartBeatTimeout);
        }
        connector.addListener((IListener)new AutoCloser());
        return connector;
    }

    protected IConnector getTCPConnector(String description) {
        IManagedContainer container = this.getContainer();
        return Net4jUtil.getConnector((IManagedContainer)container, (String)"tcp", (String)description, (long)this.connectorTimeout);
    }

    protected List<AfterRecoveryRunnable> recoverSession() throws CDOSessionRecoveryException {
        try {
            ArrayList<AfterRecoveryRunnable> runnables = new ArrayList<AfterRecoveryRunnable>();
            InternalCDOView[] internalCDOViewArray = this.getViews();
            int n = internalCDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                InternalCDOView view = internalCDOViewArray[n2];
                runnables.add(new OpenViewRunnable(view));
                ++n2;
            }
            this.updateConnectorAndRepositoryName();
            this.openSession();
            CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
            sessionProtocol.openedSession();
            return runnables;
        }
        catch (CDOSessionRecoveryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CDOSessionRecoveryException(this, ex);
        }
    }

    public void setSessionProtocol(CDOSessionProtocol sessionProtocol) {
        super.setSessionProtocol(sessionProtocol);
        LifecycleUtil.activate((Object)this.getSessionProtocol());
    }

    protected IConnector removeTCPConnector() {
        return (IConnector)this.container.removeElement("org.eclipse.net4j.connectors", "tcp", this.repositoryConnectorDescription);
    }

    protected void setRepositoryConnectorDescription(String description) {
        this.repositoryConnectorDescription = description;
    }

    protected String getRepositoryConnectorDescription() {
        return this.repositoryConnectorDescription;
    }

    @Override
    protected void doActivate() throws Exception {
        this.updateConnectorAndRepositoryName();
        super.doActivate();
    }

    protected abstract void updateConnectorAndRepositoryName() throws CDOSessionRecoveryException;

    public static interface AfterRecoveryRunnable {
        public void run(CDOSessionProtocol var1);
    }

    private static final class AutoCloser
    implements IListener {
        private AutoCloser() {
        }

        public void notifyEvent(IEvent event) {
            IConnector connector;
            IContainerEvent containerEvent;
            if (event instanceof IContainerEvent && (containerEvent = (IContainerEvent)event).getDelta().getKind() == IContainerDelta.Kind.REMOVED && (connector = (IConnector)event.getSource()).getChannels().size() == 0) {
                LifecycleUtil.deactivate((Object)connector);
            }
        }
    }

    private static final class OpenViewRunnable
    implements AfterRecoveryRunnable {
        private final int viewID;
        private final boolean transaction;
        private final String durableLockingID;
        private final CDOViewImpl.DurableLockProcessor durableLockProcessor;
        private final CDOBranchPoint branchPoint;
        private final CDOViewImpl.OptionsImpl options;

        public OpenViewRunnable(InternalCDOView view) {
            this.viewID = view.getViewID();
            this.transaction = view instanceof CDOTransaction;
            this.durableLockingID = view.getDurableLockingID();
            if (this.durableLockingID == null) {
                this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
                this.durableLockProcessor = null;
            } else {
                this.branchPoint = null;
                this.durableLockProcessor = ((CDOViewImpl)view).createDurableLockProcessor();
            }
            this.options = (CDOViewImpl.OptionsImpl)view.options();
        }

        @Override
        public void run(CDOSessionProtocol sessionProtocol) {
            if (this.durableLockingID != null) {
                sessionProtocol.openView(this.viewID, !this.transaction, this.durableLockingID, (BiConsumer)this.durableLockProcessor);
                this.durableLockProcessor.run();
            } else {
                sessionProtocol.openView(this.viewID, !this.transaction, this.branchPoint);
            }
            this.options.recoverView();
        }
    }

    private class RecoveringExceptionHandler
    implements CDOSession.ExceptionHandler {
        private RecoveringExceptionHandler() {
        }

        public void handleException(CDOSession session, int attempt, Exception exception) throws Exception {
            if (!(exception instanceof TransportException)) {
                throw exception;
            }
            RecoveringCDOSessionImpl.this.recover(attempt, (TransportException)exception);
        }
    }
}

