/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.preferences;

import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.prefs.OMPreferencePage;
import org.eclipse.net4j.util.ui.widgets.TextAndDisable;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CDOPreferencePage
extends OMPreferencePage {
    private Text repositoryName;
    private Text userName;
    private Text connectorDescription;
    private TextAndDisable referenceChunkSize;
    private TextAndDisable preloadChunkSize;
    private Button invalidationNotifications;

    public CDOPreferencePage() {
        super(OM.PREFS);
    }

    protected Control createUI(Composite parent) {
        Composite composite = UIUtil.createGridComposite((Composite)parent, (int)1);
        ((GridLayout)composite.getLayout()).verticalSpacing = 5;
        composite.setLayoutData((Object)UIUtil.createGridData());
        Group sessionGroup = new Group(composite, 0);
        sessionGroup.setLayout((Layout)new GridLayout(2, false));
        sessionGroup.setText(Messages.getString("CDOPreferencePage.0"));
        sessionGroup.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        new Label((Composite)sessionGroup, 0).setText(Messages.getString("CDOPreferencePage.1"));
        this.repositoryName = new Text((Composite)sessionGroup, 2048);
        this.repositoryName.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        new Label((Composite)sessionGroup, 0).setText(Messages.getString("CDOPreferencePage.2"));
        this.userName = new Text((Composite)sessionGroup, 2048);
        this.userName.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        new Label((Composite)sessionGroup, 0).setText(Messages.getString("CDOPreferencePage.3"));
        this.connectorDescription = new Text((Composite)sessionGroup, 2048);
        this.connectorDescription.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        new Label((Composite)sessionGroup, 0).setText(Messages.getString("CDOPreferencePage.4"));
        this.referenceChunkSize = new TextAndDisable((Composite)sessionGroup, 2048, String.valueOf(-1));
        this.referenceChunkSize.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        Group viewGroup = new Group(composite, 0);
        viewGroup.setLayout((Layout)new GridLayout(2, false));
        viewGroup.setText(Messages.getString("CDOPreferencePage.5"));
        viewGroup.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        new Label((Composite)viewGroup, 0).setText(Messages.getString("CDOPreferencePage.6"));
        this.preloadChunkSize = new TextAndDisable((Composite)viewGroup, 2048, String.valueOf(1));
        this.preloadChunkSize.setLayoutData((Object)UIUtil.createGridData((boolean)true, (boolean)false));
        new Label((Composite)viewGroup, 0).setText(Messages.getString("CDOPreferencePage.7"));
        this.invalidationNotifications = new Button((Composite)viewGroup, 32);
        this.initValues();
        return composite;
    }

    protected void initValues() {
        this.repositoryName.setText((String)OM.PREF_REPOSITORY_NAME.getValue());
        this.userName.setText((String)OM.PREF_USER_NAME.getValue());
        this.connectorDescription.setText((String)OM.PREF_CONNECTOR_DESCRIPTION.getValue());
        this.referenceChunkSize.setValue(String.valueOf(OM.PREF_COLLECTION_LOADING_CHUNK_SIZE.getValue()));
        this.preloadChunkSize.setValue(String.valueOf(OM.PREF_REVISION_LOADING_CHUNK_SIZE.getValue()));
        this.invalidationNotifications.setSelection(((Boolean)OM.PREF_ENABLE_INVALIDATION_NOTIFICATION.getValue()).booleanValue());
    }

    public boolean performOk() {
        OM.PREF_REPOSITORY_NAME.setValue((Object)this.repositoryName.getText());
        OM.PREF_USER_NAME.setValue((Object)this.userName.getText());
        OM.PREF_CONNECTOR_DESCRIPTION.setValue((Object)this.connectorDescription.getText());
        OM.PREF_COLLECTION_LOADING_CHUNK_SIZE.setValue((Object)Integer.parseInt(this.referenceChunkSize.getValue()));
        OM.PREF_REVISION_LOADING_CHUNK_SIZE.setValue((Object)Integer.parseInt(this.preloadChunkSize.getValue()));
        OM.PREF_ENABLE_INVALIDATION_NOTIFICATION.setValue((Object)this.invalidationNotifications.getSelection());
        return super.performOk();
    }
}

