/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.text.MessageFormat;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDeltaWithPosition;
import org.eclipse.net4j.internal.db.ddl.delta.DBPropertyDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBTableDelta;
import org.eclipse.net4j.util.ObjectUtil;

public final class DBFieldDelta
extends DBDeltaWithPosition
implements IDBFieldDelta {
    private static final long serialVersionUID = 1L;

    public DBFieldDelta(DBDelta parent, String name, IDBDelta.ChangeKind changeKind) {
        super(parent, name, changeKind);
    }

    public DBFieldDelta(DBDelta parent, IDBField field, IDBField oldField) {
        this(parent, DBFieldDelta.getName(field, oldField), DBFieldDelta.getChangeKind(field, oldField));
        Integer oldPosition;
        Boolean oldNotNull;
        Integer oldScale;
        Integer oldPrecision;
        DBType oldType;
        DBType type = field == null ? null : field.getType();
        DBType dBType = oldType = oldField == null ? null : oldField.getType();
        if (!ObjectUtil.equals((Object)((Object)type), (Object)((Object)oldType))) {
            this.addPropertyDelta(new DBPropertyDelta<DBType>(this, "type", IDBPropertyDelta.Type.STRING, type, oldType));
        }
        Integer precision = field == null ? null : Integer.valueOf(field.getPrecision());
        Integer n = oldPrecision = oldField == null ? null : Integer.valueOf(oldField.getPrecision());
        if (!ObjectUtil.equals((Object)precision, (Object)oldPrecision)) {
            this.addPropertyDelta(new DBPropertyDelta<Integer>(this, "precision", IDBPropertyDelta.Type.INTEGER, precision, oldPrecision));
        }
        Integer scale = field == null ? null : Integer.valueOf(field.getScale());
        Integer n2 = oldScale = oldField == null ? null : Integer.valueOf(oldField.getScale());
        if (!ObjectUtil.equals((Object)scale, (Object)oldScale)) {
            this.addPropertyDelta(new DBPropertyDelta<Integer>(this, "scale", IDBPropertyDelta.Type.INTEGER, scale, oldScale));
        }
        Boolean notNull = field == null ? null : Boolean.valueOf(field.isNotNull());
        Boolean bl = oldNotNull = oldField == null ? null : Boolean.valueOf(oldField.isNotNull());
        if (!ObjectUtil.equals((Object)notNull, (Object)oldNotNull)) {
            this.addPropertyDelta(new DBPropertyDelta<Boolean>(this, "notNull", IDBPropertyDelta.Type.BOOLEAN, notNull, oldNotNull));
        }
        Integer position = field == null ? null : Integer.valueOf(field.getPosition());
        Integer n3 = oldPosition = oldField == null ? null : Integer.valueOf(oldField.getPosition());
        if (!ObjectUtil.equals((Object)position, (Object)oldPosition)) {
            this.addPropertyDelta(new DBPropertyDelta<Integer>(this, "position", IDBPropertyDelta.Type.INTEGER, position, oldPosition));
        }
    }

    protected DBFieldDelta() {
    }

    @Override
    public IDBDelta.DeltaType getDeltaType() {
        return IDBDelta.DeltaType.FIELD;
    }

    @Override
    public DBTableDelta getParent() {
        return (DBTableDelta)super.getParent();
    }

    @Override
    public IDBField getSchemaElement(IDBSchema schema) {
        IDBTable table = this.getParent().getSchemaElement(schema);
        if (table == null) {
            return null;
        }
        return table.getField(this.getName());
    }

    @Override
    public String toString() {
        return MessageFormat.format("DBFieldDelta[name={0}, kind={1}, propertyDeltas={2}]", new Object[]{this.getName(), this.getChangeKind(), this.getPropertyDeltas().values()});
    }

    @Override
    protected void doAccept(IDBDeltaVisitor visitor) {
        visitor.visit(this);
    }
}

