/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import org.eclipse.net4j.signal.IndicationWithMonitoring;
import org.eclipse.net4j.signal.RequestWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.spi.net4j.ServerProtocolFactory;

public class SignalMonitorTest
extends AbstractConfigTest {
    public static final String PROTOCOL_TYPE = "protocol";
    public static final short SIGNAL_1 = 1;
    public static final short SIGNAL_2 = 2;

    @Override
    protected IManagedContainer createContainer() {
        IManagedContainer container = super.createContainer();
        container.registerFactory((IFactory)new ServerProtocolFactory(PROTOCOL_TYPE){

            public Object create(String description) throws ProductCreationException {
                return new ServerProtocol();
            }
        });
        return container;
    }

    public void testMonitorProgress() throws Exception {
        this.startTransport();
        ClientProtocol protocol = new ClientProtocol();
        protocol.open(this.getConnector());
        RequestWithMonitoring<Boolean> request = new RequestWithMonitoring<Boolean>((SignalProtocol)protocol, 1){

            protected void requesting(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
                monitor.begin();
                try {
                    out.writeBoolean(true);
                    monitor.worked();
                }
                finally {
                    monitor.done();
                }
            }

            protected Boolean confirming(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
                monitor.begin();
                try {
                    boolean result = in.readBoolean();
                    monitor.worked();
                    Boolean bl = result;
                    return bl;
                }
                finally {
                    monitor.done();
                }
            }
        };
        request.send(4000L, (OMMonitor)new TestMonitor());
        SignalMonitorTest.sleep(200L);
        protocol.close();
    }

    public void _testMonitorProgressAsync() throws Exception {
        this.startTransport();
        ClientProtocol protocol = new ClientProtocol();
        protocol.open(this.getConnector());
        SignalMonitorTest.sleep(500L);
        protocol.setTimeout(2000L);
        RequestWithMonitoring<Boolean> request = new RequestWithMonitoring<Boolean>((SignalProtocol)protocol, 2){

            protected void requesting(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
                out.writeBoolean(true);
                out.writeLong(30000L);
            }

            protected Boolean confirming(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
                return in.readBoolean();
            }
        };
        request.send(2000L, (OMMonitor)new TestMonitor());
        SignalMonitorTest.sleep(200L);
        protocol.close();
    }

    private static final class ClientProtocol
    extends SignalProtocol<Object> {
        public ClientProtocol() {
            super(SignalMonitorTest.PROTOCOL_TYPE);
        }
    }

    private static final class ServerProtocol
    extends SignalProtocol<Object> {
        private ServerProtocol() {
            super(SignalMonitorTest.PROTOCOL_TYPE);
        }

        protected SignalReactor createSignalReactor(short signalID) {
            switch (signalID) {
                case 1: {
                    return new IndicationWithMonitoring(this, 1){

                        protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
                            monitor.begin(101.0);
                            try {
                                in.readBoolean();
                                monitor.worked();
                                int i = 0;
                                while (i < 100) {
                                    SignalMonitorTest.sleep(100L);
                                    monitor.worked();
                                    ++i;
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }

                        protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
                            monitor.begin();
                            try {
                                out.writeBoolean(true);
                                monitor.worked();
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                }
                case 2: {
                    return new IndicationWithMonitoring(this, 2){

                        protected void indicating(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
                            monitor.begin();
                            try {
                                OMMonitor.Async async = in.readBoolean() ? monitor.forkAsync() : null;
                                try {
                                    long sleep = in.readLong();
                                    Thread.sleep(sleep);
                                }
                                finally {
                                    if (async != null) {
                                        async.stop();
                                    }
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }

                        protected void responding(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
                            out.writeBoolean(true);
                        }
                    };
                }
            }
            return super.createSignalReactor(signalID);
        }
    }

    private static final class TestMonitor
    extends Monitor {
        private TestMonitor() {
        }

        public OMMonitor begin(double totalWork) {
            super.begin(totalWork);
            System.out.println("totalWork: " + this.getTotalWork());
            return this;
        }

        public void worked(double work) {
            super.worked(work);
            System.out.println("work: " + this.getWork());
        }
    }
}

