/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.internal.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.assembly.Assembly;
import org.eclipse.emf.cdo.lm.assembly.AssemblyModule;
import org.eclipse.emf.cdo.lm.client.IAssemblyDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.client.ISystemManager;
import org.eclipse.emf.cdo.lm.internal.client.AssemblyManager;
import org.eclipse.emf.cdo.lm.internal.client.LMResourceSetConfigurer;
import org.eclipse.emf.cdo.lm.internal.client.bundle.OM;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesPackage;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewCommitInfoListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.ContainerEvent;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public final class AssemblyDescriptor
extends Container<AssemblyModule>
implements IAssemblyDescriptor {
    private final IRegistry<String, Object> properties = new HashMapRegistry.AutoCommit();
    private final IListener checkoutViewListener = new CDOViewCommitInfoListener(){

        public void notifyCommitInfo(CDOCommitInfo commitInfo) {
            commitInfo.forEachRevisionDelta(revisionDelta -> {
                if (revisionDelta.getEClass().getEPackage() == ModulesPackage.eINSTANCE) {
                    AssemblyDescriptor.this.moduleDefinitionChanged();
                }
            });
        }
    };
    private final CDOCheckout checkout;
    private final Set<LMResourceSetConfigurer.CheckoutResult> lmResourceSetConfigurerResults = new LinkedHashSet<LMResourceSetConfigurer.CheckoutResult>();
    private final ISystemDescriptor systemDescriptor;
    private final CDOID moduleID;
    private final String moduleName;
    private final Baseline baseline;
    private final Adapter assemblyAdapter = new AssemblyAdapter(this);
    private final Assembly assembly;
    private volatile Assembly updateAssembly;
    private volatile IAssemblyDescriptor.UpdateState updateState;
    private volatile IAssemblyDescriptor.Updates availableUpdates;
    private volatile List<String> resolutionErrors;
    private String name;

    public AssemblyDescriptor(CDOCheckout checkout, String systemName, CDOID baselineID) {
        this.checkout = checkout;
        this.name = checkout.getLabel();
        this.systemDescriptor = ISystemManager.INSTANCE.getDescriptor(systemName);
        this.systemDescriptor.open();
        System system = this.systemDescriptor.getSystem();
        this.baseline = (Baseline)system.cdoView().getObject(baselineID);
        this.assembly = AssemblyManager.loadAssembly(checkout, false);
        this.addAssemblyAdapter(this.assembly);
        this.moduleID = this.baseline.getModule().cdoID();
        this.moduleName = this.assembly.getRootModule().getName();
        this.updateAssembly = AssemblyManager.loadAssembly(checkout, true);
        if (this.updateAssembly == null) {
            this.resolutionErrors = AssemblyManager.loadErrors(checkout);
            this.updateState = IAssemblyDescriptor.UpdateState.NoUpdatesAvailable;
        } else {
            this.addAssemblyAdapter(this.updateAssembly);
            this.updateState = IAssemblyDescriptor.UpdateState.UpdatesAvailable;
        }
        CDOBranchPointRef branchPointRef = this.baseline.getBranchPoint();
        CDOBranchPointRef existingBranchPointRef = new CDOBranchPointRef(checkout.getBranchPoint());
        if (!existingBranchPointRef.equals((Object)branchPointRef)) {
            checkout.setBranchPoint(branchPointRef);
        }
        checkout.getView().addListener(this.checkoutViewListener);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CDOCheckout getCheckout() {
        return this.checkout;
    }

    @Override
    public Baseline getBaseline() {
        return this.baseline;
    }

    @Override
    public Baseline getBaseline(AssemblyModule module) {
        String annotation;
        System system = this.systemDescriptor.getSystem();
        if (system != null && !StringUtil.isEmpty((String)(annotation = CDOUtil.getAnnotation((ModelElement)module, (String)"http://www.eclipse.org/CDO/LM", (String)"baselineID")))) {
            CDOID baselineID = CDOIDUtil.read((String)annotation);
            CDOView systemView = system.cdoView();
            return (Baseline)systemView.getObject(baselineID);
        }
        return null;
    }

    @Override
    public Assembly getAssembly() {
        return this.assembly;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public AssemblyModule getModule(String name) {
        return this.assembly.getModule(name);
    }

    @Override
    public AssemblyModule[] getModules(boolean withNewModules) {
        Collection<AssemblyModule> newModules;
        IAssemblyDescriptor.Updates updates;
        EList modules = this.assembly.getModules();
        if (withNewModules && (updates = this.availableUpdates) != null && !(newModules = updates.getAdditions().values()).isEmpty()) {
            modules = new BasicEList((Collection)modules);
            modules.addAll(newModules);
        }
        return (AssemblyModule[])modules.toArray((Object[])new AssemblyModule[modules.size()]);
    }

    @Override
    public ISystemDescriptor getSystemDescriptor() {
        return this.systemDescriptor;
    }

    public AssemblyModule[] getElements() {
        EList modules = this.assembly.getModules();
        AssemblyModule[] elements = (AssemblyModule[])modules.toArray((Object[])new AssemblyModule[modules.size()]);
        Arrays.sort(elements, null);
        return elements;
    }

    public boolean isEmpty() {
        EList modules = this.assembly.getModules();
        return modules.isEmpty();
    }

    public IRegistry<String, Object> properties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceSet(LMResourceSetConfigurer.CheckoutResult lmResourceSetConfigurerResult) {
        Set<LMResourceSetConfigurer.CheckoutResult> set = this.lmResourceSetConfigurerResults;
        synchronized (set) {
            this.lmResourceSetConfigurerResults.add(lmResourceSetConfigurerResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceSet(LMResourceSetConfigurer.CheckoutResult lmResourceSetConfigurerResult) {
        Set<LMResourceSetConfigurer.CheckoutResult> set = this.lmResourceSetConfigurerResults;
        synchronized (set) {
            this.lmResourceSetConfigurerResults.remove(lmResourceSetConfigurerResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LMResourceSetConfigurer.CheckoutResult[] getLMResourceSetConfigurations() {
        Set<LMResourceSetConfigurer.CheckoutResult> set = this.lmResourceSetConfigurerResults;
        synchronized (set) {
            return this.lmResourceSetConfigurerResults.toArray(new LMResourceSetConfigurer.CheckoutResult[this.lmResourceSetConfigurerResults.size()]);
        }
    }

    @Override
    public IAssemblyDescriptor.UpdateState getUpdateState() {
        return this.updateState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpdateState(IAssemblyDescriptor.UpdateState updateState) {
        UpdateStateChangedEventImpl event = null;
        AssemblyDescriptor assemblyDescriptor = this;
        synchronized (assemblyDescriptor) {
            IAssemblyDescriptor.UpdateState oldUpdateState = this.updateState;
            if (oldUpdateState != updateState) {
                this.updateState = updateState;
                event = new UpdateStateChangedEventImpl(this, oldUpdateState, updateState);
            }
        }
        if (event != null) {
            this.fireEvent(event);
        }
    }

    @Override
    public boolean hasUpdatesAvailable() {
        return this.updateState == IAssemblyDescriptor.UpdateState.UpdatesAvailable;
    }

    @Override
    public IAssemblyDescriptor.Updates getAvailableUpdates() {
        return this.availableUpdates;
    }

    @Override
    public List<String> getResolutionErrors() {
        return this.resolutionErrors;
    }

    public void checkForUpdates(IProgressMonitor monitor) throws Exception {
        UpdatesImpl newAvailableUpdates;
        Assembly newAssembly;
        ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        ModuleDefinition moduleDefinition = this.systemDescriptor.extractModuleDefinition(this.baseline);
        ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        this.removeAssemblyAdapter(this.updateAssembly);
        ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        IAssemblyDescriptor.Updates oldAvailableUpdates = this.availableUpdates;
        this.availableUpdates = null;
        this.resolutionErrors = null;
        try {
            newAssembly = this.systemDescriptor.resolve(moduleDefinition, this.baseline, monitor);
            ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        }
        catch (ISystemDescriptor.ResolutionException ex) {
            AssemblyManager.deleteAssembly(this.checkout, true);
            this.resolutionErrors = AssemblyManager.saveErrors(this.checkout, ex.getReasons());
            this.updateAssembly = null;
            this.setUpdateState(IAssemblyDescriptor.UpdateState.NoUpdatesAvailable);
            this.fireEvent(new AvailableUpdatesChangedEventImpl(this, oldAvailableUpdates, null));
            throw ex;
        }
        try {
            BasicEList modules = new BasicEList((Collection)this.assembly.getModules());
            BasicEList newModules = new BasicEList((Collection)newAssembly.getModules());
            modules.sort(null);
            newModules.sort(null);
            ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
            if (EcoreUtil.equals((List)newModules, (List)modules)) {
                AssemblyManager.deleteAssembly(this.checkout, true);
                ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
                this.updateAssembly = null;
                newAvailableUpdates = null;
            } else {
                newAssembly.sortModules();
                AssemblyManager.saveAssembly(this.checkout, newAssembly, true);
                ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
                this.updateAssembly = newAssembly;
                final UpdatesImpl updates = newAvailableUpdates = new UpdatesImpl();
                this.assembly.compareTo(this.updateAssembly, new Assembly.DeltaHandler(){

                    public void handleAddition(AssemblyModule newModule) {
                        updates.additions.put(newModule.getName(), newModule);
                    }

                    public void handleRemoval(AssemblyModule oldModule) {
                        updates.removals.add(oldModule.getName());
                    }

                    public void handleModification(AssemblyModule oldModule, AssemblyModule newModule) {
                        updates.modifications.put(oldModule.getName(), newModule);
                    }
                });
                if (newAvailableUpdates.isEmpty()) {
                    newAvailableUpdates = null;
                }
            }
            ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        }
        finally {
            this.addAssemblyAdapter(this.updateAssembly);
            ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        }
        this.availableUpdates = newAvailableUpdates;
        this.setUpdateState(newAvailableUpdates == null ? IAssemblyDescriptor.UpdateState.NoUpdatesAvailable : IAssemblyDescriptor.UpdateState.UpdatesAvailable);
        ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        if (!Objects.equals(newAvailableUpdates, oldAvailableUpdates)) {
            this.fireEvent(new AvailableUpdatesChangedEventImpl(this, oldAvailableUpdates, newAvailableUpdates));
            ConcurrencyUtil.checkCancelation((IProgressMonitor)monitor);
        }
    }

    @Override
    public void update() throws Exception {
        if (!this.hasUpdatesAvailable()) {
            return;
        }
        final ContainerEvent containerEvent = new ContainerEvent((IContainer)this);
        final ArrayList<LMResourceSetConfigurer.CheckoutResult.BranchPointDelta> branchPointDeltas = new ArrayList<LMResourceSetConfigurer.CheckoutResult.BranchPointDelta>();
        final EcoreUtil.Copier copier = new EcoreUtil.Copier();
        this.assembly.compareTo(this.updateAssembly, new Assembly.DeltaHandler(){

            public void handleAddition(AssemblyModule newModule) {
                AssemblyModule copy = (AssemblyModule)copier.copy((EObject)newModule);
                AssemblyDescriptor.this.assembly.getModules().add((Object)copy);
                containerEvent.addDelta((Object)copy, IContainerDelta.Kind.ADDED);
                branchPointDeltas.add(new LMResourceSetConfigurer.CheckoutResult.BranchPointDelta(newModule, null, newModule.getBranchPoint()));
            }

            public void handleRemoval(AssemblyModule oldModule) {
                AssemblyDescriptor.this.assembly.getModules().remove((Object)oldModule);
                containerEvent.addDelta((Object)oldModule, IContainerDelta.Kind.REMOVED);
                branchPointDeltas.add(new LMResourceSetConfigurer.CheckoutResult.BranchPointDelta(oldModule, oldModule.getBranchPoint(), null));
            }

            public void handleModification(AssemblyModule oldModule, AssemblyModule newModule) {
                oldModule.setRoot(newModule.isRoot());
                oldModule.setVersion(newModule.getVersion());
                oldModule.setBranchPoint(newModule.getBranchPoint());
                EList oldAnnotations = oldModule.getAnnotations();
                oldAnnotations.clear();
                EList newAnnotations = newModule.getAnnotations();
                oldAnnotations.addAll(copier.copyAll((Collection)newAnnotations));
                containerEvent.addDelta((Object)oldModule, IContainerDelta.Kind.REMOVED);
                containerEvent.addDelta((Object)oldModule, IContainerDelta.Kind.ADDED);
                branchPointDeltas.add(new LMResourceSetConfigurer.CheckoutResult.BranchPointDelta(oldModule, oldModule.getBranchPoint(), newModule.getBranchPoint()));
            }
        });
        copier.copyReferences();
        this.assembly.sortModules();
        AssemblyManager.saveAssembly(this.checkout, this.assembly, false);
        AssemblyManager.deleteAssembly(this.checkout, true);
        IAssemblyDescriptor.Updates oldAvailableUpdates = this.availableUpdates;
        this.availableUpdates = null;
        this.updateAssembly = null;
        this.setUpdateState(IAssemblyDescriptor.UpdateState.NoUpdatesAvailable);
        this.fireEvent(new AvailableUpdatesChangedEventImpl(this, oldAvailableUpdates, null));
        this.fireEvent((IEvent)containerEvent);
        for (LMResourceSetConfigurer.CheckoutResult lmResourceSetConfigurerResult : this.lmResourceSetConfigurerResults) {
            try {
                lmResourceSetConfigurerResult.reconfigure(branchPointDeltas);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkoutChanged() {
        String oldName;
        boolean changed = false;
        String newName = this.checkout.getLabel();
        AssemblyDescriptor assemblyDescriptor = this;
        synchronized (assemblyDescriptor) {
            oldName = this.name;
            if (!Objects.equals(newName, oldName)) {
                this.name = newName;
                changed = true;
            }
        }
        if (changed) {
            this.fireEvent(new NameChangedEventImpl(this, oldName, newName));
        }
    }

    public void moduleDefinitionChanged() {
        AssemblyManager.INSTANCE.scheduleUpdateCheck(this);
    }

    public void moduleDeleted(CDOID deletedModuleID) {
        if (deletedModuleID == this.moduleID) {
            OM.LOG.info("Deleting checkout '" + String.valueOf(this.checkout) + "' because module '" + this.moduleName + "' was deleted");
            this.checkout.delete(true);
        } else {
            AssemblyManager.INSTANCE.scheduleUpdateCheck(this);
        }
    }

    public void baselineAdded(Baseline newBaseline) {
        AssemblyManager.INSTANCE.scheduleUpdateCheck(this);
    }

    public String toString() {
        return this.name;
    }

    private void addAssemblyAdapter(Assembly assembly) {
        if (assembly != null) {
            assembly.eAdapters().add((Object)this.assemblyAdapter);
        }
    }

    private void removeAssemblyAdapter(Assembly assembly) {
        if (assembly != null) {
            assembly.eAdapters().remove((Object)this.assemblyAdapter);
        }
    }

    public static AssemblyDescriptor get(EObject object) {
        if (object != null) {
            for (Adapter adapter : object.eAdapters()) {
                if (!(adapter instanceof AssemblyAdapter)) continue;
                return ((AssemblyAdapter)adapter).getAssemblyDescriptor();
            }
        }
        return null;
    }

    private static final class AssemblyAdapter
    extends EContentAdapter {
        private final AssemblyDescriptor assemblyDescriptor;

        public AssemblyAdapter(AssemblyDescriptor assemblyDescriptor) {
            this.assemblyDescriptor = assemblyDescriptor;
        }

        public AssemblyDescriptor getAssemblyDescriptor() {
            return this.assemblyDescriptor;
        }
    }

    private static final class AvailableUpdatesChangedEventImpl
    extends Event
    implements IAssemblyDescriptor.AvailableUpdatesChangedEvent {
        private static final long serialVersionUID = 1L;
        private final IAssemblyDescriptor.Updates oldAvailableUpdates;
        private final IAssemblyDescriptor.Updates newAvailableUpdates;

        public AvailableUpdatesChangedEventImpl(AssemblyDescriptor assemblyDescriptor, IAssemblyDescriptor.Updates oldAvailableUpdates, IAssemblyDescriptor.Updates newAvailableUpdates) {
            super((INotifier)assemblyDescriptor);
            this.oldAvailableUpdates = oldAvailableUpdates;
            this.newAvailableUpdates = newAvailableUpdates;
        }

        @Override
        public AssemblyDescriptor getDescriptor() {
            return (AssemblyDescriptor)this.getSource();
        }

        @Override
        public IAssemblyDescriptor.Updates getOldAvailableUpdates() {
            return this.oldAvailableUpdates;
        }

        @Override
        public IAssemblyDescriptor.Updates getNewAvailableUpdates() {
            return this.newAvailableUpdates;
        }

        protected String formatEventName() {
            return IAssemblyDescriptor.AvailableUpdatesChangedEvent.class.getSimpleName();
        }

        protected String formatAdditionalParameters() {
            return "checkout=" + this.getDescriptor().getName() + ", old=" + String.valueOf(this.oldAvailableUpdates) + ", new=" + String.valueOf(this.newAvailableUpdates);
        }
    }

    private static final class NameChangedEventImpl
    extends Event
    implements IAssemblyDescriptor.NameChangedEvent {
        private static final long serialVersionUID = 1L;
        private final String oldName;
        private final String newName;

        public NameChangedEventImpl(AssemblyDescriptor assemblyDescriptor, String oldName, String newName) {
            super((INotifier)assemblyDescriptor);
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public AssemblyDescriptor getDescriptor() {
            return (AssemblyDescriptor)this.getSource();
        }

        @Override
        public String getOldName() {
            return this.oldName;
        }

        @Override
        public String getNewName() {
            return this.newName;
        }
    }

    private static final class UpdateStateChangedEventImpl
    extends Event
    implements IAssemblyDescriptor.UpdateStateChangedEvent {
        private static final long serialVersionUID = 1L;
        private final IAssemblyDescriptor.UpdateState oldUpdateState;
        private final IAssemblyDescriptor.UpdateState newUpdateState;

        public UpdateStateChangedEventImpl(AssemblyDescriptor assemblyDescriptor, IAssemblyDescriptor.UpdateState oldUpdateState, IAssemblyDescriptor.UpdateState newUpdateState) {
            super((INotifier)assemblyDescriptor);
            this.oldUpdateState = oldUpdateState;
            this.newUpdateState = newUpdateState;
        }

        @Override
        public AssemblyDescriptor getDescriptor() {
            return (AssemblyDescriptor)this.getSource();
        }

        @Override
        public IAssemblyDescriptor.UpdateState getOldUpdateState() {
            return this.oldUpdateState;
        }

        @Override
        public IAssemblyDescriptor.UpdateState getNewUpdateState() {
            return this.newUpdateState;
        }
    }

    private static final class UpdatesImpl
    implements IAssemblyDescriptor.Updates {
        private final Map<String, AssemblyModule> additions = new HashMap<String, AssemblyModule>();
        private final Map<String, AssemblyModule> modifications = new HashMap<String, AssemblyModule>();
        private final Set<String> removals = new HashSet<String>();

        @Override
        public boolean isEmpty() {
            return this.additions.isEmpty() && this.modifications.isEmpty() && this.removals.isEmpty();
        }

        @Override
        public Map<String, AssemblyModule> getAdditions() {
            return Collections.unmodifiableMap(this.additions);
        }

        @Override
        public Map<String, AssemblyModule> getModifications() {
            return Collections.unmodifiableMap(this.modifications);
        }

        @Override
        public Set<String> getRemovals() {
            return Collections.unmodifiableSet(this.removals);
        }

        public int hashCode() {
            return Objects.hash(this.additions, this.modifications, this.removals);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UpdatesImpl)) {
                return false;
            }
            UpdatesImpl other = (UpdatesImpl)obj;
            return Objects.equals(this.additions, other.additions) && Objects.equals(this.modifications, other.modifications) && Objects.equals(this.removals, other.removals);
        }

        public String toString() {
            return "Update[additions=" + String.valueOf(this.additions.keySet()) + ", removals=" + String.valueOf(this.removals) + ", modifications=" + String.valueOf(this.modifications);
        }
    }
}

