/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;
import org.eclipse.net4j.util.ui.UIUtil;

public class Authorizer<E> {
    public static final String AUTHORIZATION_PENDING = "Authorization pending...";
    public static final String AUTHORIZED = "Authorized";
    private final AuthorizerContext<E> context;
    private final CDOSession session;
    private final boolean authorizing;
    private volatile boolean authorizationFinished;
    private volatile boolean authorizationDenied;
    private final Map<E, String> authorizations = Collections.synchronizedMap(new HashMap());

    public Authorizer(AuthorizerContext<E> context, CDOSession session) {
        this.context = context;
        this.session = session;
        this.authorizing = session.getRepositoryInfo().isAuthorizingOperations();
    }

    public final AuthorizerContext<E> getContext() {
        return this.context;
    }

    public final CDOSession getSession() {
        return this.session;
    }

    public final boolean isAuthorizing() {
        return this.authorizing;
    }

    public final boolean isAuthorizationFinished() {
        return this.authorizationFinished;
    }

    public final boolean isAuthorizationDenied() {
        return this.authorizationDenied;
    }

    public final String getAuthorization(E element) {
        return this.authorizations.get(element);
    }

    protected void authorize() {
        if (this.authorizing) {
            ConcurrencyUtil.execute((Object)this.session, () -> {
                ArrayList elementOperations = new ArrayList();
                this.context.collectElementOperations(elementOperations);
                AuthorizableOperation[] operations = (AuthorizableOperation[])elementOperations.stream().map(Map.Entry::getValue).toArray(AuthorizableOperation[]::new);
                String[] results = this.session.authorizeOperations(operations);
                int i = 0;
                while (i < operations.length) {
                    Object element = ((Map.Entry)elementOperations.get(i)).getKey();
                    if (results[i] == null) {
                        this.authorizations.put(element, AUTHORIZED);
                    } else {
                        this.authorizations.put(element, results[i]);
                        this.authorizationDenied = true;
                    }
                    ++i;
                }
                this.authorizationFinished = true;
                UIUtil.asyncExec(() -> {
                    this.context.updateUIAfterAuthorization();
                    this.context.validate();
                });
            });
        }
    }

    protected void validate() throws Exception {
        if (this.authorizing) {
            if (!this.authorizationFinished) {
                throw new Exception(AUTHORIZATION_PENDING);
            }
            if (this.authorizationDenied) {
                throw new Exception(this.context.getAuthorizationDeniedMessage());
            }
        }
    }

    public static interface AuthorizerContext<E> {
        public void collectElementOperations(List<Map.Entry<E, AuthorizableOperation>> var1);

        public void updateUIAfterAuthorization();

        public String getAuthorizationDeniedMessage();

        public boolean validate();
    }
}

