/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.registry.Registry;

public abstract class DelegatingRegistry<K, V>
extends Registry<K, V> {
    private IRegistry<K, V> delegate;

    public DelegatingRegistry(IRegistry<K, V> delegate) {
        this.delegate = delegate;
    }

    public DelegatingRegistry(IRegistry<K, V> delegate, boolean autoCommit) {
        super(autoCommit);
        this.delegate = delegate;
    }

    @Override
    public V get(Object key) {
        Object result = this.getMap().get(key);
        if (result == null && this.delegate != null) {
            result = this.delegate.get(key);
        }
        return result;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.mergedEntrySet();
    }

    @Override
    public Set<K> keySet() {
        return this.mergedKeySet();
    }

    @Override
    public Collection<V> values() {
        return this.mergedValues();
    }

    @Override
    protected V register(K key, V value) {
        V delegated = this.delegate != null ? (V)this.delegate.get(key) : null;
        Object old = this.getMap().put(key, value);
        if (old == null) {
            if (delegated != null) {
                this.getTransaction().rememberDeregistered(key, delegated);
            }
            this.getTransaction().rememberRegistered(key, value);
            return delegated;
        }
        this.getTransaction().rememberDeregistered(key, old);
        this.getTransaction().rememberRegistered(key, value);
        return old;
    }

    @Override
    protected V deregister(Object key) {
        Object delegated = this.delegate != null ? (Object)this.delegate.get(key) : null;
        Object old = this.getMap().remove(key);
        if (old != null) {
            this.getTransaction().rememberDeregistered(key, old);
            if (delegated != null) {
                this.getTransaction().rememberRegistered(key, delegated);
            }
        }
        return old;
    }

    protected Set<Map.Entry<K, V>> mergedEntrySet() {
        HashMap merged = new HashMap();
        if (this.delegate != null) {
            merged.putAll(this.delegate);
        }
        merged.putAll(this.getMap());
        return merged.entrySet();
    }

    protected Set<K> mergedKeySet() {
        HashSet merged = new HashSet();
        if (this.delegate != null) {
            merged.addAll(this.delegate.keySet());
        }
        merged.addAll(this.getMap().keySet());
        return merged;
    }

    protected Collection<V> mergedValues() {
        ArrayList<V> result = new ArrayList<V>();
        for (K key : this.keySet()) {
            result.add(this.get(key));
        }
        return result;
    }
}

