/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import org.eclipse.net4j.util.concurrent.Worker;

public abstract class ReferenceQueueWorker<T>
extends Worker {
    public static final int ALL_WORK_PER_POLL = -1;
    public static final int DEFAULT_MAX_WORK_PER_POLL = -1;
    public static final int DEFAULT_POLL_MILLIS = 60000;
    private ReferenceQueue<T> queue = new ReferenceQueue();
    private long pollMillis;
    private int maxWorkPerPoll;

    public ReferenceQueueWorker() {
        this.setPollMillis(60000L);
        this.setMaxWorkPerPoll(-1);
    }

    public long getPollMillis() {
        return this.pollMillis;
    }

    public void setPollMillis(long pollMillis) {
        this.pollMillis = pollMillis;
    }

    public int getMaxWorkPerPoll() {
        return this.maxWorkPerPoll;
    }

    public void setMaxWorkPerPoll(int maxWorkPerPoll) {
        this.maxWorkPerPoll = maxWorkPerPoll;
    }

    protected ReferenceQueue<T> getQueue() {
        return this.queue;
    }

    @Override
    protected final void work(Worker.WorkContext context) throws Exception {
        int count = this.maxWorkPerPoll;
        if (count == -1) {
            count = Integer.MAX_VALUE;
        }
        int i = 0;
        while (i < count) {
            Reference<T> reference = this.queue.poll();
            if (reference == null) break;
            this.work(reference);
            ++i;
        }
        context.nextWork(this.pollMillis);
    }

    protected abstract void work(Reference<? extends T> var1);
}

