/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.factory;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Tree;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IManagedContainerProvider;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.FactoryKey;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.factory.ITreeFactory;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class TreeFactory
extends Factory
implements ITreeFactory {
    public TreeFactory() {
    }

    public TreeFactory(IFactoryKey key) {
        super(key);
    }

    public TreeFactory(FactoryKey key) {
        super(key);
    }

    public TreeFactory(String productGroup, String type) {
        super(productGroup, type);
    }

    public TreeFactory(String productGroup) {
        super(productGroup);
    }

    public Tree getTreeFor(Object product) {
        String description = this.getDescriptionFor(product);
        return TreeFactory.parseTree(description);
    }

    @Override
    public final Object createWithTree(Tree config) throws ProductCreationException {
        try {
            return this.create(config);
        }
        catch (ProductCreationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            String description = this.productCreationExceptionDescription(config);
            throw this.productCreationException(description, (Throwable)ex);
        }
    }

    @Override
    public Object create(String description) throws ProductCreationException {
        Tree tree = TreeFactory.parseTree(description);
        return this.createWithTree(tree);
    }

    protected abstract Object create(Tree var1) throws ProductCreationException;

    protected final ProductCreationException productCreationException(Tree config, Throwable cause) {
        return this.productCreationException(this.productCreationExceptionDescription(config), cause);
    }

    protected final ProductCreationException productCreationException(Tree config) {
        return this.productCreationException(this.productCreationExceptionDescription(config));
    }

    private String productCreationExceptionDescription(Tree config) {
        return "\n" + Tree.Dumper.toString(config);
    }

    public static String createDescription(Tree tree) {
        try {
            Tree.XMLConverter converter = new Tree.XMLConverter();
            tree.visit(converter, null);
            Document document = converter.document();
            return TreeFactory.xmlSerialize(document);
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static Tree parseTree(String description) {
        Document document = TreeFactory.xmlDeserialize(description);
        return Tree.XMLConverter.convertDocumentToTree(document);
    }

    public static Document xmlDeserialize(String description) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (description == null) {
                return documentBuilder.newDocument();
            }
            return documentBuilder.parse(new InputSource(new StringReader(description)));
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static String xmlSerialize(Document document) {
        try {
            StringWriter writer = new StringWriter();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception ex) {
            throw WrappedException.wrap(ex);
        }
    }

    public static abstract class ContainerAware
    extends TreeFactory
    implements IManagedContainerProvider,
    IManagedContainer.ContainerAware {
        private IManagedContainer container;

        public ContainerAware(IFactoryKey key) {
            super(key);
        }

        public ContainerAware(String productGroup, String type) {
            super(productGroup, type);
        }

        @Override
        public final IManagedContainer getContainer() {
            return this.container;
        }

        @Override
        public final void setManagedContainer(IManagedContainer container) {
            this.container = container;
        }
    }
}

