/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.execute.rts.RealDeleteResultSetStatistics;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public class RealDeleteCascadeResultSetStatistics
extends RealDeleteResultSetStatistics {
    private ResultSetStatistics[] dependentTrackingArray;

    public RealDeleteCascadeResultSetStatistics(int rowCount, boolean deferred, int indexesUpdated, boolean tableLock, long executeTime, ResultSetStatistics sourceResultSetStatistics, ResultSetStatistics[] dependentTrackingArray) {
        super(rowCount, deferred, indexesUpdated, tableLock, executeTime, sourceResultSetStatistics);
        this.dependentTrackingArray = ArrayUtil.copy(dependentTrackingArray);
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        Object dependentInfo = "";
        this.initFormatInfo(depth);
        if (this.dependentTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.dependentTrackingArray.length; ++index) {
                if (this.dependentTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    dependentInfo = this.indent + "\n" + MessageService.getTextMessage("43Y53.U", new Object[0]) + ":\n";
                    foundAttached = true;
                }
                dependentInfo = (String)dependentInfo + this.dependentTrackingArray[index].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        return this.indent + MessageService.getTextMessage("43Y52.U", new Object[0]) + " " + MessageService.getTextMessage(this.tableLock ? "43X14.U" : "43X15.U", new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X16.U", new Object[0]) + ": " + this.deferred + "\n" + this.indent + MessageService.getTextMessage("43X17.U", new Object[0]) + " = " + this.rowCount + "\n" + this.indent + MessageService.getTextMessage("43X18.U", new Object[0]) + " = " + this.indexesUpdated + "\n" + this.dumpTimeStats(this.indent) + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getStatementExecutionPlanText(1)) + (String)dependentInfo;
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        Object dependentInfo = "";
        if (this.dependentTrackingArray != null) {
            for (int index = 0; index < this.dependentTrackingArray.length; ++index) {
                if (this.dependentTrackingArray[index] == null) continue;
                dependentInfo = (String)dependentInfo + "\n" + MessageService.getTextMessage("43Y54.U", new Object[0]) + " " + index + "\n" + this.dependentTrackingArray[index].getScanStatisticsText(tableName, depth) + MessageService.getTextMessage("43Y55.U", new Object[0]) + " " + index + "\n\n";
            }
        }
        return (String)dependentInfo + (this.sourceResultSetStatistics == null ? "" : this.sourceResultSetStatistics.getScanStatisticsText(tableName, depth));
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43Y51.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.sourceResultSetStatistics != null) {
            ++noChildren;
        }
        if (this.dependentTrackingArray != null) {
            noChildren += this.dependentTrackingArray.length;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.sourceResultSetStatistics != null) {
            this.sourceResultSetStatistics.accept(visitor);
        }
        if (this.dependentTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.dependentTrackingArray.length; ++index) {
                if (this.dependentTrackingArray[index] == null) continue;
                this.dependentTrackingArray[index].accept(visitor);
            }
        }
    }

    @Override
    public String getRSXplainDetails() {
        return "CASCADE";
    }
}

