/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.uuid;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;

public class BasicUUID
implements UUID,
Formatable {
    private long majorId;
    private long timemillis;
    private int sequence;

    public BasicUUID(long majorId, long timemillis, int sequence) {
        this.majorId = majorId;
        this.timemillis = timemillis;
        this.sequence = sequence;
    }

    public BasicUUID(String uuidstring) {
        StringReader sr = new StringReader(uuidstring);
        this.sequence = (int)BasicUUID.readMSB(sr);
        long ltimemillis = BasicUUID.readMSB(sr) << 32;
        ltimemillis += BasicUUID.readMSB(sr) << 16;
        this.timemillis = ltimemillis += BasicUUID.readMSB(sr);
        this.majorId = BasicUUID.readMSB(sr);
    }

    public BasicUUID() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.majorId);
        out.writeLong(this.timemillis);
        out.writeInt(this.sequence);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.majorId = in.readLong();
        this.timemillis = in.readLong();
        this.sequence = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 131;
    }

    private static void writeMSB(char[] data, int offset, long value, int nbytes) {
        for (int i = nbytes - 1; i >= 0; --i) {
            long b = (value & 255L << 8 * i) >>> 8 * i;
            int c = (int)((b & 0xF0L) >> 4);
            data[offset++] = (char)(c < 10 ? c + 48 : c - 10 + 97);
            c = (int)(b & 0xFL);
            data[offset++] = (char)(c < 10 ? c + 48 : c - 10 + 97);
        }
    }

    private static long readMSB(StringReader sr) {
        long value = 0L;
        try {
            int c;
            while ((c = sr.read()) != -1 && c != 45) {
                value <<= 4;
                int nibble = c <= 57 ? c - 48 : (c <= 70 ? c - 65 + 10 : c - 97 + 10);
                value += (long)nibble;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof BasicUUID)) {
            return false;
        }
        BasicUUID other = (BasicUUID)otherObject;
        return this.sequence == other.sequence && this.timemillis == other.timemillis && this.majorId == other.majorId;
    }

    public int hashCode() {
        long hc = this.majorId ^ this.timemillis;
        return this.sequence ^ (int)(hc >> 4);
    }

    public String toString() {
        return this.stringWorkhorse('-');
    }

    @Override
    public String toANSIidentifier() {
        return "U" + this.stringWorkhorse('X');
    }

    public String stringWorkhorse(char separator) {
        char[] data = new char[36];
        BasicUUID.writeMSB(data, 0, this.sequence, 4);
        int offset = 8;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        long ltimemillis = this.timemillis;
        BasicUUID.writeMSB(data, offset, (ltimemillis & 0xFFFF00000000L) >>> 32, 2);
        offset += 4;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        BasicUUID.writeMSB(data, offset, (ltimemillis & 0xFFFF0000L) >>> 16, 2);
        offset += 4;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        BasicUUID.writeMSB(data, offset, ltimemillis & 0xFFFFL, 2);
        offset += 4;
        if (separator != '\u0000') {
            data[offset++] = separator;
        }
        BasicUUID.writeMSB(data, offset, this.majorId, 6);
        return new String(data, 0, offset += 12);
    }

    @Override
    public UUID cloneMe() {
        return new BasicUUID(this.majorId, this.timemillis, this.sequence);
    }
}

