/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.impl.services.monitor.ModuleInstance;
import org.apache.derby.impl.services.monitor.ProtocolKey;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

final class TopService {
    ProtocolKey key;
    ModuleInstance topModule;
    Hashtable<ProtocolKey, ModuleInstance> protocolTable;
    Vector<ModuleInstance> moduleInstances;
    BaseMonitor monitor;
    boolean inShutdown;
    PersistentService serviceType;
    Locale serviceLocale;

    TopService(BaseMonitor monitor) {
        this.monitor = monitor;
        this.protocolTable = new Hashtable();
        this.moduleInstances = new Vector(0, 5);
    }

    TopService(BaseMonitor monitor, ProtocolKey key, PersistentService serviceType, Locale serviceLocale) {
        this(monitor);
        this.key = key;
        this.serviceType = serviceType;
        this.serviceLocale = serviceLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTopModule(Object instance) {
        TopService topService = this;
        synchronized (topService) {
            ModuleInstance module = this.findModuleInstance(instance);
            if (module != null) {
                this.topModule = module;
                this.notifyAll();
            }
            if (this.getServiceType() != null) {
                ProtocolKey userKey = new ProtocolKey(this.key.getFactoryInterface(), this.monitor.getServiceName(instance));
                this.addToProtocol(userKey, this.topModule);
            }
        }
    }

    Object getService() {
        return this.topModule.getInstance();
    }

    boolean isPotentialService(ProtocolKey otherKey) {
        String otherCanonicalName;
        if (this.serviceType == null) {
            otherCanonicalName = otherKey.getIdentifier();
        } else {
            try {
                otherCanonicalName = this.serviceType.getCanonicalServiceName(otherKey.getIdentifier());
            }
            catch (StandardException se) {
                return false;
            }
            if (otherCanonicalName == null) {
                return false;
            }
        }
        if (this.topModule != null) {
            return this.topModule.isTypeAndName(this.serviceType, this.key.getFactoryInterface(), otherCanonicalName);
        }
        if (!otherKey.getFactoryInterface().isAssignableFrom(this.key.getFactoryInterface())) {
            return false;
        }
        return this.serviceType.isSameService(this.key.getIdentifier(), otherCanonicalName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService() {
        TopService topService = this;
        synchronized (topService) {
            return this.topModule != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isActiveService(ProtocolKey otherKey) {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                return false;
            }
            if (!this.isPotentialService(otherKey)) {
                return false;
            }
            if (this.topModule != null) {
                SanityManager.ASSERT(this.topModule.isTypeAndName(this.serviceType, this.key.getFactoryInterface(), this.key.getIdentifier()));
                return true;
            }
            while (!this.inShutdown && this.topModule == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ioe) {
                    InterruptStatus.setInterrupted();
                }
            }
            return !this.inShutdown;
            {
            }
        }
    }

    synchronized Object findModule(ProtocolKey key, boolean findOnly, Properties properties) {
        ModuleInstance module = this.protocolTable.get(key);
        if (module == null) {
            return null;
        }
        Object instance = module.getInstance();
        if (findOnly || BaseMonitor.canSupport(instance, properties)) {
            return instance;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleInstance findModuleInstance(Object instance) {
        Vector<ModuleInstance> vector = this.moduleInstances;
        synchronized (vector) {
            for (int i = 0; i < this.moduleInstances.size(); ++i) {
                ModuleInstance module = this.moduleInstances.get(i);
                if (module.getInstance() != instance) continue;
                return module;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object bootModule(boolean create, Object service, ProtocolKey key, Properties properties) throws StandardException {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                throw StandardException.newException("08006.D", this.getKey().getIdentifier());
            }
        }
        Object instance = this.findModule(key, false, properties);
        if (instance != null) {
            return instance;
        }
        if (this.monitor.reportOn) {
            this.monitor.report("Booting Module   " + key.toString() + " create = " + create);
        }
        TopService topService2 = this;
        synchronized (topService2) {
            int i = 0;
            while (true) {
                ModuleInstance module;
                Vector<ModuleInstance> vector = this.moduleInstances;
                synchronized (vector) {
                    if (i >= this.moduleInstances.size()) {
                        break;
                    }
                    module = this.moduleInstances.get(i);
                }
                if (module.isBooted() && module.isTypeAndName(null, key.getFactoryInterface(), key.getIdentifier()) && BaseMonitor.canSupport(instance = module.getInstance(), properties) && this.addToProtocol(key, module)) {
                    if (this.monitor.reportOn) {
                        this.monitor.report("Started Module   " + key.toString());
                        this.monitor.report("  Implementation " + instance.getClass().getName());
                    }
                    return instance;
                }
                ++i;
            }
        }
        instance = this.monitor.loadInstance(key.getFactoryInterface(), properties);
        if (instance == null) {
            throw Monitor.missingImplementation(key.getFactoryInterface().getName());
        }
        ModuleInstance module = new ModuleInstance(instance, key.getIdentifier(), service, this.topModule == null ? null : this.topModule.getInstance());
        this.moduleInstances.add(module);
        try {
            BaseMonitor.boot(instance, create, properties);
        }
        catch (StandardException se) {
            this.moduleInstances.remove(module);
            throw se;
        }
        module.setBooted();
        TopService topService3 = this;
        synchronized (topService3) {
            if (this.addToProtocol(key, module)) {
                if (this.monitor.reportOn) {
                    this.monitor.report("Started Module   " + key.toString());
                    this.monitor.report("  Implementation " + module.getInstance().getClass().getName());
                }
                return module.getInstance();
            }
        }
        TopService.stop(instance);
        this.moduleInstances.remove(module);
        return this.findModule(key, true, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shutdown() {
        TopService topService = this;
        synchronized (topService) {
            if (this.inShutdown) {
                return false;
            }
            this.inShutdown = true;
            this.notifyAll();
        }
        while (true) {
            ModuleInstance module;
            TopService topService2 = this;
            synchronized (topService2) {
                if (this.moduleInstances.isEmpty()) {
                    return true;
                }
                module = this.moduleInstances.get(0);
            }
            Object instance = module.getInstance();
            TopService.stop(instance);
            TopService topService3 = this;
            synchronized (topService3) {
                this.moduleInstances.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addToProtocol(ProtocolKey key, ModuleInstance module) {
        String identifier = module.getIdentifier();
        TopService topService = this;
        synchronized (topService) {
            ModuleInstance value = this.protocolTable.get(key);
            if (value == null) {
                this.protocolTable.put(key, module);
                return true;
            }
            return value == module;
            {
            }
        }
    }

    boolean inService(Object instance) {
        return this.findModuleInstance(instance) != null;
    }

    public ProtocolKey getKey() {
        return this.key;
    }

    PersistentService getServiceType() {
        return this.serviceType;
    }

    private static void stop(Object instance) {
        if (instance instanceof ModuleControl) {
            ((ModuleControl)instance).stop();
        }
    }
}

