/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.MemberTableHash;

class MemberTable {
    protected Vector<ClassMember> entries;
    private Hashtable<MemberTableHash, MemberTableHash> hashtable;
    private MemberTableHash mutableMTH = null;

    public MemberTable(int count) {
        this.entries = new Vector(count);
        this.hashtable = new Hashtable(count > 50 ? count : 50);
        this.mutableMTH = new MemberTableHash(null, null);
    }

    void addEntry(ClassMember item) {
        MemberTableHash mth = new MemberTableHash(item.getName(), item.getDescriptor(), this.entries.size());
        this.entries.add(item);
        this.hashtable.put(mth, mth);
    }

    ClassMember find(String name, String descriptor) {
        this.mutableMTH.name = name;
        this.mutableMTH.descriptor = descriptor;
        this.mutableMTH.setHashCode();
        MemberTableHash mth = this.hashtable.get(this.mutableMTH);
        if (mth == null) {
            return null;
        }
        return this.entries.get(mth.index);
    }

    void put(ClassFormatOutput out) throws IOException {
        Vector<ClassMember> lentries = this.entries;
        int count = lentries.size();
        for (int i = 0; i < count; ++i) {
            lentries.get(i).put(out);
        }
    }

    int size() {
        return this.entries.size();
    }

    int classFileSize() {
        int size = 0;
        Vector<ClassMember> lentries = this.entries;
        int count = lentries.size();
        for (int i = 0; i < count; ++i) {
            size += lentries.get(i).classFileSize();
        }
        return size;
    }
}

