/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db.mapping.horizontal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IIDHandler;
import org.eclipse.emf.cdo.server.db.mapping.IClassMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.IListMappingDeltaSupport;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractBasicListTableMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalClassMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.horizontal.AbstractHorizontalMappingStrategy;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBPreparedStatement;
import org.eclipse.net4j.db.IDBResultSet;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HorizontalNonAuditClassMapping
extends AbstractHorizontalClassMapping
implements IClassMappingDeltaSupport {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HorizontalNonAuditClassMapping.class);
    private String sqlSelectAllObjectIDs;
    private String sqlSelectCurrentAttributes;
    private String sqlSelectCurrentVersion;
    private String sqlInsertAttributes;
    private String sqlUpdateAffix;
    private String sqlUpdatePrefix;
    private String sqlUpdateContainerPart;
    private String sqlDelete;
    private boolean hasLists;

    public HorizontalNonAuditClassMapping(AbstractHorizontalMappingStrategy mappingStrategy, EClass eClass) {
        super(mappingStrategy, eClass);
    }

    @Override
    protected void initSQLStrings() {
        this.hasLists = !this.getListMappings().isEmpty();
        super.initSQLStrings();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.versionField);
        builder.append(", ");
        builder.append(this.createdField);
        builder.append(", ");
        builder.append(this.revisedField);
        builder.append(", ");
        builder.append(this.resourceField);
        builder.append(", ");
        builder.append(this.containerField);
        builder.append(", ");
        builder.append(this.featureField);
        HorizontalNonAuditClassMapping.appendTypeMappingNames(builder, this.getValueMappings());
        HorizontalNonAuditClassMapping.appendFieldNames(builder, this.getUnsettableFields());
        HorizontalNonAuditClassMapping.appendFieldNames(builder, this.getListSizeFields());
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.idField);
        builder.append("=?");
        this.sqlSelectCurrentAttributes = builder.toString();
        builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.versionField);
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.idField);
        builder.append("=?");
        this.sqlSelectCurrentVersion = builder.toString();
        builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.getTable());
        builder.append("(");
        builder.append(this.idField);
        builder.append(", ");
        builder.append(this.versionField);
        builder.append(", ");
        builder.append(this.createdField);
        builder.append(", ");
        builder.append(this.revisedField);
        builder.append(", ");
        builder.append(this.resourceField);
        builder.append(", ");
        builder.append(this.containerField);
        builder.append(", ");
        builder.append(this.featureField);
        HorizontalNonAuditClassMapping.appendTypeMappingNames(builder, this.getValueMappings());
        HorizontalNonAuditClassMapping.appendFieldNames(builder, this.getUnsettableFields());
        HorizontalNonAuditClassMapping.appendFieldNames(builder, this.getListSizeFields());
        builder.append(") VALUES (?, ?, ?, ?, ?, ?, ?");
        HorizontalNonAuditClassMapping.appendTypeMappingParameters(builder, this.getValueMappings());
        HorizontalNonAuditClassMapping.appendFieldParameters(builder, this.getUnsettableFields());
        HorizontalNonAuditClassMapping.appendFieldParameters(builder, this.getListSizeFields());
        builder.append(")");
        this.sqlInsertAttributes = builder.toString();
        builder = new StringBuilder("SELECT ");
        builder.append(this.idField);
        builder.append(" FROM ");
        builder.append(this.getTable());
        this.sqlSelectAllObjectIDs = builder.toString();
        builder = new StringBuilder("UPDATE ");
        builder.append(this.getTable());
        builder.append(" SET ");
        builder.append(this.versionField);
        builder.append("=?, ");
        builder.append(this.createdField);
        builder.append("=?");
        this.sqlUpdatePrefix = builder.toString();
        builder = new StringBuilder(", ");
        builder.append(this.resourceField);
        builder.append("=?, ");
        builder.append(this.containerField);
        builder.append("=?, ");
        builder.append(this.featureField);
        builder.append("=? ");
        this.sqlUpdateContainerPart = builder.toString();
        builder = new StringBuilder(" WHERE ");
        builder.append(this.idField);
        builder.append("=? ");
        this.sqlUpdateAffix = builder.toString();
        builder = new StringBuilder("DELETE FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.idField);
        builder.append("=? ");
        this.sqlDelete = builder.toString();
    }

    @Override
    protected void writeValues(IDBStoreAccessor accessor, InternalCDORevision revision) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlInsertAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                int column = 1;
                idHandler.setCDOID((PreparedStatement)stmt, column++, revision.getID());
                stmt.setInt(column++, revision.getVersion());
                stmt.setLong(column++, revision.getTimeStamp());
                stmt.setLong(column++, revision.getRevised());
                idHandler.setCDOID((PreparedStatement)stmt, column++, revision.getResourceID());
                idHandler.setCDOID((PreparedStatement)stmt, column++, (CDOID)revision.getContainerID());
                stmt.setInt(column++, revision.getContainingFeatureID());
                int isSetCol = column + this.getValueMappings().size();
                for (ITypeMapping mapping : this.getValueMappings()) {
                    EStructuralFeature feature = mapping.getFeature();
                    if (feature.isUnsettable()) {
                        if (revision.getValue(feature) == null) {
                            stmt.setBoolean(isSetCol++, false);
                            mapping.setDefaultValue((PreparedStatement)stmt, column++);
                            continue;
                        }
                        stmt.setBoolean(isSetCol++, true);
                    }
                    mapping.setValueFromRevision((PreparedStatement)stmt, column++, revision);
                }
                Map<EStructuralFeature, IDBField> listSizeFields = this.getListSizeFields();
                if (listSizeFields != null) {
                    column = isSetCol;
                    for (EStructuralFeature feature : listSizeFields.keySet()) {
                        CDOList list = revision.getListOrNull(feature);
                        int size = list == null ? -1 : list.size();
                        stmt.setInt(column++, size);
                    }
                }
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    public IDBPreparedStatement createObjectIDStatement(IDBStoreAccessor accessor) {
        if (TRACER.isEnabled()) {
            TRACER.format("Created ObjectID Statement : {0}", new Object[]{this.sqlSelectAllObjectIDs});
        }
        return accessor.getDBConnection().prepareStatement(this.sqlSelectAllObjectIDs, IDBPreparedStatement.ReuseProbability.HIGH);
    }

    public IDBPreparedStatement createResourceQueryStatement(IDBStoreAccessor accessor, CDOID folderId, String name, boolean exactMatch, CDOBranchPoint branchPoint) {
        if (this.getTable() == null) {
            return null;
        }
        long timeStamp = branchPoint.getTimeStamp();
        if (timeStamp != 0L) {
            throw new IllegalArgumentException("Non-audit store does not support explicit timeStamp in resource query");
        }
        EAttribute nameFeature = EresourcePackage.eINSTANCE.getCDOResourceNode_Name();
        ITypeMapping nameValueMapping = this.getValueMapping((EStructuralFeature)nameFeature);
        if (nameValueMapping == null) {
            throw new ImplementationError(nameFeature + " not found in ClassMapping " + this);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        builder.append(this.idField);
        builder.append(" FROM ");
        builder.append(this.getTable());
        builder.append(" WHERE ");
        builder.append(this.versionField);
        builder.append(">0 AND ");
        builder.append(this.containerField);
        builder.append("=? AND ");
        builder.append(nameValueMapping.getField());
        if (name == null) {
            builder.append(" IS NULL");
        } else {
            builder.append(exactMatch ? "=? " : " LIKE ? ");
        }
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(builder.toString(), IDBPreparedStatement.ReuseProbability.MEDIUM);
        try {
            int column = 1;
            idHandler.setCDOID((PreparedStatement)stmt, column++, folderId);
            if (name != null) {
                String queryName = exactMatch ? name : String.valueOf(name) + "%";
                nameValueMapping.setValue((PreparedStatement)stmt, column++, queryName);
            }
            if (TRACER.isEnabled()) {
                TRACER.format("Created Resource Query: {0}", new Object[]{stmt.toString()});
            }
            return stmt;
        }
        catch (Throwable ex) {
            DBUtil.close((Statement)stmt);
            throw new DBException(ex);
        }
    }

    @Override
    public boolean readRevision(IDBStoreAccessor accessor, InternalCDORevision revision, int listChunk) {
        boolean bl;
        long timeStamp = revision.getTimeStamp();
        if (timeStamp != 0L) {
            throw new UnsupportedOperationException("Mapping strategy does not support audits");
        }
        CDOID id = revision.getID();
        DBStore store = (DBStore)this.getMappingStrategy().getStore();
        IIDHandler idHandler = store.getIDHandler();
        IDBPreparedStatement stmtVersion = null;
        IDBPreparedStatement stmtAttributes = accessor.getDBConnection().prepareStatement(this.sqlSelectCurrentAttributes, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            boolean success;
            if (this.hasLists) {
                stmtVersion = accessor.getDBConnection().prepareStatement(this.sqlSelectCurrentVersion, IDBPreparedStatement.ReuseProbability.HIGH);
                stmtVersion.setMaxRows(1);
                idHandler.setCDOID((PreparedStatement)stmtVersion, 1, id);
            }
            idHandler.setCDOID((PreparedStatement)stmtAttributes, 1, id);
            while (true) {
                int currentVersion;
                success = this.readValuesFromStatement((PreparedStatement)stmtAttributes, revision, accessor);
                if (!this.hasLists || !success) break;
                try {
                    this.readLists(accessor, revision, listChunk);
                    currentVersion = this.readVersion(stmtVersion);
                }
                catch (IndexOutOfBoundsException ex) {
                    currentVersion = 0;
                }
                if (currentVersion == revision.getVersion()) break;
                revision.clearValues();
            }
            bl = success;
        }
        catch (SQLException ex) {
            try {
                throw new DBException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close((Statement)stmtAttributes);
                DBUtil.close(stmtVersion);
                throw throwable;
            }
        }
        DBUtil.close((Statement)stmtAttributes);
        DBUtil.close((Statement)stmtVersion);
        return bl;
    }

    private int readVersion(IDBPreparedStatement stmt) {
        IDBResultSet resultSet = null;
        try {
            resultSet = stmt.executeQuery();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            return 0;
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        finally {
            DBUtil.close((ResultSet)resultSet);
        }
    }

    @Override
    protected void reviseOldRevision(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, long timeStamp) {
    }

    @Override
    protected String getListXRefsWhere(IStoreAccessor.QueryXRefsContext context) {
        if (0L != context.getTimeStamp()) {
            throw new IllegalArgumentException("Non-audit mode does not support timestamp specification");
        }
        if (!context.getBranch().isMainBranch()) {
            throw new IllegalArgumentException("Non-audit mode does not support branch specification");
        }
        return this.revisedField + "=0";
    }

    @Override
    protected void detachAttributes(IDBStoreAccessor accessor, CDOID id, int version, CDOBranch branch, long timeStamp, OMMonitor monitor) {
        this.rawDelete(accessor, id, version, branch, monitor);
        this.getMappingStrategy().removeObjectType(accessor, id);
    }

    @Override
    protected void rawDeleteAttributes(IDBStoreAccessor accessor, CDOID id, CDOBranch branch, int version, OMMonitor monitor) {
        IIDHandler idHandler = this.getMappingStrategy().getStore().getIDHandler();
        IDBPreparedStatement stmt = accessor.getDBConnection().prepareStatement(this.sqlDelete, IDBPreparedStatement.ReuseProbability.HIGH);
        try {
            try {
                idHandler.setCDOID((PreparedStatement)stmt, 1, id);
                DBUtil.update((PreparedStatement)stmt, (boolean)true);
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e);
            }
        }
        finally {
            DBUtil.close((Statement)stmt);
        }
    }

    @Override
    public void writeRevisionDelta(IDBStoreAccessor accessor, InternalCDORevisionDelta delta, long created, OMMonitor monitor) {
        OMMonitor.Async async = null;
        monitor.begin();
        try {
            try {
                async = monitor.forkAsync();
                FeatureDeltaWriter writer = new FeatureDeltaWriter();
                writer.process(accessor, delta, created);
            }
            finally {
                if (async != null) {
                    async.stop();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private final class FeatureDeltaWriter
    extends AbstractHorizontalClassMapping.AbstractFeatureDeltaWriter {
        private final List<Pair<ITypeMapping, Object>> attributeChanges = new ArrayList<Pair<ITypeMapping, Object>>();
        private final List<Pair<EStructuralFeature, Integer>> listSizeChanges = new ArrayList<Pair<EStructuralFeature, Integer>>();
        private int oldVersion;
        private boolean updateContainer;
        private int newContainingFeatureID;
        private CDOID newContainerID;
        private CDOID newResourceID;
        private int branchId;
        private int newVersion;

        private FeatureDeltaWriter() {
        }

        @Override
        protected void doProcess(InternalCDORevisionDelta delta) {
            this.id = delta.getID();
            this.branchId = delta.getBranch().getID();
            this.oldVersion = delta.getVersion();
            this.newVersion = this.oldVersion + 1;
            delta.accept((CDOFeatureDeltaVisitor)this);
            this.updateAttributes();
        }

        public void visit(CDOSetFeatureDelta delta) {
            if (delta.getFeature().isMany()) {
                throw new ImplementationError("Should not be called");
            }
            ITypeMapping am = HorizontalNonAuditClassMapping.this.getValueMapping(delta.getFeature());
            if (am == null) {
                throw new IllegalArgumentException("AttributeMapping for " + delta.getFeature() + " is null!");
            }
            this.attributeChanges.add((Pair<ITypeMapping, Object>)Pair.create((Object)am, (Object)delta.getValue()));
        }

        public void visit(CDOUnsetFeatureDelta delta) {
            ITypeMapping tm = HorizontalNonAuditClassMapping.this.getValueMapping(delta.getFeature());
            this.attributeChanges.add((Pair<ITypeMapping, Object>)Pair.create((Object)tm, null));
        }

        public void visit(CDOListFeatureDelta delta) {
            EStructuralFeature feature = delta.getFeature();
            int oldSize = delta.getOriginSize();
            int newSize = -1;
            try {
                IListMappingDeltaSupport listMapping = (IListMappingDeltaSupport)((Object)HorizontalNonAuditClassMapping.this.getListMapping(feature));
                listMapping.processDelta(this.accessor, this.id, this.branchId, this.oldVersion, this.oldVersion + 1, this.created, delta);
            }
            catch (AbstractBasicListTableMapping.AbstractListDeltaWriter.NewListSizeResult result) {
                newSize = result.getNewListSize();
            }
            if (oldSize != newSize) {
                this.listSizeChanges.add((Pair<EStructuralFeature, Integer>)Pair.create((Object)feature, (Object)newSize));
            }
        }

        public void visit(CDOContainerFeatureDelta delta) {
            this.newContainingFeatureID = delta.getContainerFeatureID();
            this.newContainerID = (CDOID)delta.getContainerID();
            this.newResourceID = delta.getResourceID();
            this.updateContainer = true;
        }

        private void updateAttributes() {
            IIDHandler idHandler = HorizontalNonAuditClassMapping.this.getMappingStrategy().getStore().getIDHandler();
            String sql = this.buildUpdateSQL();
            IDBPreparedStatement stmt = this.accessor.getDBConnection().prepareStatement(sql, IDBPreparedStatement.ReuseProbability.MEDIUM);
            try {
                try {
                    int column = 1;
                    stmt.setInt(column++, this.newVersion);
                    stmt.setLong(column++, this.created);
                    if (this.updateContainer) {
                        idHandler.setCDOID((PreparedStatement)stmt, column++, this.newResourceID, this.created);
                        idHandler.setCDOID((PreparedStatement)stmt, column++, this.newContainerID, this.created);
                        stmt.setInt(column++, this.newContainingFeatureID);
                    }
                    column = this.setUpdateAttributeValues(this.attributeChanges, stmt, column);
                    column = this.setUpdateListSizeChanges(this.listSizeChanges, stmt, column);
                    idHandler.setCDOID((PreparedStatement)stmt, column++, this.id);
                    DBUtil.update((PreparedStatement)stmt, (boolean)true);
                }
                catch (SQLException e) {
                    throw new DBException((Throwable)e);
                }
            }
            finally {
                DBUtil.close((Statement)stmt);
            }
        }

        private String buildUpdateSQL() {
            StringBuilder builder = new StringBuilder(HorizontalNonAuditClassMapping.this.sqlUpdatePrefix);
            if (this.updateContainer) {
                builder.append(HorizontalNonAuditClassMapping.this.sqlUpdateContainerPart);
            }
            for (Pair<ITypeMapping, Object> pair : this.attributeChanges) {
                builder.append(", ");
                ITypeMapping typeMapping = (ITypeMapping)pair.getElement1();
                builder.append(typeMapping.getField());
                builder.append("=?");
                if (!typeMapping.getFeature().isUnsettable()) continue;
                builder.append(", ");
                builder.append(HorizontalNonAuditClassMapping.this.getUnsettableFields().get(typeMapping.getFeature()));
                builder.append("=?");
            }
            for (Pair<ITypeMapping, Object> pair : this.listSizeChanges) {
                builder.append(", ");
                EStructuralFeature feature = (EStructuralFeature)pair.getElement1();
                builder.append(HorizontalNonAuditClassMapping.this.getListSizeFields().get(feature));
                builder.append("=?");
            }
            builder.append(HorizontalNonAuditClassMapping.this.sqlUpdateAffix);
            return builder.toString();
        }

        private int setUpdateAttributeValues(List<Pair<ITypeMapping, Object>> attributeChanges, IDBPreparedStatement stmt, int col) throws SQLException {
            for (Pair<ITypeMapping, Object> change : attributeChanges) {
                ITypeMapping typeMapping = (ITypeMapping)change.getElement1();
                Object value = change.getElement2();
                if (typeMapping.getFeature().isUnsettable()) {
                    if (value == null) {
                        typeMapping.setDefaultValue((PreparedStatement)stmt, col++);
                        stmt.setBoolean(col++, false);
                        continue;
                    }
                    typeMapping.setValue((PreparedStatement)stmt, col++, value);
                    stmt.setBoolean(col++, true);
                    continue;
                }
                typeMapping.setValue((PreparedStatement)stmt, col++, change.getElement2());
            }
            return col;
        }

        private int setUpdateListSizeChanges(List<Pair<EStructuralFeature, Integer>> attributeChanges, IDBPreparedStatement stmt, int col) throws SQLException {
            for (Pair<EStructuralFeature, Integer> change : this.listSizeChanges) {
                stmt.setInt(col++, ((Integer)change.getElement2()).intValue());
            }
            return col;
        }
    }
}

