/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server.protocol.admin;

import org.eclipse.net4j.jms.internal.server.protocol.admin.JMSAdminServerProtocol;
import org.eclipse.net4j.jms.server.IDestination;
import org.eclipse.net4j.jms.server.IServer;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class JMSCreateDestinationIndication
extends IndicationWithResponse {
    private boolean ok;

    public JMSCreateDestinationIndication(JMSAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)1);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        byte type = in.readByte();
        String name = in.readString();
        JMSAdminServerProtocol protocol = (JMSAdminServerProtocol)this.getProtocol();
        IServer server = protocol.getServer();
        IDestination destination = server.createDestination(name, this.getDestinationType(type));
        if (destination != null) {
            this.ok = true;
        }
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        out.writeBoolean(this.ok);
    }

    private IDestination.Type getDestinationType(byte type) {
        switch (type) {
            case 1: {
                return IDestination.Type.QUEUE;
            }
            case 2: {
                return IDestination.Type.TOPIC;
            }
        }
        throw new IllegalArgumentException("type: " + type);
    }
}

