/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerLockStatePrefetcher;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class LoadRevisionsIndication
extends CDOServerReadIndication {
    private RevisionInfo[] infos;
    private CDOBranchPoint branchPoint;
    private int referenceChunk;
    private int prefetchDepth;
    private final Map<EClass, CDOFetchRule> fetchRules = new HashMap<EClass, CDOFetchRule>();
    private CDOID contextID = CDOID.NULL;
    private int loadRevisionCollectionChunkSize;
    private Set<CDORevisionKey> validKeys;
    private InternalCDORevisionManager revisionManager;
    private CDOServerLockStatePrefetcher lockStatePrefetcher;

    public LoadRevisionsIndication(CDOServerProtocol protocol) {
        super(protocol, (short)7);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        InternalRepository repository = this.getRepository();
        this.revisionManager = repository.getRevisionManager();
        this.branchPoint = in.readCDOBranchPoint();
        this.referenceChunk = in.readXInt();
        boolean prefetchLockStates = in.readBoolean();
        this.lockStatePrefetcher = CDOServerLockStatePrefetcher.create(repository, this.branchPoint, prefetchLockStates);
        int size = in.readXInt();
        if (size < 0) {
            size = -size;
            this.prefetchDepth = in.readXInt();
            if (this.prefetchDepth != 0) {
                CDORevisionKey key;
                this.validKeys = new HashSet<CDORevisionKey>();
                while ((key = in.readCDORevisionKey()) != null) {
                    this.validKeys.add(key);
                }
            }
        }
        this.infos = new RevisionInfo[size];
        int i = 0;
        while (i < size) {
            this.infos[i] = RevisionInfo.read((CDODataInput)in, (CDOBranchPoint)this.branchPoint);
            ++i;
        }
        int fetchRulesCount = in.readXInt();
        if (fetchRulesCount > 0) {
            this.loadRevisionCollectionChunkSize = in.readXInt();
            if (this.loadRevisionCollectionChunkSize < 1) {
                this.loadRevisionCollectionChunkSize = Integer.MAX_VALUE;
            }
            this.contextID = in.readCDOID();
            InternalCDOPackageRegistry packageRegistry = repository.getPackageRegistry();
            int i2 = 0;
            while (i2 < fetchRulesCount) {
                CDOFetchRule fetchRule = new CDOFetchRule(in, (CDOPackageRegistry)packageRegistry);
                this.fetchRules.put(fetchRule.getEClass(), fetchRule);
                ++i2;
            }
        }
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        ArrayList<RevisionInfo> additionalInfos = new ArrayList<RevisionInfo>();
        ArrayList<CDORevision> additionalRevisions = new ArrayList<CDORevision>();
        HashSet<CDOID> revisionIDs = new HashSet<CDOID>();
        int size = this.infos.length;
        RevisionInfo[] revisionInfoArray = this.infos;
        int n = this.infos.length;
        int n2 = 0;
        while (n2 < n) {
            RevisionInfo info = revisionInfoArray[n2];
            revisionIDs.add(info.getID());
            ++n2;
        }
        HashSet<CDOFetchRule> visitedFetchRules = new HashSet<CDOFetchRule>();
        if (!CDOIDUtil.isNull((CDOID)this.contextID) && this.fetchRules.size() > 0) {
            RevisionInfo contextRevisionInfo = this.createRevisionInfo(this.contextID);
            InternalCDORevision contextRevision = contextRevisionInfo.getResult();
            this.collectRevisions(contextRevision, revisionIDs, additionalInfos, additionalRevisions, visitedFetchRules);
        }
        InternalCDORevision[] revisions = new InternalCDORevision[size];
        int i = 0;
        while (i < size) {
            RevisionInfo info = this.infos[i];
            this.executeRevisionInfo(info);
            revisions[i] = info.getResult();
            if (this.loadRevisionCollectionChunkSize > 0) {
                this.collectRevisions(revisions[i], revisionIDs, additionalInfos, additionalRevisions, visitedFetchRules);
            }
            ++i;
        }
        if (this.prefetchDepth != 0) {
            OMMonitor monitor = this.createMonitor(1, 10);
            try {
                this.prefetchRevisions(this.prefetchDepth > 0 ? this.prefetchDepth : Integer.MAX_VALUE, (CDORevision[])revisions, additionalInfos, additionalRevisions, monitor);
            }
            finally {
                monitor.done();
            }
        }
        InternalRepository repository = this.getRepository();
        InternalSession session = this.getSession();
        repository.notifyReadAccessHandlers(session, (CDORevision[])revisions, additionalRevisions);
        int i2 = 0;
        while (i2 < size) {
            RevisionInfo info = this.infos[i2];
            info.setResult(revisions[i2]);
            info.writeResult(out, this.referenceChunk, this.branchPoint);
            ++i2;
        }
        int additionalSize = additionalRevisions.size();
        ArrayList<RevisionInfo> infosToWrite = new ArrayList<RevisionInfo>();
        CDOBranch requestedBranch = this.branchPoint.getBranch();
        int i3 = 0;
        while (i3 < additionalSize) {
            InternalCDORevision revision = (InternalCDORevision)additionalRevisions.get(i3);
            RevisionInfo info = (RevisionInfo)additionalInfos.get(i3);
            if (this.validKeys != null && this.validKeys.contains(CDORevisionUtil.copyRevisionKey((CDORevisionKey)revision))) {
                InternalCDORevision result = info.getResult();
                out.writeCDORevisionKey((CDORevisionKey)result);
                if (result.getBranch() != requestedBranch) {
                    PointerCDORevision pointer = (PointerCDORevision)info.getSynthetic();
                    out.writeXLong(pointer.getRevised());
                }
            } else {
                info.setResult(revision);
                infosToWrite.add(info);
            }
            ++i3;
        }
        out.writeCDORevisionKey(null);
        out.writeXInt(infosToWrite.size());
        for (RevisionInfo info : infosToWrite) {
            out.write(RevisionInfo.Type.MISSING.ordinal());
            out.writeCDOID(info.getID());
            info.writeResult(out, this.referenceChunk, this.branchPoint);
        }
        this.lockStatePrefetcher.writeLockStates(out);
    }

    private RevisionInfo createRevisionInfo(CDOID id) {
        RevisionInfo.Missing info = new RevisionInfo.Missing(id, this.branchPoint);
        this.executeRevisionInfo((RevisionInfo)info);
        return info;
    }

    private void executeRevisionInfo(RevisionInfo info) {
        info.execute(this.revisionManager, this.referenceChunk);
        this.lockStatePrefetcher.addLockStateKey(() -> {
            SyntheticCDORevision revision = info.getSynthetic();
            if (revision == null) {
                revision = info.getResult();
            }
            if (revision != null && !(revision instanceof DetachedCDORevision)) {
                return revision.getID();
            }
            return null;
        });
    }

    private void collectRevisions(InternalCDORevision revision, Set<CDOID> revisions, List<RevisionInfo> additionalInfos, List<CDORevision> additionalRevisions, Set<CDOFetchRule> visitedFetchRules) {
        if (revision == null) {
            return;
        }
        this.getSession().collectContainedRevisions(revision, this.branchPoint, this.referenceChunk, revisions, additionalRevisions);
        CDOFetchRule fetchRule = this.fetchRules.get(revision.getEClass());
        if (fetchRule == null || !visitedFetchRules.add(fetchRule)) {
            return;
        }
        for (EStructuralFeature feature : fetchRule.getFeatures()) {
            CDORevisionUtil.forEachValue((CDORevision)revision, (EStructuralFeature)feature, (int)this.loadRevisionCollectionChunkSize, value -> {
                RevisionInfo info;
                InternalCDORevision containedRevision;
                CDOID id;
                if (value instanceof CDOID && !CDOIDUtil.isNull((CDOID)(id = (CDOID)value)) && !revisions.contains(id) && (containedRevision = (info = this.createRevisionInfo(id)).getResult()) != null) {
                    additionalInfos.add(info);
                    revisions.add(containedRevision.getID());
                    additionalRevisions.add((CDORevision)containedRevision);
                    this.collectRevisions(containedRevision, revisions, additionalInfos, additionalRevisions, visitedFetchRules);
                }
            });
        }
        visitedFetchRules.remove(fetchRule);
    }

    private void prefetchRevisions(int depth, CDORevision[] revisions, List<RevisionInfo> additionalInfos, List<CDORevision> additionalRevisions, OMMonitor monitor) {
        CDORevision revision2;
        Map map = CDOIDUtil.createMap();
        CDORevision[] cDORevisionArray = revisions;
        int n = revisions.length;
        int n2 = 0;
        while (n2 < n) {
            revision2 = cDORevisionArray[n2];
            map.put(revision2.getID(), revision2);
            ++n2;
        }
        for (CDORevision revision2 : additionalRevisions) {
            map.put(revision2.getID(), revision2);
        }
        monitor.begin((double)revisions.length);
        cDORevisionArray = revisions;
        n = revisions.length;
        int n3 = 0;
        while (n3 < n) {
            revision2 = cDORevisionArray[n3];
            this.prefetchRevision(depth, (InternalCDORevision)revision2, additionalInfos, additionalRevisions, map, monitor.fork());
            ++n3;
        }
    }

    private void prefetchRevision(int depth, InternalCDORevision revision, List<RevisionInfo> additionalInfos, List<CDORevision> additionalRevisions, Map<CDOID, CDORevision> map, OMMonitor monitor) {
        InternalCDOClassInfo classInfo = revision.getClassInfo();
        EStructuralFeature[] containments = classInfo.getAllPersistentContainments();
        monitor.begin((double)containments.length);
        EStructuralFeature[] eStructuralFeatureArray = containments;
        int n = containments.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            Object value = revision.getValue(feature);
            if (value instanceof CDOID) {
                CDOID id = (CDOID)value;
                this.prefetchRevisionChild(depth, id, additionalInfos, additionalRevisions, map, monitor.fork());
            } else if (value instanceof Collection) {
                Collection c = (Collection)value;
                OMMonitor subMonitor = monitor.fork();
                subMonitor.begin((double)c.size());
                for (Object e : c) {
                    if (e instanceof CDOID) {
                        CDOID id = (CDOID)e;
                        this.prefetchRevisionChild(depth, id, additionalInfos, additionalRevisions, map, subMonitor.fork());
                        continue;
                    }
                    subMonitor.worked();
                }
                subMonitor.done();
            } else {
                monitor.worked();
            }
            ++n2;
        }
        monitor.done();
    }

    private void prefetchRevisionChild(int depth, CDOID id, List<RevisionInfo> additionalInfos, List<CDORevision> additionalRevisions, Map<CDOID, CDORevision> map, OMMonitor monitor) {
        RevisionInfo info;
        if (CDOIDUtil.isNull((CDOID)id)) {
            return;
        }
        CDORevision child = map.get(id);
        if (child == null && (child = (info = this.createRevisionInfo(id)).getResult()) != null) {
            map.put(id, child);
            additionalRevisions.add(child);
            additionalInfos.add(info);
        }
        if (child != null && depth > 0) {
            this.prefetchRevision(depth - 1, (InternalCDORevision)child, additionalInfos, additionalRevisions, map, monitor);
        }
    }
}

