/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.common.util.Support;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.server.AbstractLifecycleManager;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsUpdate;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.h2.jdbcx.JdbcDataSource;

public class LocalCDORepository
extends CDORepositoryImpl {
    public static final String PROP_SECURITY_DISABLED = "securityDisabled";
    public static final String PROP_SECURITY_CONFIG = "securityConfig";
    public static final String PROP_LM_ENABLED = "lmEnabled";
    public static final String PROP_LM_CONFIG = "lmConfig";
    public static final String PROP_TCP_DISABLED = "tcpDisabled";
    public static final String PROP_TCP_PORT = "tcpPort";
    private static final PasswordCredentials CREDENTIALS = new PasswordCredentials("Administrator", "0000");
    private boolean securityDisabled;
    private String securityConfig;
    private boolean lmEnabled;
    private String lmConfig;
    private boolean tcpDisabled;
    private int tcpPort;
    private IRepository repository;
    private IDeactivateable lifecycleManager;
    private IAcceptor tcpAcceptor;

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean isClone() {
        return false;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public final String getConnectorType() {
        return "jvm";
    }

    @Override
    public final String getConnectorDescription() {
        return "local";
    }

    @Override
    public String getURI() {
        if (this.tcpDisabled) {
            return String.valueOf(this.getConnectorType()) + "://" + this.getConnectorDescription() + "/" + this.getName();
        }
        return "tcp://localhost:" + this.tcpPort + "/" + this.getName();
    }

    public final boolean isSecurityDisabled() {
        return this.securityDisabled;
    }

    public final String getSecurityConfig() {
        return this.securityConfig;
    }

    public final boolean isLMEnabled() {
        return this.lmEnabled;
    }

    public final String getLMConfig() {
        return this.lmConfig;
    }

    public final boolean isTCPDisabled() {
        return this.tcpDisabled;
    }

    public final int getTCPPort() {
        return this.tcpPort;
    }

    @Override
    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        this.securityDisabled = Boolean.parseBoolean(properties.getProperty(PROP_SECURITY_DISABLED, StringUtil.TRUE));
        this.securityConfig = StringUtil.safe((Object)properties.get(PROP_SECURITY_CONFIG));
        this.lmEnabled = Boolean.parseBoolean(properties.getProperty(PROP_LM_ENABLED, StringUtil.FALSE));
        this.lmConfig = StringUtil.safe((String)properties.getProperty(PROP_LM_CONFIG));
        this.tcpDisabled = Boolean.parseBoolean(properties.getProperty(PROP_TCP_DISABLED, StringUtil.TRUE));
        this.tcpPort = Integer.parseInt(properties.getProperty(PROP_TCP_PORT, "0"));
    }

    @Override
    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_SECURITY_DISABLED, Boolean.toString(this.securityDisabled));
        properties.setProperty(PROP_SECURITY_CONFIG, StringUtil.safe((String)this.securityConfig));
        properties.setProperty(PROP_LM_ENABLED, Boolean.toString(this.lmEnabled));
        properties.setProperty(PROP_LM_CONFIG, StringUtil.safe((String)this.lmConfig));
        properties.setProperty(PROP_TCP_DISABLED, Boolean.toString(this.tcpDisabled));
        properties.setProperty(PROP_TCP_PORT, Integer.toString(this.tcpPort));
    }

    @Override
    public CDOSession openSession() {
        IManagedContainer container = this.getContainer();
        String repositoryName = this.getName();
        File folder = this.getFolder();
        File dbPrefix = new File(folder, "db");
        CDORepository.VersioningMode versioningMode = this.getVersioningMode();
        Map<String, String> mappingStrategyProperties = this.getMappingStrategyProperties();
        Map<String, String> repositoryProperties = this.getRepositoryProperties();
        this.repository = LocalCDORepository.createRepository(container, repositoryName, dbPrefix, versioningMode, mappingStrategyProperties, repositoryProperties);
        if (!this.securityDisabled) {
            try {
                String qualifiedDescription = String.format("%s:%s", repositoryName, this.securityConfig);
                if (container.getElement("org.eclipse.emf.cdo.server.security.managers", "default", qualifiedDescription) == null) {
                    throw new IllegalStateException("Security manager for repository " + repositoryName + " could not be created: " + this.securityConfig);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        if (Support.SERVER_LM.isAvailable() && this.lmEnabled) {
            CDORepository.IDGeneration idGeneration = this.getIDGeneration();
            this.lifecycleManager = LMHelper.start(container, folder, this.repository, this.lmConfig, idGeneration);
        }
        String connectorType = this.getConnectorType();
        String connectorDescription = this.getConnectorDescription();
        Net4jUtil.getAcceptor((IManagedContainer)container, (String)connectorType, (String)connectorDescription);
        if (!this.tcpDisabled) {
            this.tcpAcceptor = Net4jUtil.getAcceptor((IManagedContainer)container, (String)"tcp", (String)("0.0.0.0:" + this.tcpPort));
        }
        return super.openSession();
    }

    private static InternalRepository createRepository(IManagedContainer container, String repositoryName, File dbPrefix, CDORepository.VersioningMode versioningMode, Map<String, String> mappingStrategyProperties, Map<String, String> repositoryProperties) {
        JdbcDataSource dataSource = new JdbcDataSource();
        dataSource.setURL("jdbc:h2:" + dbPrefix);
        boolean supportingAudits = versioningMode.isSupportingAudits();
        boolean supportingBranches = versioningMode.isSupportingBranches();
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)supportingAudits, (boolean)supportingBranches, (boolean)false);
        mappingStrategy.setProperties(mappingStrategyProperties);
        IDBAdapter dbAdapter = DBUtil.getDBAdapter((String)"h2");
        IDBConnectionProvider connectionProvider = DBUtil.createConnectionProvider((DataSource)dataSource);
        IDBStore store = CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)connectionProvider);
        IRepository repository = CDOServerUtil.createRepository((String)repositoryName, (IStore)store, repositoryProperties);
        CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)repository);
        return (InternalRepository)repository;
    }

    @Override
    protected void closeSession() {
        super.closeSession();
        LifecycleUtil.deactivate((Object)this.tcpAcceptor);
        this.tcpAcceptor = null;
        LifecycleUtil.deactivate((Object)this.lifecycleManager);
        this.lifecycleManager = null;
        LifecycleUtil.deactivate((Object)this.repository);
        this.repository = null;
    }

    @Override
    public boolean isAuthenticating() {
        return !this.isSecurityDisabled();
    }

    @Override
    public IPasswordCredentials getCredentials(String realm) {
        if (!this.isSecurityDisabled()) {
            return CREDENTIALS;
        }
        return super.getCredentials(realm);
    }

    @Override
    public void setCredentials(IPasswordCredentials credentials) {
        if (!this.isSecurityDisabled()) {
            return;
        }
        super.setCredentials(credentials);
    }

    @Override
    public IPasswordCredentialsUpdate getCredentialsUpdate(String realm, String userID, CredentialsUpdateOperation operation) {
        if (!this.isSecurityDisabled()) {
            return null;
        }
        return super.getCredentialsUpdate(realm, userID, operation);
    }

    protected Map<String, String> getRepositoryProperties() {
        CDORepository.VersioningMode versioningMode = this.getVersioningMode();
        CDORepository.IDGeneration idGeneration = this.getIDGeneration();
        return LocalCDORepository.getRepositoryProperties(versioningMode, idGeneration);
    }

    private static Map<String, String> getRepositoryProperties(CDORepository.VersioningMode versioningMode, CDORepository.IDGeneration idGeneration) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", Boolean.toString(versioningMode.isSupportingAudits()));
        props.put("supportingBranches", Boolean.toString(versioningMode.isSupportingBranches()));
        props.put("idGenerationLocation", idGeneration.getLocation().toString());
        return props;
    }

    protected Map<String, String> getMappingStrategyProperties() {
        return LocalCDORepository.getMappingStrategyPropertiesDefault();
    }

    private static Map<String, String> getMappingStrategyProperties(boolean eagerTableCreation, boolean qualifiedNames, boolean withRanges, boolean copyOnBranch) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("eagerTableCreation", Boolean.toString(eagerTableCreation));
        props.put("qualifiedNames", Boolean.toString(qualifiedNames));
        props.put("withRanges", Boolean.toString(withRanges));
        props.put("copyOnBranch", Boolean.toString(copyOnBranch));
        return props;
    }

    private static Map<String, String> getMappingStrategyPropertiesDefault() {
        boolean eagerTableCreation = OMPlatform.INSTANCE.isProperty("cdo.explorer.eagerTableCreation", false);
        boolean qualifiedNames = OMPlatform.INSTANCE.isProperty("cdo.explorer.qualifiedNames", true);
        boolean withRanges = OMPlatform.INSTANCE.isProperty("cdo.explorer.withRanges", true);
        boolean copyOnBranch = OMPlatform.INSTANCE.isProperty("cdo.explorer.copyOnBranch", false);
        return LocalCDORepository.getMappingStrategyProperties(eagerTableCreation, qualifiedNames, withRanges, copyOnBranch);
    }

    private static final class LMHelper {
        private static final String MANY_VALUED_PREFIX = "(";
        private static final String MANY_VALUED_SUFFIX = ")";
        private static final int MANY_VALUED_SUFFIX_LENGTH = ")".length();

        private LMHelper() {
        }

        public static IDeactivateable start(final IManagedContainer container, File folder, IRepository repository, String lmConfig, final CDORepository.IDGeneration idGeneration) {
            String systemName = null;
            String moduleDefinitionPath = null;
            LinkedHashSet<String> moduleTypes = new LinkedHashSet<String>();
            LinkedHashSet<String> dropTypes = new LinkedHashSet<String>();
            LinkedHashSet<String> releaseTypes = new LinkedHashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(lmConfig, ":");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                token = StringUtil.unescape((String)token, (char)':');
                if (systemName == null) {
                    systemName = token;
                    continue;
                }
                if (moduleDefinitionPath == null) {
                    moduleDefinitionPath = token;
                    continue;
                }
                if (!LMHelper.manyValuedToken(token, "moduleTypes", moduleTypes) && !LMHelper.manyValuedToken(token, "dropTypes", dropTypes) && !LMHelper.manyValuedToken(token, "releaseTypes", releaseTypes)) continue;
            }
            final AbstractLifecycleManager lifecycleManager = new AbstractLifecycleManager(folder){
                private final File lmFolder;
                {
                    this.lmFolder = new File(file, "lm");
                    this.lmFolder.mkdirs();
                }

                protected InternalRepository createModuleRepository(String moduleName) throws CoreException {
                    File dbPrefix = new File(this.lmFolder, moduleName);
                    Map mappingStrategyProperties = LocalCDORepository.getMappingStrategyPropertiesDefault();
                    Map repositoryProperties = LocalCDORepository.getRepositoryProperties(CDORepository.VersioningMode.Branching, idGeneration);
                    return LocalCDORepository.createRepository(container, moduleName, dbPrefix, CDORepository.VersioningMode.Branching, mappingStrategyProperties, repositoryProperties);
                }
            };
            lifecycleManager.setSystemRepository((InternalRepository)repository);
            lifecycleManager.setSystemName(systemName);
            lifecycleManager.setModuleDefinitionPath(moduleDefinitionPath);
            lifecycleManager.setProcessInitializer(process -> {
                moduleTypes.forEach(name -> {
                    boolean bl = process.getModuleTypes().add((Object)LMFactory.eINSTANCE.createModuleType(name));
                });
                dropTypes.forEach(name -> {
                    boolean bl = process.getDropTypes().add((Object)LMFactory.eINSTANCE.createDropType(name, false));
                });
                releaseTypes.forEach(name -> {
                    boolean bl = process.getDropTypes().add((Object)LMFactory.eINSTANCE.createDropType(name, true));
                });
            });
            lifecycleManager.activate();
            return new IDeactivateable(){

                public Exception deactivate() {
                    return lifecycleManager.deactivate();
                }
            };
        }

        private static boolean manyValuedToken(String token, String tag, Set<String> set) {
            String prefix = String.valueOf(tag) + MANY_VALUED_PREFIX;
            if (token.startsWith(prefix) && token.endsWith(MANY_VALUED_SUFFIX)) {
                token = token.substring(prefix.length(), token.length() - MANY_VALUED_SUFFIX_LENGTH);
                StringUtil.tokenize((String)token, (String)",", singleValue -> {
                    singleValue = StringUtil.unescape((String)singleValue, (char)',');
                    if (!StringUtil.isEmpty((String)(singleValue = singleValue.trim()))) {
                        set.add((String)singleValue);
                    }
                });
                return true;
            }
            return false;
        }
    }
}

