/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests;

import java.util.Arrays;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.config.Net4jTestSuite;
import org.eclipse.net4j.tests.config.TestConfig;
import org.eclipse.net4j.tests.data.TinyData;
import org.eclipse.net4j.tests.signal.ArrayRequest;
import org.eclipse.net4j.tests.signal.TestSignalProtocol;
import org.eclipse.net4j.util.io.IOUtil;

@Net4jTestSuite.ExcludedConfig(value={TestConfig.JVM.class, TestConfig.TCP.class, TestConfig.SSL.class})
public class IdleTimeoutTest
extends AbstractConfigTest {
    public void testSingleThreadTinyDataLongWithPause() throws Exception {
        byte[] result;
        this.startTransport();
        IConnector connector = this.getConnector();
        connector.setOpenChannelTimeout(20000L);
        TestSignalProtocol protocol = new TestSignalProtocol(connector);
        IdleTimeoutTest.assertActive((Object)protocol);
        byte[] data = TinyData.getBytes();
        IdleTimeoutTest.log("Sending 10000 signals...");
        int i = 0;
        while (i < 10000) {
            result = (byte[])new ArrayRequest(protocol, data).send();
            IdleTimeoutTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
            ++i;
        }
        IdleTimeoutTest.log("Pausing 40 seconds ...");
        IdleTimeoutTest.sleep(40000L);
        IdleTimeoutTest.log("Sending 10000 signals...");
        i = 0;
        while (i < 10000) {
            result = (byte[])new ArrayRequest(protocol, data).send();
            IdleTimeoutTest.assertEquals((boolean)true, (boolean)Arrays.equals(data, result));
            ++i;
        }
        protocol.close();
        IdleTimeoutTest.assertInactive((Object)protocol);
    }

    private static void log(String message) {
        IOUtil.OUT().println(message);
    }
}

