/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.widgets;

import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.ui.CDOItemProvider;
import org.eclipse.emf.cdo.ui.widgets.SelectBranchComposite;
import org.eclipse.emf.cdo.ui.widgets.SelectTimeStampComposite;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ui.ValidationContext;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ComposeBranchPointComposite
extends Composite {
    private boolean allowTimeStamp;
    private CDOBranchPoint branchPoint;
    private TreeViewer branchViewer;
    private Group timeStampGroup;
    private SelectTimeStampComposite timeStampComposite;

    public ComposeBranchPointComposite(Composite parent, boolean allowTimeStamp, CDOBranchPoint branchPoint) {
        this(parent, 0, null, branchPoint, allowTimeStamp);
    }

    @Deprecated
    public ComposeBranchPointComposite(Composite parent, int style, CDOSession session, CDOBranchPoint branchPoint, boolean allowTimeStamp) {
        super(parent, style);
        this.allowTimeStamp = allowTimeStamp;
        this.branchPoint = branchPoint;
        GridLayout containerGridLayout = new GridLayout(1, false);
        containerGridLayout.marginWidth = 0;
        containerGridLayout.marginHeight = 0;
        containerGridLayout.verticalSpacing = 10;
        this.setLayout((Layout)containerGridLayout);
        this.createUI();
    }

    public boolean isAllowTimeStamp() {
        return this.allowTimeStamp;
    }

    public final void setAllowTimeStamp(boolean allowTimeStamp) {
        if (this.allowTimeStamp != allowTimeStamp) {
            this.allowTimeStamp = allowTimeStamp;
            if (this.timeStampGroup != null && !allowTimeStamp) {
                this.timeStampGroup.dispose();
                this.timeStampGroup = null;
                this.timeStampComposite = null;
            } else if (this.timeStampGroup == null && allowTimeStamp) {
                this.timeStampComposite = this.createSelectTimeStampComposite();
            }
            this.layout();
        }
    }

    public CDOBranchPoint getBranchPoint() {
        return this.branchPoint;
    }

    public void setBranchPoint(CDOBranchPoint branchPoint) {
        this.branchPoint = branchPoint;
        if (branchPoint != null) {
            final CDOBranch branch = branchPoint.getBranch();
            long timeStamp = branchPoint.getTimeStamp();
            if (this.branchViewer != null) {
                this.setBranchViewerInput();
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ComposeBranchPointComposite.this.branchViewer.setSelection((ISelection)new StructuredSelection((Object)branch));
                    }
                });
            }
            if (this.timeStampComposite != null) {
                this.timeStampComposite.setBranch(branch);
                this.timeStampComposite.setTimeStamp(timeStamp);
            }
        }
    }

    public TreeViewer getBranchViewer() {
        return this.branchViewer;
    }

    public SelectTimeStampComposite getSelectTimeComposite() {
        return this.timeStampComposite;
    }

    @Deprecated
    public SelectBranchComposite getSelectBranchComposite() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public CDOSession getSession() {
        return null;
    }

    protected void createUI() {
        this.branchViewer = this.createBranchViewer();
        this.branchViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element == null) {
                    return;
                }
                if (element instanceof CDOBranch) {
                    CDOBranch branch = (CDOBranch)element;
                    if (ComposeBranchPointComposite.this.timeStampComposite != null) {
                        ComposeBranchPointComposite.this.timeStampComposite.setBranch(branch);
                    }
                    ComposeBranchPointComposite.this.composeBranchPoint();
                }
            }
        });
        if (this.allowTimeStamp) {
            this.timeStampComposite = this.createSelectTimeStampComposite();
        }
        if (this.branchPoint != null) {
            this.setBranchViewerInput();
        }
    }

    protected TreeViewer createBranchViewer() {
        CDOItemProvider itemProvider = this.createBranchItemProvider();
        TreeViewer branchViewer = new TreeViewer((Composite)this, 2052);
        branchViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        branchViewer.setLabelProvider((IBaseLabelProvider)itemProvider);
        branchViewer.setContentProvider((IContentProvider)itemProvider);
        branchViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ComposeBranchPointComposite.this.doubleClicked();
            }
        });
        return branchViewer;
    }

    protected CDOItemProvider createBranchItemProvider() {
        return new CDOItemProvider(null);
    }

    protected SelectTimeStampComposite createSelectTimeStampComposite() {
        this.timeStampGroup = new Group((Composite)this, 0);
        this.timeStampGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timeStampGroup.setLayout((Layout)new GridLayout(1, false));
        this.timeStampGroup.setText("Time Stamp:");
        SelectTimeStampComposite timeStampComposite = new SelectTimeStampComposite((Composite)this.timeStampGroup, 0, this.branchPoint == null ? null : this.branchPoint.getBranch(), this.branchPoint == null ? 0L : this.branchPoint.getTimeStamp()){

            @Override
            protected void timeStampChanged(long timeStamp) {
                ComposeBranchPointComposite.this.composeBranchPoint();
            }
        };
        timeStampComposite.getTimeBrowseButton().setVisible(false);
        timeStampComposite.setLayoutData(new GridData(4, 0x1000000, true, false));
        timeStampComposite.setValidationContext(new ValidationContext(){

            public void setValidationError(Object source, String message) {
                ComposeBranchPointComposite.this.timeStampError(message);
            }
        });
        return timeStampComposite;
    }

    @Deprecated
    protected SelectTimeStampComposite createSelectTimeStampComposite(CDOBranch branch, long timeStamp) {
        return this.createSelectTimeStampComposite();
    }

    @Deprecated
    protected SelectBranchComposite createSelectBranchComposite(CDOSession session, CDOBranch branch) {
        return new SelectBranchComposite(this, 0, session, branch){

            @Override
            protected void branchChanged(CDOBranch newBranch) {
                if (ComposeBranchPointComposite.this.timeStampComposite != null) {
                    ComposeBranchPointComposite.this.timeStampComposite.setBranch(newBranch);
                }
                ComposeBranchPointComposite.this.composeBranchPoint();
            }
        };
    }

    protected void timeStampError(String message) {
    }

    protected void branchPointChanged(CDOBranchPoint branchPoint) {
    }

    protected void doubleClicked() {
    }

    protected Object getBranchViewerInput(CDOBranchPoint branchPoint) {
        return branchPoint.getBranch().getBranchManager();
    }

    private void setBranchViewerInput() {
        Object input = this.getBranchViewerInput(this.branchPoint);
        if (input != this.branchViewer.getInput()) {
            this.branchViewer.setInput(input);
        }
    }

    private void composeBranchPoint() {
        if (this.branchViewer == null) {
            return;
        }
        CDOBranchPoint oldBranchPoint = this.branchPoint;
        IStructuredSelection selection = (IStructuredSelection)this.branchViewer.getSelection();
        CDOBranch branch = (CDOBranch)selection.getFirstElement();
        if (branch != null) {
            long timeStamp = 0L;
            if (this.allowTimeStamp && this.timeStampComposite != null) {
                timeStamp = this.timeStampComposite.getTimeStamp();
            }
            this.branchPoint = branch.getPoint(timeStamp);
            if (!ObjectUtil.equals((Object)this.branchPoint, (Object)oldBranchPoint)) {
                this.branchPointChanged(this.branchPoint);
            }
        }
    }
}

