/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.internal.ui.dialogs.RepositoryResourceSelectionDialog;
import org.eclipse.emf.cdo.ui.CDOLoadResourceProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class RepositoryLoadResourceProvider
implements CDOLoadResourceProvider,
CDOLoadResourceProvider.ImageProvider {
    @Override
    public String getButtonText(ResourceSet resourceSet) {
        int viewCount = 0;
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
        if (viewSet != null) {
            CDOView[] cDOViewArray = viewSet.getViews();
            int n = cDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOView view = cDOViewArray[n2];
                if (!view.isClosed() && ++viewCount > 1) break;
                ++n2;
            }
        }
        return viewCount == 1 ? "&Repository..." : "&Repositories...";
    }

    @Override
    public Image getButtonImage(ResourceSet resourceSet) {
        return SharedIcons.getImage((String)"obj16/repo.gif");
    }

    @Override
    public boolean canHandle(ResourceSet resourceSet) {
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
        if (viewSet != null) {
            CDOView[] cDOViewArray = viewSet.getViews();
            int n = cDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOView view = cDOViewArray[n2];
                if (!view.isClosed()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public List<URI> browseResources(ResourceSet resourceSet, Shell shell, boolean multi) {
        RepositoryResourceSelectionDialog dialog;
        ArrayList<CDOView> views = new ArrayList<CDOView>();
        CDOViewSet viewSet = CDOUtil.getViewSet((Notifier)resourceSet);
        if (viewSet != null) {
            CDOView[] cDOViewArray = viewSet.getViews();
            int n = cDOViewArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDOView view = cDOViewArray[n2];
                if (!view.isClosed()) {
                    views.add(view);
                }
                ++n2;
            }
        }
        if ((dialog = new RepositoryResourceSelectionDialog(shell, multi, views)).open() == 0) {
            return new ArrayList<URI>(dialog.getURIs());
        }
        return null;
    }
}

