/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSetMetaData;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericColumnDescriptor;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public final class GenericResultDescription
implements ResultDescription,
Formatable {
    private ResultColumnDescriptor[] columns;
    private String statementType;
    private transient ResultSetMetaData metaData;
    private Map<String, Integer> columnNameMap;

    public GenericResultDescription() {
    }

    public GenericResultDescription(ResultColumnDescriptor[] columns, String statementType) {
        this.columns = ArrayUtil.copy(columns);
        this.statementType = statementType;
    }

    public GenericResultDescription(ResultDescription rd, int[] theCols) {
        SanityManager.ASSERT(theCols != null, "theCols argument to GenericResultDescription is null");
        this.columns = new ResultColumnDescriptor[theCols.length];
        for (int i = 0; i < theCols.length; ++i) {
            this.columns[i] = rd.getColumnDescriptor(theCols[i]);
        }
        this.statementType = rd.getStatementType();
    }

    @Override
    public String getStatementType() {
        return this.statementType;
    }

    @Override
    public int getColumnCount() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public ResultColumnDescriptor[] getColumnInfo() {
        return ArrayUtil.copy(this.columns);
    }

    @Override
    public ResultColumnDescriptor getColumnInfo(int idx) {
        return this.columns[idx];
    }

    @Override
    public ResultColumnDescriptor getColumnDescriptor(int position) {
        return this.columns[position - 1];
    }

    @Override
    public ResultDescription truncateColumns(int truncateFrom) {
        if (truncateFrom <= 0 || this.columns == null) {
            SanityManager.THROWASSERT("bad truncate value: " + truncateFrom + " is too low");
        }
        if (truncateFrom > this.columns.length) {
            SanityManager.THROWASSERT("bad truncate value: " + truncateFrom + " is too high");
        }
        ResultColumnDescriptor[] newColumns = new ResultColumnDescriptor[truncateFrom - 1];
        System.arraycopy(this.columns, 0, newColumns, 0, newColumns.length);
        return new GenericResultDescription(newColumns, this.statementType);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int len = this.columns == null ? 0 : this.columns.length;
        out.writeObject(this.statementType);
        out.writeInt(len);
        while (len-- > 0) {
            if (!(this.columns[len] instanceof GenericColumnDescriptor)) {
                this.columns[len] = new GenericColumnDescriptor(this.columns[len]);
            }
            out.writeObject(this.columns[len]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.columns = null;
        this.statementType = (String)in.readObject();
        int len = in.readInt();
        if (len > 0) {
            this.columns = new GenericColumnDescriptor[len];
            while (len-- > 0) {
                this.columns[len] = (ResultColumnDescriptor)in.readObject();
            }
        }
    }

    @Override
    public int getTypeFormatId() {
        return 228;
    }

    public String toString() {
        StringBuffer colStr = new StringBuffer();
        for (int i = 0; i < this.columns.length; ++i) {
            colStr.append("column[" + i + "]\n");
            colStr.append(this.columns[i].toString());
        }
        return "GenericResultDescription\n\tStatementType = " + this.statementType + "\n\tCOLUMNS\n" + colStr.toString();
    }

    @Override
    public synchronized void setMetaData(ResultSetMetaData rsmd) {
        if (this.metaData == null) {
            this.metaData = rsmd;
        }
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() {
        return this.metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int findColumnInsenstive(String columnName) {
        Map<String, Integer> workMap;
        GenericResultDescription genericResultDescription = this;
        synchronized (genericResultDescription) {
            if (this.columnNameMap == null) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                for (int i = this.getColumnCount(); i >= 1; --i) {
                    String key = StringUtil.SQLToUpperCase(this.getColumnDescriptor(i).getName());
                    Integer value = i;
                    map.put(key, value);
                }
                this.columnNameMap = Collections.unmodifiableMap(map);
            }
            workMap = this.columnNameMap;
        }
        Integer val = workMap.get(columnName);
        if (val == null) {
            val = workMap.get(StringUtil.SQLToUpperCase(columnName));
        }
        if (val == null) {
            return -1;
        }
        return val;
    }
}

