/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class PropertyUtil {
    public static String sortProperties(Properties list) {
        return PropertyUtil.sortProperties(list, null);
    }

    public static String sortProperties(Properties list, String indent) {
        Set<Object> names = list == null ? Collections.emptySet() : list.stringPropertyNames();
        Object[] array = names.toArray(new String[names.size()]);
        Arrays.sort(array);
        StringBuilder buffer = new StringBuilder();
        if (indent == null) {
            buffer.append("{ ");
        }
        for (int ictr = 0; ictr < array.length; ++ictr) {
            if (ictr > 0 && indent == null) {
                buffer.append(", ");
            }
            Object key = array[ictr];
            if (indent != null) {
                buffer.append(indent);
            }
            buffer.append((String)key);
            buffer.append("=");
            String value = list.getProperty((String)key, "MISSING_VALUE");
            buffer.append(value);
            if (indent == null) continue;
            buffer.append("\n");
        }
        if (indent == null) {
            buffer.append(" }");
        }
        return buffer.toString();
    }

    public static void copyProperties(Properties src_prop, Properties dest_prop) {
        for (String key : src_prop.stringPropertyNames()) {
            dest_prop.put(key, src_prop.get(key));
        }
    }

    public static void loadWithTrimmedValues(InputStream iStr, Properties prop) throws IOException {
        if (iStr == null || prop == null) {
            return;
        }
        Properties p = new Properties();
        p.load(iStr);
        for (String tmpKey : p.stringPropertyNames()) {
            String tmpValue = p.getProperty(tmpKey);
            tmpValue = tmpValue.trim();
            prop.put(tmpKey, tmpValue);
        }
    }
}

