/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.id;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDString;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIdentifiable;
import org.eclipse.emf.cdo.common.id.CDOWithID;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.internal.common.id.CDOIDExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectLongWithClassifierImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectStringImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectStringWithClassifierImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDObjectUUIDImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectExternalImpl;
import org.eclipse.emf.cdo.internal.common.id.CDOIDTempObjectImpl;
import org.eclipse.emf.cdo.internal.common.messages.Messages;
import org.eclipse.emf.cdo.internal.common.revision.CDOIDAndBranchImpl;
import org.eclipse.emf.cdo.internal.common.revision.CDOIDAndVersionImpl;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.UUIDGenerator;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class CDOIDUtil {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDOIDUtil.class);

    private CDOIDUtil() {
    }

    public static <V> Map<CDOID, V> createMap() {
        return new HashMap();
    }

    public static <V> Map<CDOID, V> createMap(Map<? extends CDOID, ? extends V> map) {
        return new HashMap<CDOID, V>(map);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOID id, int version) {
        return new CDOIDAndVersionImpl(id, version);
    }

    public static CDOIDAndVersion createIDAndVersion(CDOIDAndVersion source) {
        return CDOIDUtil.createIDAndVersion(source.getID(), source.getVersion());
    }

    public static CDOIDAndBranch createIDAndBranch(CDOID id, CDOBranch branch) {
        return new CDOIDAndBranchImpl(id, branch);
    }

    public static CDOID getCDOID(Object object) {
        if (object == null) {
            return CDOID.NULL;
        }
        if (object == CDORevisionData.NIL) {
            return CDOID.NIL;
        }
        if (object instanceof CDOID) {
            return (CDOID)object;
        }
        if (object instanceof CDOWithID) {
            CDOID id = ((CDOWithID)object).cdoID();
            return id == null ? CDOID.NULL : id;
        }
        if (object instanceof CDOIdentifiable) {
            CDOID id = ((CDOIdentifiable)object).getID();
            return id == null ? CDOID.NULL : id;
        }
        return null;
    }

    public static boolean isNull(CDOID id) {
        return id == null || id.isNull();
    }

    public static long getLong(CDOID id) {
        if (id == null) {
            return 0L;
        }
        switch (id.getType()) {
            case NULL: {
                return 0L;
            }
            case OBJECT: {
                if (id instanceof CDOIDObjectLongImpl) {
                    return ((CDOIDObjectLongImpl)id).getLongValue();
                }
                if (id instanceof CDOIDObjectLongWithClassifierImpl) {
                    return ((CDOIDObjectLongWithClassifierImpl)id).getLongValue();
                }
                throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.0"), id.getClass().getName()));
            }
            case TEMP_OBJECT: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.1"));
            }
            case EXTERNAL_OBJECT: 
            case EXTERNAL_TEMP_OBJECT: {
                throw new IllegalArgumentException(Messages.getString("CDOIDUtil.2"));
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.3"), id.getClass().getName()));
    }

    public static String getString(CDOID id) {
        if (id instanceof CDOIDString) {
            return ((CDOIDString)id).getStringValue();
        }
        return null;
    }

    public static byte[] getByteArray(CDOID id) {
        if (id instanceof CDOIDObjectUUIDImpl) {
            return ((CDOIDObjectUUIDImpl)id).getByteArrayValue();
        }
        return null;
    }

    public static CDOClassifierRef getClassifierRef(CDOID id) {
        if (id instanceof CDOClassifierRef.Provider) {
            return ((CDOClassifierRef.Provider)((Object)id)).getClassifierRef();
        }
        return null;
    }

    public static CDOIDTemp createTempObject(int value) {
        return CDOIDTempObjectImpl.create(value);
    }

    public static CDOIDExternal createTempObjectExternal(String uri) {
        return CDOIDTempObjectExternalImpl.create(uri);
    }

    public static CDOID createLong(long value) {
        if (value == 0L) {
            return CDOID.NULL;
        }
        return CDOIDObjectLongImpl.create(value);
    }

    public static CDOID createLongWithClassifier(long value, CDOClassifierRef classifierRef) {
        return CDOIDObjectLongWithClassifierImpl.create(value, classifierRef);
    }

    public static CDOID createString(String value) {
        return CDOIDObjectStringImpl.create(value);
    }

    public static CDOID createStringWithClassifier(String value, CDOClassifierRef classifierRef) {
        return CDOIDObjectStringWithClassifierImpl.create(value, classifierRef);
    }

    public static CDOID createUUID(byte[] value) {
        return CDOIDObjectUUIDImpl.create(value);
    }

    public static CDOID createUUID() {
        byte[] value = new byte[16];
        UUIDGenerator.DEFAULT.generate(value);
        return CDOIDUtil.createUUID(value);
    }

    public static String encodeUUID(byte[] bytes) {
        return UUIDGenerator.DEFAULT.encode(bytes);
    }

    public static byte[] decodeUUID(String string) {
        return UUIDGenerator.DEFAULT.decode(string);
    }

    public static CDOIDExternal createExternal(String uri) {
        return CDOIDExternalImpl.create(uri);
    }

    public static void write(StringBuilder builder, Iterable<?> objects) {
        boolean first = true;
        for (Object object : objects) {
            CDOID id = CDOIDUtil.getCDOID(object);
            if (id == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            CDOIDUtil.write(builder, id);
        }
    }

    public static void write(StringBuilder builder, CDOID id) {
        if (id == null) {
            id = CDOID.NULL;
        }
        if (id instanceof InternalCDOIDObject) {
            CDOID.ObjectType subType = ((InternalCDOIDObject)id).getSubType();
            builder.append(subType.getID());
        } else {
            CDOID.Type type = id.getType();
            builder.append(type.getID());
        }
        builder.append(id.toURIFragment());
    }

    public static CDOID read(String uriFragment) {
        char typeID = uriFragment.charAt(0);
        Enum<?> literal = CDOID.Type.getLiteral(typeID);
        if (literal == null) {
            throw new IllegalArgumentException("Unknown type ID: " + typeID);
        }
        String fragment = uriFragment.substring(1);
        if (literal instanceof CDOID.ObjectType) {
            return CDOIDUtil.readCDOIDObject(fragment, (CDOID.ObjectType)literal);
        }
        CDOID.Type type = (CDOID.Type)literal;
        switch (type) {
            case NULL: {
                return CDOID.NULL;
            }
            case NIL: {
                return CDOID.NIL;
            }
            case TEMP_OBJECT: {
                return CDOIDTempObjectImpl.create(Integer.valueOf(fragment));
            }
            case EXTERNAL_OBJECT: {
                return CDOIDExternalImpl.create(fragment);
            }
            case EXTERNAL_TEMP_OBJECT: {
                return CDOIDTempObjectExternalImpl.create(fragment);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOIDUtil.5"), uriFragment));
    }

    private static CDOID readCDOIDObject(String fragment, CDOID.ObjectType subType) {
        switch (subType) {
            case LONG: {
                return CDOIDObjectLongImpl.create(fragment);
            }
            case STRING: {
                return CDOIDObjectStringImpl.create(fragment);
            }
            case LONG_WITH_CLASSIFIER: {
                return CDOIDObjectLongWithClassifierImpl.create(fragment);
            }
            case STRING_WITH_CLASSIFIER: {
                return CDOIDObjectStringWithClassifierImpl.create(fragment);
            }
            case UUID: {
                return CDOIDObjectUUIDImpl.create(fragment);
            }
        }
        throw new IllegalArgumentException("Subtype " + subType.name() + " not supported");
    }

    public static void write(CDODataOutput out, CDOID id) throws IOException {
        if (id == null) {
            id = CDOID.NULL;
        }
        if (id instanceof InternalCDOIDObject) {
            CDOID.ObjectType subType = ((InternalCDOIDObject)id).getSubType();
            int ordinal = subType.ordinal();
            if (TRACER.isEnabled()) {
                TRACER.format("Writing CDOIDObject of subtype {0} ({1})", new Object[]{ordinal, subType});
            }
            out.writeByte(-ordinal - 1);
        } else {
            CDOID.Type type = id.getType();
            int ordinal = type.ordinal();
            if (TRACER.isEnabled()) {
                TRACER.format("Writing CDOID of type {0} ({1})", new Object[]{ordinal, type});
            }
            out.writeByte(ordinal);
        }
        ((AbstractCDOID)id).write(out);
    }

    public static CDOID read(CDODataInput in) throws IOException {
        Object type;
        byte ordinal = in.readByte();
        if (ordinal < 0) {
            return CDOIDUtil.readCDOIDObject(in, -ordinal - 1);
        }
        if (TRACER.isEnabled()) {
            try {
                type = CDOID.Type.values()[ordinal].toString();
            }
            catch (RuntimeException ex) {
                type = ex.getMessage();
            }
            TRACER.format("Reading CDOID of type {0} ({1})", new Object[]{ordinal, type});
        }
        type = CDOID.Type.values()[ordinal];
        switch (CDOIDUtil.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$Type()[((Enum)type).ordinal()]) {
            case 1: {
                return CDOID.NULL;
            }
            case 2: {
                return CDOID.NIL;
            }
            case 7: {
                return CDOIDTempObjectImpl.create(in.readXInt());
            }
            case 4: {
                return CDOIDExternalImpl.create(in.readString());
            }
            case 6: {
                return CDOIDTempObjectExternalImpl.create(in.readString());
            }
        }
        throw new IOException("Illegal type: " + type);
    }

    private static CDOID readCDOIDObject(CDODataInput in, int subTypeOrdinal) throws IOException {
        Object subType;
        if (TRACER.isEnabled()) {
            try {
                subType = CDOID.ObjectType.values()[subTypeOrdinal].toString();
            }
            catch (RuntimeException ex) {
                subType = ex.getMessage();
            }
            TRACER.format("Reading CDOIDObject of subtype {0} ({1})", new Object[]{subTypeOrdinal, subType});
        }
        if ((subType = CDOID.ObjectType.values()[subTypeOrdinal]) == null) {
            throw new IllegalArgumentException("Subtype may not be null");
        }
        switch (CDOIDUtil.$SWITCH_TABLE$org$eclipse$emf$cdo$common$id$CDOID$ObjectType()[((Enum)subType).ordinal()]) {
            case 1: {
                return CDOIDObjectLongImpl.create(in);
            }
            case 2: {
                return CDOIDObjectStringImpl.create(in);
            }
            case 3: {
                return CDOIDObjectLongWithClassifierImpl.create(in);
            }
            case 4: {
                return CDOIDObjectStringWithClassifierImpl.create(in);
            }
            case 5: {
                return CDOIDObjectUUIDImpl.create(in);
            }
        }
        throw new IllegalArgumentException("Subtype " + ((Enum)subType).name() + " not supported");
    }

    public static boolean equals(CDOID id1, CDOID id2) {
        if (id1 == id2) {
            return true;
        }
        if (id1 == null) {
            return id2 == CDOID.NULL;
        }
        if (id2 == null) {
            return id1 == CDOID.NULL;
        }
        return false;
    }

    public static <K extends CDOIDAndVersion> K getKey(Collection<? extends CDOIDAndVersion> keys, CDOID id) {
        for (CDOIDAndVersion cDOIDAndVersion : keys) {
            if (cDOIDAndVersion.getID() != id) continue;
            CDOIDAndVersion result = cDOIDAndVersion;
            return (K)result;
        }
        return null;
    }

    @Deprecated
    public static CDOID createLongWithClassifier(CDOClassifierRef classifierRef, long value) {
        return CDOIDUtil.createLongWithClassifier(value, classifierRef);
    }

    @Deprecated
    public static CDOID createStringWithClassifier(CDOClassifierRef classifierRef, String value) {
        return CDOIDUtil.createStringWithClassifier(value, classifierRef);
    }

    @Deprecated
    public static AbstractCDOID createCDOIDObject(CDOID.ObjectType subType) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static void write(ExtendedDataOutput out, CDOID id) throws IOException {
        CDOIDUtil.write((CDODataOutput)out, id);
    }

    @Deprecated
    public static CDOID read(ExtendedDataInput in) throws IOException {
        return CDOIDUtil.read((CDODataInput)in);
    }
}

