/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.repositories.wizards;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.repositories.CDORepository;
import org.eclipse.emf.cdo.explorer.repositories.CDORepositoryManager;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.AbstractRepositoryPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryClonePage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryLocalPage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryRemotePage;
import org.eclipse.emf.cdo.explorer.ui.repositories.wizards.RepositoryTypePage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.net4j.util.security.IPasswordCredentials;

public class NewRepositoryWizard
extends Wizard {
    private RepositoryTypePage typePage;
    private RepositoryRemotePage remotePage;
    private RepositoryClonePage clonePage;
    private RepositoryLocalPage localPage;

    public NewRepositoryWizard() {
        this.setWindowTitle("New Repository");
        this.setNeedsProgressMonitor(false);
    }

    public final RepositoryTypePage getTypePage() {
        return this.typePage;
    }

    public final RepositoryRemotePage getRemotePage() {
        return this.remotePage;
    }

    public final RepositoryClonePage getClonePage() {
        return this.clonePage;
    }

    public final RepositoryLocalPage getLocalPage() {
        return this.localPage;
    }

    public void addPages() {
        this.typePage = new RepositoryTypePage();
        this.addPage((IWizardPage)this.typePage);
        this.remotePage = new RepositoryRemotePage();
        this.addPage((IWizardPage)this.remotePage);
        this.clonePage = new RepositoryClonePage();
        this.addPage((IWizardPage)this.clonePage);
        this.localPage = new RepositoryLocalPage();
        this.addPage((IWizardPage)this.localPage);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage != this.typePage && currentPage.isPageComplete();
    }

    public boolean performFinish() {
        AbstractRepositoryPage page = this.typePage.getNextPage();
        Properties properties = page.getProperties();
        IPasswordCredentials credentials = page.getCredentials();
        CDORepositoryManager repositoryManager = CDOExplorerUtil.getRepositoryManager();
        final CDORepository repository = repositoryManager.addRepository(properties, credentials);
        new Job("Connect"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    repository.connect();
                    return Status.OK_STATUS;
                }
                catch (Exception ex) {
                    return OM.BUNDLE.getStatus((Object)ex);
                }
            }
        }.schedule();
        return true;
    }
}

