/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.eresource.CDOFileResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutLobEditorInput;
import org.eclipse.emf.cdo.internal.explorer.CDOExplorerURIHandler;
import org.eclipse.emf.cdo.internal.ui.dialogs.EditObjectDialog;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.CDOEditorOpener;
import org.eclipse.emf.cdo.ui.CDOEditorUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class OpenWithActionProvider
extends CommonActionProvider {
    private ICommonViewerWorkbenchSite viewSite;
    private OpenAction openAction;

    public void init(ICommonActionExtensionSite aConfig) {
        if (aConfig.getViewSite() instanceof ICommonViewerWorkbenchSite) {
            this.viewSite = (ICommonViewerWorkbenchSite)aConfig.getViewSite();
            this.openAction = new OpenAction(this.viewSite.getPage());
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.viewSite == null) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        this.openAction.selectionChanged(selectedElement);
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.viewSite == null) {
            return;
        }
        Object selectedElement = this.getSelectedElement();
        this.openAction.selectionChanged(selectedElement);
        if (this.openAction.isEnabled()) {
            menu.insertAfter("group.open", (IAction)this.openAction);
            this.addOpenWithMenu(menu, selectedElement);
        }
    }

    private void addOpenWithMenu(IMenuManager menu, Object selectedElement) {
        CDOResourceLeaf resourceLeaf;
        List<IAction> actions;
        CDOObject cdoObject;
        CDOCheckout checkout;
        EObject openableElement = OpenWithActionProvider.getOpenableElement(selectedElement);
        if (openableElement != null && (checkout = CDOExplorerUtil.getCheckout((Object)(cdoObject = CDOUtil.getCDOObject((EObject)openableElement)))) != null && !(actions = this.collectOpenWithActions(resourceLeaf = OpenWithActionProvider.getResourceLeaf(cdoObject), cdoObject)).isEmpty()) {
            MenuManager submenu = new MenuManager("Open With", "group.openWith");
            submenu.add((IContributionItem)new GroupMarker("group.top"));
            for (IAction action : actions) {
                if (action != null) {
                    submenu.add(action);
                    continue;
                }
                submenu.add((IContributionItem)new Separator());
            }
            submenu.add((IContributionItem)new GroupMarker("additions"));
            menu.appendToGroup("group.open", (IContributionItem)submenu);
        }
    }

    private List<IAction> collectOpenWithActions(CDOResourceLeaf resourceLeaf, CDOObject cdoObject) {
        String[] editorIDs;
        int n;
        int n2;
        String[] stringArray;
        ArrayList<IAction> actions = new ArrayList<IAction>();
        URI uri = resourceLeaf.getURI();
        if (resourceLeaf instanceof CDOResource) {
            CDOEditorOpener[] editorOpeners = CDOEditorOpener.Registry.INSTANCE.getEditorOpeners(uri);
            stringArray = editorOpeners;
            n2 = editorOpeners.length;
            n = 0;
            while (n < n2) {
                String editorOpener = stringArray[n];
                actions.add((IAction)new OpenWithAction(this.viewSite.getPage(), (EObject)cdoObject, (CDOEditorOpener)editorOpener));
                ++n;
            }
            actions.add(null);
        }
        stringArray = editorIDs = CDOEditorUtil.getAllEditorIDs((CDOResourceLeaf)resourceLeaf);
        n2 = editorIDs.length;
        n = 0;
        while (n < n2) {
            String editorID = stringArray[n];
            if (!Objects.equals(editorID, CDOEditorUtil.getEditorID())) {
                actions.add((IAction)new OpenWithRegisteredEditorAction(this.viewSite.getPage(), editorID, resourceLeaf));
            }
            ++n;
        }
        return actions;
    }

    private Object getSelectedElement() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.size() == 1) {
            return selection.getFirstElement();
        }
        return null;
    }

    private static EObject getOpenableElement(Object element) {
        EObject eObject;
        CDOCheckout checkout;
        if (element instanceof EObject && (checkout = CDOExplorerUtil.getCheckout((Object)(eObject = (EObject)element))) != null && !(eObject instanceof CDOResourceFolder)) {
            return eObject;
        }
        return null;
    }

    private static CDOResourceLeaf getResourceLeaf(CDOObject cdoObject) {
        if (cdoObject instanceof CDOResourceLeaf) {
            return (CDOResourceLeaf)cdoObject;
        }
        if (cdoObject instanceof CDOResourceFolder) {
            return null;
        }
        return cdoObject.cdoResource();
    }

    public static void openEditor(IWorkbenchPage page, ComposedAdapterFactory adapterFactory, EObject object, String editorOpenerID) {
        String editorID;
        CDOObject cdoObject;
        CDOResourceLeaf resourceLeaf;
        if (page == null) {
            page = UIUtil.getActiveWorkbenchPage();
        }
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        if (editorOpenerID == null && !(object instanceof CDOResourceNode)) {
            if (adapterFactory == null) {
                return;
            }
            Shell shell = page.getWorkbenchWindow().getShell();
            if (OpenWithActionProvider.editObject(shell, adapterFactory, object)) {
                return;
            }
        }
        if ((resourceLeaf = OpenWithActionProvider.getResourceLeaf(cdoObject = CDOUtil.getCDOObject((EObject)object))) instanceof CDOResource) {
            CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)cdoObject);
            if (checkout != null) {
                CDOEditorOpener editorOpener;
                CDOEditorOpener[] editorOpeners;
                URI uri = resourceLeaf.getURI();
                if (!(object instanceof CDOResourceNode)) {
                    StringBuilder builder = new StringBuilder();
                    CDOIDUtil.write((StringBuilder)builder, (CDOID)cdoObject.cdoID());
                    String fragment = builder.toString();
                    uri = uri.appendFragment(fragment);
                }
                String defaultEditorOpenerID = (editorOpeners = CDOEditorOpener.Registry.INSTANCE.getEditorOpeners(uri.trimFragment())).length != 0 ? editorOpeners[0].getID() : null;
                CDOID objectID = cdoObject.cdoID();
                String lastEditorOpenerID = checkout.getEditorOpenerID(objectID);
                if (editorOpenerID == null) {
                    editorOpenerID = lastEditorOpenerID;
                }
                if (editorOpenerID == null) {
                    editorOpenerID = defaultEditorOpenerID;
                }
                if (editorOpenerID != null && (editorOpener = CDOEditorOpener.Registry.INSTANCE.getEditorOpener(editorOpenerID)) != null) {
                    if (!ObjectUtil.equals((Object)editorOpenerID, (Object)lastEditorOpenerID)) {
                        checkout.setEditorOpenerID(objectID, editorOpenerID);
                    }
                    if (cdoObject instanceof CDOResourceNode) {
                        uri = uri.trimFragment();
                    }
                    editorOpener.openEditor(page, uri);
                }
            }
        } else if (resourceLeaf instanceof CDOFileResource && (editorID = CDOEditorUtil.getEffectiveEditorID((CDOResourceLeaf)resourceLeaf)) != null) {
            OpenWithActionProvider.openFileEditor(page, editorID, resourceLeaf);
        }
    }

    private static void openFileEditor(IWorkbenchPage page, String editorID, CDOResourceLeaf resourceLeaf) {
        URI uri = CDOExplorerURIHandler.createURI((CDOResourceNode)resourceLeaf);
        try {
            CDOCheckoutLobEditorInput.openEditor(page, editorID, uri);
        }
        catch (PartInitException ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public static boolean editObject(Shell shell, ComposedAdapterFactory adapterFactory, EObject object) {
        CDOCheckout checkout;
        boolean edited = false;
        if (!(object instanceof CDOResourceNode) && (checkout = CDOExplorerUtil.getCheckout((Object)object)) != null) {
            AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
            ResourceSet resourceSet = editingDomain.getResourceSet();
            try (CDOTransaction transaction = checkout.openTransaction(resourceSet);){
                try {
                    EObject txObject = transaction.getObject(object);
                    int result = new EditObjectDialog(shell, adapterFactory, txObject).open();
                    edited = true;
                    if (result == 0) {
                        transaction.commit();
                    }
                }
                catch (Exception ex) {
                    OM.LOG.error((Throwable)ex);
                    transaction.close();
                }
            }
        }
        return edited;
    }

    private static class OpenAction
    extends Action {
        public static final String ID = "org.eclipse.emf.cdo.explorer.ui.OpenAction";
        private final IWorkbenchPage page;
        private EObject openableElement;

        public OpenAction(IWorkbenchPage page) {
            super("Open");
            this.setId(ID);
            this.setToolTipText("Edit this resource");
            this.page = page;
        }

        public void selectionChanged(Object selectedElement) {
            this.openableElement = OpenWithActionProvider.getOpenableElement(selectedElement);
            this.setEnabled(this.openableElement != null);
        }

        public void run() {
            OpenWithActionProvider.openEditor(this.page, null, this.openableElement, null);
        }
    }

    private static class OpenWithAction
    extends Action {
        public static final String ID = "org.eclipse.emf.cdo.explorer.ui.OpenWithAction";
        private final IWorkbenchPage page;
        private EObject openableElement;
        private CDOEditorOpener editorOpener;

        public OpenWithAction(IWorkbenchPage page, EObject openableElement, CDOEditorOpener editorOpener) {
            this.setId(ID);
            this.setText(editorOpener.getName());
            this.setImageDescriptor(editorOpener.getIcon());
            this.setToolTipText("Edit this resource");
            this.page = page;
            this.openableElement = openableElement;
            this.editorOpener = editorOpener;
        }

        public void run() {
            OpenWithActionProvider.openEditor(this.page, null, this.openableElement, this.editorOpener.getID());
        }
    }

    private static class OpenWithRegisteredEditorAction
    extends Action {
        private static final IEditorRegistry EDITOR_REGISTRY = PlatformUI.getWorkbench().getEditorRegistry();
        private IWorkbenchPage page;
        private String editorID;
        private CDOResourceLeaf resourceLeaf;

        public OpenWithRegisteredEditorAction(IWorkbenchPage page, String editorID, CDOResourceLeaf resourceLeaf) {
            this.page = page;
            this.editorID = editorID;
            this.resourceLeaf = resourceLeaf;
            IEditorDescriptor editorDescriptor = EDITOR_REGISTRY.findEditor(editorID);
            this.setText(editorDescriptor.getLabel());
            this.setImageDescriptor(editorDescriptor.getImageDescriptor());
            this.setToolTipText("Edit this resource");
        }

        public void run() {
            if (this.resourceLeaf instanceof CDOResource) {
                CDOEditorUtil.openEditor((IWorkbenchPage)this.page, (String)this.editorID, (CDOResourceLeaf)this.resourceLeaf);
            } else {
                OpenWithActionProvider.openFileEditor(this.page, this.editorID, this.resourceLeaf);
            }
        }
    }
}

