/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.services.daemon.IndexStatisticsDaemonImpl;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;
import org.apache.derby.impl.sql.execute.UniqueWithDuplicateNullsIndexSortObserver;

class CreateIndexConstantAction
extends IndexConstantAction {
    private final boolean forCreateTable;
    private boolean unique;
    private boolean uniqueWithDuplicateNulls;
    private boolean uniqueDeferrable;
    private final boolean hasDeferrableChecking;
    private final boolean initiallyDeferred;
    private final int constraintType;
    private String indexType;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;
    private long conglomId;
    private long droppedConglomNum;

    CreateIndexConstantAction(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, String string, String string2, String string3, String string4, UUID uUID, String[] stringArray, boolean[] blArray, boolean bl6, UUID uUID2, Properties properties) {
        super(uUID, string3, string4, string2);
        this.forCreateTable = bl;
        this.unique = bl2 && !bl4;
        this.uniqueWithDuplicateNulls = bl3;
        this.hasDeferrableChecking = bl4;
        this.initiallyDeferred = bl5;
        this.constraintType = n;
        this.uniqueDeferrable = bl2 && bl4;
        this.indexType = string;
        this.columnNames = stringArray;
        this.isAscending = blArray;
        this.isConstraint = bl6;
        this.conglomerateUUID = uUID2;
        this.properties = properties;
        this.conglomId = -1L;
        this.droppedConglomNum = -1L;
    }

    CreateIndexConstantAction(ConglomerateDescriptor conglomerateDescriptor, TableDescriptor tableDescriptor, Properties properties) {
        super(tableDescriptor.getUUID(), conglomerateDescriptor.getConglomerateName(), tableDescriptor.getName(), tableDescriptor.getSchemaName());
        this.forCreateTable = false;
        this.droppedConglomNum = conglomerateDescriptor.getConglomerateNumber();
        IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
        this.unique = indexRowGenerator.isUnique();
        this.uniqueWithDuplicateNulls = indexRowGenerator.isUniqueWithDuplicateNulls();
        this.hasDeferrableChecking = false;
        this.uniqueDeferrable = false;
        this.initiallyDeferred = false;
        this.constraintType = -1;
        this.indexType = indexRowGenerator.indexType();
        this.columnNames = conglomerateDescriptor.getColumnNames();
        this.isAscending = indexRowGenerator.isAscending();
        this.isConstraint = conglomerateDescriptor.isConstraint();
        this.conglomerateUUID = conglomerateDescriptor.getUUID();
        this.properties = properties;
        this.conglomId = -1L;
        if (this.columnNames == null) {
            int[] nArray = indexRowGenerator.baseColumnPositions();
            this.columnNames = new String[nArray.length];
            ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
            for (int i = 0; i < nArray.length; ++i) {
                this.columnNames[i] = columnDescriptorList.elementAt(nArray[i] - 1).getColumnName();
            }
        }
    }

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        CardinalityCounter cardinalityCounter;
        long l;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2;
        Object object5;
        int n3;
        Object object6;
        IndexRowGenerator indexRowGenerator = null;
        int n4 = -1;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
        TableDescriptor tableDescriptor = activation.getDDLTableDescriptor();
        if (tableDescriptor == null) {
            tableDescriptor = this.tableId != null ? dataDictionary.getTableDescriptor(this.tableId) : dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor, transactionController);
        }
        if (tableDescriptor == null) {
            throw StandardException.newException("X0Y38.S", this.indexName, this.tableName);
        }
        if (tableDescriptor.getTableType() == 1) {
            throw StandardException.newException("X0Y28.S", this.indexName, this.tableName);
        }
        this.lockTableForDDL(transactionController, tableDescriptor.getHeapConglomerateId(), false);
        if (!this.forCreateTable) {
            dependencyManager.invalidateFor(tableDescriptor, 3, languageConnectionContext);
        }
        int[] nArray = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ClassFactory classFactory;
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", this.columnNames[i], this.tableName);
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            boolean bl = typeId.orderable(classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory());
            if (bl && typeId.userType()) {
                object6 = typeId.getCorrespondingJavaTypeName();
                try {
                    if (classFactory.isApplicationClass(classFactory.loadApplicationClass((String)object6))) {
                        bl = false;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    bl = false;
                }
            }
            if (!bl) {
                throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
            }
            nArray[i] = columnDescriptor.getPosition();
            if (n4 >= nArray[i]) continue;
            n4 = nArray[i];
        }
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        boolean bl = false;
        for (n3 = 0; n3 < conglomerateDescriptorArray.length; ++n3) {
            ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[n3];
            if (!conglomerateDescriptor.isIndex() || this.droppedConglomNum == conglomerateDescriptor.getConglomerateNumber()) continue;
            object6 = conglomerateDescriptor.getIndexDescriptor();
            object5 = ((IndexRowGenerator)object6).baseColumnPositions();
            boolean[] blArray = ((IndexRowGenerator)object6).isAscending();
            n2 = 0;
            int n5 = n = (((IndexRowGenerator)object6).isUnique() || !this.unique) && ((int[])object5).length == nArray.length && !this.hasDeferrableChecking ? 1 : 0;
            if (n != 0 && !((IndexRowGenerator)object6).isUnique()) {
                int n6 = n = ((IndexRowGenerator)object6).isUniqueWithDuplicateNulls() || !this.uniqueWithDuplicateNulls ? 1 : 0;
            }
            if (n != 0 && this.indexType.equals(((IndexRowGenerator)object6).indexType())) {
                while (n2 < ((Object)object5).length && object5[n2] == nArray[n2] && blArray[n2] == this.isAscending[n2]) {
                    ++n2;
                }
            }
            if (n2 != nArray.length) continue;
            if (!this.isConstraint) {
                activation.addWarning(StandardException.newWarning("01504", conglomerateDescriptor.getConglomerateName()));
                return;
            }
            this.conglomId = conglomerateDescriptor.getConglomerateNumber();
            indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, false, false, nArray, this.isAscending, nArray.length);
            this.conglomerateUUID = dataDictionary.getUUIDFactory().createUUID();
            bl = true;
            break;
        }
        n3 = this.droppedConglomNum > -1L ? 1 : 0;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (bl && n3 == 0) {
            object6 = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
            dataDictionary.addDescriptor((TupleDescriptor)object6, schemaDescriptor, 0, false, transactionController);
            object5 = tableDescriptor.getConglomerateDescriptorList();
            ((ArrayList)object5).add(object6);
        }
        object6 = this.properties != null ? this.properties : new Properties();
        ((Properties)object6).put("baseConglomerateId", Long.toString(tableDescriptor.getHeapConglomerateId()));
        if (this.uniqueWithDuplicateNulls && !this.hasDeferrableChecking) {
            if (dataDictionary.checkVersion(160, null)) {
                ((Properties)object6).put("uniqueWithDuplicateNulls", Boolean.toString(true));
            } else if (this.uniqueWithDuplicateNulls) {
                this.unique = true;
            }
        }
        ((Properties)object6).put("nUniqueColumns", Integer.toString(this.unique ? nArray.length : nArray.length + 1));
        ((Properties)object6).put("rowLocationColumn", Integer.toString(nArray.length));
        ((Properties)object6).put("nKeyFields", Integer.toString(nArray.length + 1));
        if (!bl) {
            indexRowGenerator = dataDictionary.checkVersion(160, null) ? new IndexRowGenerator(this.indexType, this.unique, this.uniqueWithDuplicateNulls, this.uniqueDeferrable, this.hasDeferrableChecking && this.constraintType != 6, nArray, this.isAscending, nArray.length) : new IndexRowGenerator(this.indexType, this.unique, false, false, false, nArray, this.isAscending, nArray.length);
        }
        RowSource rowSource = null;
        long l2 = 0L;
        boolean bl2 = false;
        int n7 = this.forCreateTable ? 1 : 16;
        n2 = tableDescriptor.getNumberOfColumns();
        n = 0;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2 + 1);
        for (int i = 0; i < nArray.length; ++i) {
            formatableBitSet.set(nArray[i]);
        }
        FormatableBitSet formatableBitSet2 = RowUtil.shift(formatableBitSet, 1);
        GroupFetchScanController groupFetchScanController = transactionController.openGroupFetchScan(tableDescriptor.getHeapConglomerateId(), false, 0, 7, 5, formatableBitSet2, null, 0, null, null, 0);
        ExecRow[] execRowArray = new ExecRow[n7];
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n7];
        ExecRow[] execRowArray2 = new ExecRow[n7];
        try {
            Serializable serializable;
            for (int i = 0; i < n7; ++i) {
                execRowArray[i] = activation.getExecutionFactory().getValueRow(n4);
                execIndexRowArray[i] = indexRowGenerator.getIndexRowTemplate();
                execRowArray2[i] = activation.getExecutionFactory().getValueRow(nArray.length);
            }
            this.indexTemplateRow = execIndexRowArray[0];
            object4 = tableDescriptor.getColumnDescriptorList();
            int n8 = ((ArrayList)object4).size();
            int n9 = 0;
            for (int i = 0; i < n8; ++i) {
                if (!formatableBitSet2.get(i)) continue;
                ++n9;
                object3 = ((ColumnDescriptorList)object4).elementAt(i);
                serializable = ((ColumnDescriptor)object3).getType();
                for (int j = 0; j < n7; ++j) {
                    execRowArray[j].setColumn(i + 1, ((DataTypeDescriptor)serializable).getNull());
                    execRowArray2[j].setColumn(n9, execRowArray[j].getColumn(i + 1));
                }
                n += ((DataTypeDescriptor)serializable).getTypeId().getApproximateLengthInBytes((DataTypeDescriptor)serializable);
            }
            object2 = new RowLocation[n7];
            for (n9 = 0; n9 < n7; ++n9) {
                object2[n9] = groupFetchScanController.newRowLocationTemplate();
                indexRowGenerator.getIndexRow(execRowArray2[n9], object2[n9], execIndexRowArray[n9], formatableBitSet);
            }
            if (bl) {
                return;
            }
            serializable = null;
            if (this.unique || this.uniqueWithDuplicateNulls || this.uniqueDeferrable) {
                String string = this.indexName;
                if (this.conglomerateUUID != null) {
                    ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.conglomerateUUID);
                    if (this.isConstraint && conglomerateDescriptor != null && conglomerateDescriptor.getUUID() != null && tableDescriptor != null) {
                        ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                        string = constraintDescriptor.getConstraintName();
                    }
                }
                if (this.unique || this.uniqueDeferrable) {
                    n9 = this.unique ? nArray.length : nArray.length + 1;
                    object3 = new UniqueIndexSortObserver(languageConnectionContext, this.constraintID, true, this.uniqueDeferrable, this.initiallyDeferred, string, this.indexTemplateRow, true, tableDescriptor.getName());
                } else {
                    n9 = nArray.length + 1;
                    serializable = new Properties();
                    ((Properties)serializable).put("implType", "sort almost unique external");
                    object3 = new UniqueWithDuplicateNullsIndexSortObserver(languageConnectionContext, this.constraintID, true, this.hasDeferrableChecking && this.constraintType != 6, this.initiallyDeferred, string, this.indexTemplateRow, true, tableDescriptor.getName());
                }
            } else {
                n9 = nArray.length + 1;
                object3 = new BasicSortObserver(true, false, this.indexTemplateRow, true);
            }
            object = new ColumnOrdering[n9];
            for (int i = 0; i < n9; ++i) {
                object[i] = new IndexColumnOrder(i, this.unique || i < n9 - 1 ? this.isAscending[i] : true);
            }
            l2 = transactionController.createSort((Properties)serializable, this.indexTemplateRow.getRowArrayClone(), (ColumnOrdering[])object, (SortObserver)object3, false, groupFetchScanController.getEstimatedRowCount(), n);
            bl2 = true;
            rowSource = this.loadSorter(execRowArray, execIndexRowArray, transactionController, groupFetchScanController, l2, (RowLocation[])object2);
            this.conglomId = transactionController.createAndLoadConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), (ColumnOrdering[])object, indexRowGenerator.getColumnCollationIds(tableDescriptor.getColumnDescriptorList()), (Properties)object6, 0, (RowLocationRetRowSource)rowSource, null);
        }
        finally {
            if (groupFetchScanController != null) {
                groupFetchScanController.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (bl2) {
                transactionController.dropSort(l2);
            }
        }
        object4 = transactionController.openConglomerate(this.conglomId, false, 0, 7, 5);
        if (!object4.isKeyed()) {
            object4.close();
            throw StandardException.newException("X0X85.S", this.indexName, this.indexType);
        }
        object4.close();
        if (n3 == 0) {
            ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
            dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
            object2 = tableDescriptor.getConglomerateDescriptorList();
            ((ArrayList)object2).add(conglomerateDescriptor);
            this.conglomerateUUID = conglomerateDescriptor.getUUID();
        }
        if (this.addStatistics(dataDictionary, indexRowGenerator, l = (cardinalityCounter = (CardinalityCounter)rowSource).getRowCount())) {
            object3 = cardinalityCounter.getCardinality();
            for (int i = 0; i < ((Object)object3).length; ++i) {
                object = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), this.conglomerateUUID, tableDescriptor.getUUID(), "I", new StatisticsImpl(l, (long)object3[i]), i + 1);
                dataDictionary.addDescriptor((TupleDescriptor)object, null, 14, true, transactionController);
            }
        }
    }

    private boolean addStatistics(DataDictionary dataDictionary, IndexRowGenerator indexRowGenerator, long l) throws StandardException {
        boolean bl;
        boolean bl2 = bl = l > 0L;
        if (dataDictionary.checkVersion(210, null) && ((IndexStatisticsDaemonImpl)dataDictionary.getIndexStatsRefresher((boolean)false)).skipDisposableStats && bl && indexRowGenerator.isUnique() && indexRowGenerator.numberOfOrderedColumns() == 1) {
            bl = false;
        }
        return bl;
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    long getCreatedConglomNumber() {
        return this.conglomId;
    }

    long getReplacedConglomNumber() {
        return this.droppedConglomNum;
    }

    UUID getCreatedUUID() {
        return this.conglomerateUUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocationRetRowSource loadSorter(ExecRow[] execRowArray, ExecIndexRow[] execIndexRowArray, TransactionController transactionController, GroupFetchScanController groupFetchScanController, long l, RowLocation[] rowLocationArray) throws StandardException {
        long l2 = 0L;
        SortController sortController = transactionController.openSort(l);
        try {
            int n;
            int n2 = execRowArray.length;
            DataValueDescriptor[][] dataValueDescriptorArray = new DataValueDescriptor[n2][];
            for (n = 0; n < n2; ++n) {
                dataValueDescriptorArray[n] = execRowArray[n].getRowArray();
            }
            while ((n = groupFetchScanController.fetchNextGroup(dataValueDescriptorArray, rowLocationArray)) > 0) {
                for (int i = 0; i < n; ++i) {
                    sortController.insert(execIndexRowArray[i].getRowArray());
                    ++l2;
                }
            }
            groupFetchScanController.setEstimatedRowCount(l2);
        }
        finally {
            sortController.completedInserts();
        }
        return new CardinalityCounter(transactionController.openSortRowSource(l));
    }
}

