/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import org.apache.derby.iapi.util.ReuseFactory;

class ColumnOrdering {
    int myDirection;
    private final ArrayList<Integer> columns = new ArrayList();
    private final ArrayList<Integer> tables = new ArrayList();

    ColumnOrdering(int n) {
        this.myDirection = n;
    }

    boolean ordered(int n, int n2, int n3) {
        if (n != 3 && n != this.myDirection) {
            return false;
        }
        return this.contains(n2, n3);
    }

    boolean contains(int n, int n2) {
        for (int i = 0; i < this.columns.size(); ++i) {
            Integer n3 = this.columns.get(i);
            Integer n4 = this.tables.get(i);
            if (n4 != n || n3 != n2) continue;
            return true;
        }
        return false;
    }

    int direction() {
        return this.myDirection;
    }

    void addColumn(int n, int n2) {
        this.tables.add(ReuseFactory.getInteger(n));
        this.columns.add(ReuseFactory.getInteger(n2));
    }

    void removeColumns(int n) {
        for (int i = this.tables.size() - 1; i >= 0; --i) {
            Integer n2 = this.tables.get(i);
            if (n2 != n) continue;
            this.tables.remove(i);
            this.columns.remove(i);
        }
    }

    boolean empty() {
        return this.tables.isEmpty();
    }

    ColumnOrdering cloneMe() {
        ColumnOrdering columnOrdering = new ColumnOrdering(this.myDirection);
        for (int i = 0; i < this.columns.size(); ++i) {
            columnOrdering.columns.add(this.columns.get(i));
            columnOrdering.tables.add(this.tables.get(i));
        }
        return columnOrdering;
    }

    boolean hasTable(int n) {
        return this.tables.contains(ReuseFactory.getInteger(n));
    }

    boolean hasAnyOtherTable(int n) {
        for (int i = 0; i < this.tables.size(); ++i) {
            Integer n2 = this.tables.get(i);
            if (n2 == n) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "";
        return string;
    }
}

