/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

class BooleanTypeCompiler
extends BaseTypeCompiler {
    BooleanTypeCompiler() {
    }

    @Override
    public boolean convertible(TypeId typeId, boolean bl) {
        return typeId.isStringTypeId() || typeId.isBooleanTypeId();
    }

    @Override
    public boolean compatible(TypeId typeId) {
        return this.convertible(typeId, false);
    }

    @Override
    public boolean storable(TypeId typeId, ClassFactory classFactory) {
        if (typeId.isBooleanTypeId() || typeId.isStringTypeId()) {
            return true;
        }
        return this.userTypeStorable(this.getTypeId(), typeId, classFactory);
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.BooleanDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return "boolean";
    }

    @Override
    public String getPrimitiveMethodName() {
        return "getBoolean";
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dataTypeDescriptor) {
        return 5;
    }

    @Override
    String nullMethodName() {
        return "getNullBoolean";
    }
}

