/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;

public final class SQLTimestamp
extends DataType
implements DateTimeDataValue {
    static final int MAX_FRACTION_DIGITS = 9;
    static final int FRACTION_TO_NANO = 1;
    static final int ONE_BILLION = 1000000000;
    private int encodedDate;
    private int encodedTime;
    private int nanos;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLTimestamp.class);
    static final char DATE_SEPARATOR = '-';
    private static final char[] DATE_SEPARATORS = new char[]{'-'};
    private static final char IBM_DATE_TIME_SEPARATOR = '-';
    private static final char ODBC_DATE_TIME_SEPARATOR = ' ';
    private static final char[] DATE_TIME_SEPARATORS = new char[]{'-', ' '};
    private static final char[] DATE_TIME_SEPARATORS_OR_END = new char[]{'-', ' ', '\u0000'};
    private static final char IBM_TIME_SEPARATOR = '.';
    private static final char ODBC_TIME_SEPARATOR = ':';
    private static final char[] TIME_SEPARATORS = new char[]{'.', ':'};
    private static final char[] TIME_SEPARATORS_OR_END = new char[]{'.', ':', '\u0000'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};

    @Override
    public int estimateMemoryUsage() {
        int n = BASE_MEMORY_USAGE;
        return n;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            String string = this.getTimestamp(null).toString();
            int n = string.indexOf(45);
            if (n >= 0 && n < 4) {
                StringBuffer stringBuffer = new StringBuffer();
                while (n < 4) {
                    stringBuffer.append('0');
                    ++n;
                }
                stringBuffer.append(string);
                string = stringBuffer.toString();
            }
            return string;
        }
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.clear();
        SQLDate.setDateInCalendar(calendar, this.encodedDate);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public Time getTime(Calendar calendar) throws StandardException {
        if (this.isNull()) {
            return null;
        }
        return SQLTime.getTime(calendar, this.encodedTime, this.nanos);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp(null);
    }

    @Override
    public int getLength() {
        return 12;
    }

    @Override
    public String getTypeName() {
        return "TIMESTAMP";
    }

    @Override
    public int getTypeFormatId() {
        return 31;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.encodedDate);
        objectOutput.writeInt(this.encodedTime);
        objectOutput.writeInt(this.nanos);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.encodedDate = objectInput.readInt();
        this.encodedTime = objectInput.readInt();
        this.nanos = objectInput.readInt();
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLTimestamp(this.encodedDate, this.encodedTime, this.nanos);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLTimestamp();
    }

    @Override
    public void restoreToNull() {
        this.encodedDate = 0;
        this.encodedTime = 0;
        this.nanos = 0;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException, StandardException {
        this.setValue(resultSet.getTimestamp(n), (Calendar)null);
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl = this.isNull();
        boolean bl2 = dataValueDescriptor.isNull();
        if (bl || bl2) {
            if (!bl) {
                return -1;
            }
            if (!bl2) {
                return 1;
            }
            return 0;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (dataValueDescriptor instanceof SQLTimestamp) {
            SQLTimestamp sQLTimestamp = (SQLTimestamp)dataValueDescriptor;
            n = sQLTimestamp.encodedDate;
            n2 = sQLTimestamp.encodedTime;
            n3 = sQLTimestamp.nanos;
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Timestamp timestamp = dataValueDescriptor.getTimestamp(gregorianCalendar);
            n = SQLTimestamp.computeEncodedDate(timestamp, gregorianCalendar);
            n2 = SQLTimestamp.computeEncodedTime(timestamp, gregorianCalendar);
            n3 = timestamp.getNanos();
        }
        int n4 = this.encodedDate < n ? -1 : (this.encodedDate > n ? 1 : (this.encodedTime < n2 ? -1 : (this.encodedTime > n2 ? 1 : (this.nanos < n3 ? -1 : (this.nanos > n3 ? 1 : 0)))));
        return n4;
    }

    @Override
    public boolean compare(int n, DataValueDescriptor dataValueDescriptor, boolean bl, boolean bl2) throws StandardException {
        if (!bl && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl2;
        }
        return super.compare(n, dataValueDescriptor, bl, bl2);
    }

    public SQLTimestamp() {
    }

    public SQLTimestamp(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.setValue(timestamp, calendar);
    }

    public SQLTimestamp(Timestamp timestamp) throws StandardException {
        this(timestamp, (Calendar)null);
    }

    SQLTimestamp(int n, int n2, int n3) {
        this.encodedDate = n;
        this.encodedTime = n2;
        this.nanos = n3;
    }

    public SQLTimestamp(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        DataType dataType;
        GregorianCalendar gregorianCalendar = null;
        if (dataValueDescriptor == null || dataValueDescriptor.isNull() || dataValueDescriptor2 == null || dataValueDescriptor2.isNull()) {
            return;
        }
        if (dataValueDescriptor instanceof SQLDate) {
            dataType = (SQLDate)dataValueDescriptor;
            this.encodedDate = ((SQLDate)dataType).getEncodedDate();
        } else {
            gregorianCalendar = new GregorianCalendar();
            this.encodedDate = SQLTimestamp.computeEncodedDate(dataValueDescriptor.getDate(gregorianCalendar), gregorianCalendar);
        }
        if (dataValueDescriptor2 instanceof SQLTime) {
            dataType = (SQLTime)dataValueDescriptor2;
            this.encodedTime = ((SQLTime)dataType).getEncodedTime();
        } else {
            if (gregorianCalendar == null) {
                gregorianCalendar = new GregorianCalendar();
            }
            this.encodedTime = SQLTimestamp.computeEncodedTime(dataValueDescriptor2.getTime(gregorianCalendar), gregorianCalendar);
        }
    }

    public SQLTimestamp(String string, boolean bl, LocaleFinder localeFinder) throws StandardException {
        this.parseTimestamp(string, bl, localeFinder, null);
    }

    public SQLTimestamp(String string, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        this.parseTimestamp(string, bl, localeFinder, calendar);
    }

    private void parseTimestamp(String string, boolean bl, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        StandardException standardException = null;
        DateTimeParser dateTimeParser = new DateTimeParser(string);
        try {
            int[] nArray = SQLTimestamp.parseDateOrTimestamp(dateTimeParser, true);
            this.encodedDate = nArray[0];
            this.encodedTime = nArray[1];
            this.nanos = nArray[2];
            return;
        }
        catch (StandardException standardException2) {
            standardException = standardException2;
            try {
                string = StringUtil.trimTrailing(string);
                int[] nArray = SQLTimestamp.parseLocalTimestamp(string, localeFinder, calendar);
                this.encodedDate = nArray[0];
                this.encodedTime = nArray[1];
                return;
            }
            catch (ParseException parseException) {
            }
            catch (StandardException standardException3) {
                // empty catch block
            }
            if (standardException != null) {
                throw standardException;
            }
            throw StandardException.newException("22007.S.181", new Object[0]);
        }
    }

    static int[] parseLocalTimestamp(String string, LocaleFinder localeFinder, Calendar calendar) throws StandardException, ParseException {
        DateFormat dateFormat = null;
        dateFormat = localeFinder == null ? DateFormat.getDateTimeInstance() : (calendar == null ? localeFinder.getTimestampFormat() : (DateFormat)localeFinder.getTimestampFormat().clone());
        if (calendar == null) {
            calendar = new GregorianCalendar();
        } else {
            dateFormat.setCalendar(calendar);
        }
        java.util.Date date = dateFormat.parse(string);
        return new int[]{SQLTimestamp.computeEncodedDate(date, calendar), SQLTimestamp.computeEncodedTime(date, calendar)};
    }

    static int[] parseDateOrTimestamp(DateTimeParser dateTimeParser, boolean bl) throws StandardException {
        int n = dateTimeParser.parseInt(4, false, DATE_SEPARATORS, false);
        int n2 = dateTimeParser.parseInt(2, true, DATE_SEPARATORS, false);
        int n3 = dateTimeParser.parseInt(2, true, bl ? DATE_TIME_SEPARATORS : DATE_TIME_SEPARATORS_OR_END, false);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (dateTimeParser.getCurrentSeparator() != '\u0000') {
            char c = dateTimeParser.getCurrentSeparator() == ' ' ? (char)':' : '.';
            n4 = dateTimeParser.parseInt(2, true, TIME_SEPARATORS, false);
            if (c == dateTimeParser.getCurrentSeparator()) {
                n5 = dateTimeParser.parseInt(2, false, TIME_SEPARATORS, false);
                if (c == dateTimeParser.getCurrentSeparator()) {
                    n6 = dateTimeParser.parseInt(2, false, TIME_SEPARATORS_OR_END, false);
                    if (dateTimeParser.getCurrentSeparator() == '.') {
                        n7 = dateTimeParser.parseInt(9, true, END_OF_STRING, true) * 1;
                    }
                }
            }
        }
        dateTimeParser.checkEnd();
        return new int[]{SQLDate.computeEncodedDate(n, n2, n3), SQLTime.computeEncodedTime(n4, n5, n6), n7};
    }

    @Override
    void setObject(Object object) throws StandardException {
        this.setValue((Timestamp)object);
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLTimestamp) {
            this.restoreToNull();
            SQLTimestamp sQLTimestamp = (SQLTimestamp)dataValueDescriptor;
            this.encodedDate = sQLTimestamp.encodedDate;
            this.encodedTime = sQLTimestamp.encodedTime;
            this.nanos = sQLTimestamp.nanos;
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            this.setValue(dataValueDescriptor.getTimestamp(gregorianCalendar), (Calendar)gregorianCalendar);
        }
    }

    @Override
    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.restoreToNull();
        if (date != null) {
            if (calendar == null) {
                calendar = new GregorianCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(date, calendar);
        }
    }

    @Override
    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.setNumericTimestamp(timestamp, calendar);
    }

    @Override
    public void setValue(String string) throws StandardException {
        this.restoreToNull();
        if (string != null) {
            DatabaseContext databaseContext = (DatabaseContext)ContextService.getContext("Database");
            this.parseTimestamp(string, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    NumberDataValue nullValueDouble() {
        return new SQLDouble();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), numberDataValue);
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), numberDataValue);
    }

    @Override
    public NumberDataValue getDate(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), numberDataValue);
    }

    @Override
    public NumberDataValue getHours(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getHour(this.encodedTime), numberDataValue);
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLTime.getMinute(this.encodedTime), numberDataValue);
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueDouble();
        }
        NumberDataValue numberDataValue2 = numberDataValue != null ? numberDataValue : new SQLDouble();
        numberDataValue2.setValue((double)SQLTime.getSecond(this.encodedTime) + (double)this.nanos / 1.0E9);
        return numberDataValue2;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getTimestamp(null).toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.encodedDate + this.encodedTime + this.nanos;
    }

    @Override
    public int typePrecedence() {
        return 110;
    }

    @Override
    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        this.setCalendar(calendar);
        Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
        timestamp.setNanos(this.nanos);
        return timestamp;
    }

    private void setCalendar(Calendar calendar) {
        calendar.clear();
        SQLDate.setDateInCalendar(calendar, this.encodedDate);
        SQLTime.setTimeInCalendar(calendar, this.encodedTime);
        calendar.set(14, 0);
    }

    private void setNumericTimestamp(Timestamp timestamp, Calendar calendar) throws StandardException {
        if (timestamp != null) {
            if (calendar == null) {
                calendar = new GregorianCalendar();
            }
            this.encodedDate = SQLTimestamp.computeEncodedDate(timestamp, calendar);
            this.encodedTime = SQLTimestamp.computeEncodedTime(timestamp, calendar);
            this.nanos = timestamp.getNanos();
        }
    }

    private static int computeEncodedDate(java.util.Date date, Calendar calendar) throws StandardException {
        if (date == null) {
            return 0;
        }
        calendar.setTime(date);
        return SQLDate.computeEncodedDate(calendar);
    }

    private static int computeEncodedTime(java.util.Date date, Calendar calendar) throws StandardException {
        calendar.setTime(date);
        return SQLTime.computeEncodedTime(calendar);
    }

    @Override
    public void setInto(PreparedStatement preparedStatement, int n) throws SQLException, StandardException {
        preparedStatement.setTimestamp(n, this.getTimestamp(null));
    }

    public static DateTimeDataValue computeTimestampFunction(DataValueDescriptor dataValueDescriptor, DataValueFactory dataValueFactory) throws StandardException {
        try {
            if (dataValueDescriptor.isNull()) {
                return new SQLTimestamp();
            }
            if (dataValueDescriptor instanceof SQLTimestamp) {
                return (SQLTimestamp)dataValueDescriptor.cloneValue(false);
            }
            String string = dataValueDescriptor.getString();
            if (string.length() == 14) {
                int n = SQLTimestamp.parseDateTimeInteger(string, 0, 4);
                int n2 = SQLTimestamp.parseDateTimeInteger(string, 4, 2);
                int n3 = SQLTimestamp.parseDateTimeInteger(string, 6, 2);
                int n4 = SQLTimestamp.parseDateTimeInteger(string, 8, 2);
                int n5 = SQLTimestamp.parseDateTimeInteger(string, 10, 2);
                int n6 = SQLTimestamp.parseDateTimeInteger(string, 12, 2);
                return new SQLTimestamp(SQLDate.computeEncodedDate(n, n2, n3), SQLTime.computeEncodedTime(n4, n5, n6), 0);
            }
            return dataValueFactory.getTimestampValue(string, false);
        }
        catch (StandardException standardException) {
            if ("22007.S.181".startsWith(standardException.getSQLState())) {
                throw StandardException.newException("22008.S", dataValueDescriptor.getString(), "timestamp");
            }
            throw standardException;
        }
    }

    static int parseDateTimeInteger(String string, int n, int n2) throws StandardException {
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) {
                throw StandardException.newException("22007.S.181", new Object[0]);
            }
            n4 = 10 * n4 + Character.digit(c, 10);
        }
        return n4;
    }

    @Override
    public DateTimeDataValue timestampAdd(int n, NumberDataValue numberDataValue, Date date, DateTimeDataValue dateTimeDataValue) throws StandardException {
        if (dateTimeDataValue == null) {
            dateTimeDataValue = new SQLTimestamp();
        }
        SQLTimestamp sQLTimestamp = (SQLTimestamp)dateTimeDataValue;
        if (this.isNull() || numberDataValue.isNull()) {
            sQLTimestamp.restoreToNull();
            return dateTimeDataValue;
        }
        sQLTimestamp.setFrom(this);
        int n2 = numberDataValue.getInt();
        switch (n) {
            case 0: {
                long l = this.nanos + n2;
                if (l >= 0L && l < 1000000000L) {
                    sQLTimestamp.nanos = (int)l;
                    break;
                }
                int n3 = (int)(l / 1000000000L);
                sQLTimestamp.nanos = l >= 0L ? (int)(l % 1000000000L) : (int)(l -= (long)(--n3) * 1000000000L);
                this.addInternal(13, n3, sQLTimestamp);
                break;
            }
            case 1: {
                this.addInternal(13, n2, sQLTimestamp);
                break;
            }
            case 2: {
                this.addInternal(12, n2, sQLTimestamp);
                break;
            }
            case 3: {
                this.addInternal(10, n2, sQLTimestamp);
                break;
            }
            case 4: {
                this.addInternal(5, n2, sQLTimestamp);
                break;
            }
            case 5: {
                this.addInternal(5, n2 * 7, sQLTimestamp);
                break;
            }
            case 6: {
                this.addInternal(2, n2, sQLTimestamp);
                break;
            }
            case 7: {
                this.addInternal(2, n2 * 3, sQLTimestamp);
                break;
            }
            case 8: {
                this.addInternal(1, n2, sQLTimestamp);
                break;
            }
            default: {
                throw StandardException.newException("22008.S", ReuseFactory.getInteger(n), "TIMESTAMPADD");
            }
        }
        return sQLTimestamp;
    }

    private void addInternal(int n, int n2, SQLTimestamp sQLTimestamp) throws StandardException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.setCalendar(gregorianCalendar);
        try {
            ((Calendar)gregorianCalendar).add(n, n2);
            sQLTimestamp.encodedTime = SQLTime.computeEncodedTime(gregorianCalendar);
            sQLTimestamp.encodedDate = SQLDate.computeEncodedDate(gregorianCalendar);
        }
        catch (StandardException standardException) {
            String string = standardException.getSQLState();
            if (string != null && string.length() > 0 && "22007.S.180".startsWith(string)) {
                throw StandardException.newException("22003", "TIMESTAMP");
            }
            throw standardException;
        }
    }

    @Override
    public NumberDataValue timestampDiff(int n, DateTimeDataValue dateTimeDataValue, Date date, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLLongint();
        }
        if (this.isNull() || dateTimeDataValue.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        SQLTimestamp sQLTimestamp = SQLTimestamp.promote(dateTimeDataValue, date);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        this.setCalendar(gregorianCalendar);
        long l = gregorianCalendar.getTime().getTime() / 1000L;
        sQLTimestamp.setCalendar(gregorianCalendar);
        long l2 = gregorianCalendar.getTime().getTime() / 1000L;
        long l3 = l - l2;
        int n2 = this.nanos - sQLTimestamp.nanos;
        if (n2 < 0 && l3 > 0L) {
            --l3;
            n2 += 1000000000;
        } else if (n2 > 0 && l3 < 0L) {
            ++l3;
            n2 -= 1000000000;
        }
        long l4 = 0L;
        switch (n) {
            case 0: {
                l4 = l3 * 1000000000L + (long)n2;
                break;
            }
            case 1: {
                l4 = l3;
                break;
            }
            case 2: {
                l4 = l3 / 60L;
                break;
            }
            case 3: {
                l4 = l3 / 3600L;
                break;
            }
            case 4: {
                l4 = l3 / 86400L;
                break;
            }
            case 5: {
                l4 = l3 / 604800L;
                break;
            }
            case 6: 
            case 7: {
                l4 = Math.abs(l3) > 31622400L ? 12L * (l3 / 31622400L) : l3 / 2678400L;
                if (l3 >= 0L) {
                    if (l4 >= Integer.MAX_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)gregorianCalendar).add(2, (int)(l4 + 1L));
                    while (gregorianCalendar.getTime().getTime() / 1000L <= l) {
                        ((Calendar)gregorianCalendar).add(2, 1);
                        ++l4;
                    }
                } else {
                    if (l4 <= Integer.MIN_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)gregorianCalendar).add(2, (int)(l4 - 1L));
                    while (gregorianCalendar.getTime().getTime() / 1000L >= l) {
                        ((Calendar)gregorianCalendar).add(2, -1);
                        --l4;
                    }
                }
                if (n != 7) break;
                l4 /= 3L;
                break;
            }
            case 8: {
                l4 = l3 / 31622400L;
                if (l3 >= 0L) {
                    if (l4 >= Integer.MAX_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)gregorianCalendar).add(1, (int)(l4 + 1L));
                    while (gregorianCalendar.getTime().getTime() / 1000L <= l) {
                        ((Calendar)gregorianCalendar).add(1, 1);
                        ++l4;
                    }
                } else {
                    if (l4 <= Integer.MIN_VALUE) {
                        throw StandardException.newException("22003", "INTEGER");
                    }
                    ((Calendar)gregorianCalendar).add(1, (int)(l4 - 1L));
                    while (gregorianCalendar.getTime().getTime() / 1000L >= l) {
                        ((Calendar)gregorianCalendar).add(1, -1);
                        --l4;
                    }
                }
                break;
            }
            default: {
                throw StandardException.newException("22008.S", ReuseFactory.getInteger(n), "TIMESTAMPDIFF");
            }
        }
        numberDataValue.setValue(l4);
        return numberDataValue;
    }

    static SQLTimestamp promote(DateTimeDataValue dateTimeDataValue, Date date) throws StandardException {
        if (dateTimeDataValue instanceof SQLTimestamp) {
            return (SQLTimestamp)dateTimeDataValue;
        }
        if (dateTimeDataValue instanceof SQLTime) {
            return new SQLTimestamp(SQLDate.computeEncodedDate(date, null), ((SQLTime)dateTimeDataValue).getEncodedTime(), 0);
        }
        if (dateTimeDataValue instanceof SQLDate) {
            return new SQLTimestamp(((SQLDate)dateTimeDataValue).getEncodedDate(), 0, 0);
        }
        return new SQLTimestamp(dateTimeDataValue.getTimestamp(new GregorianCalendar()));
    }
}

