/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientStatement;
import org.apache.derby.client.am.ClientTypes;
import org.apache.derby.client.am.CrossConverters;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.jdbc.ClientDriver;

public abstract class Agent {
    SqlException accumulatedReadExceptions_ = null;
    private boolean enableBatchedExceptionTracking_;
    private int batchedExceptionLabelIndex_;
    private boolean[] batchedExceptionGenerated_;
    ClientConnection connection_;
    SectionManager sectionManager_ = null;
    public LogWriter logWriter_ = null;
    final CrossConverters crossConverters_;
    private SqlException deferredException_;

    void checkForDeferredExceptions() throws SqlException {
        if (this.deferredException_ != null) {
            SqlException sqlException = this.deferredException_;
            this.deferredException_ = null;
            throw sqlException;
        }
    }

    void checkForSupportedDataType(int n) throws SqlException {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case 0: 
            case 70: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2009: 
            case 2011: 
            case 2012: {
                throw new SqlException(this.logWriter_, new ClientMessageId("0A000.S.7"), ClientTypes.getTypeString(n));
            }
        }
    }

    void accumulateDeferredException(SqlException sqlException) {
        if (this.deferredException_ == null) {
            this.deferredException_ = sqlException;
        } else {
            this.deferredException_.setNextException(sqlException);
        }
    }

    protected Agent(ClientConnection clientConnection, LogWriter logWriter) {
        this.connection_ = clientConnection;
        this.logWriter_ = logWriter;
        this.crossConverters_ = new CrossConverters(this);
    }

    private void resetAgent(LogWriter logWriter) {
        this.accumulatedReadExceptions_ = null;
        this.enableBatchedExceptionTracking_ = false;
        this.batchedExceptionLabelIndex_ = 0;
        this.batchedExceptionGenerated_ = null;
        this.logWriter_ = logWriter;
        this.deferredException_ = null;
    }

    void resetAgent(ClientConnection clientConnection, LogWriter logWriter, int n, String string, int n2) throws SqlException {
        this.resetAgent(logWriter);
        this.resetAgent_(logWriter, n, string, n2);
    }

    protected abstract void resetAgent_(LogWriter var1, int var2, String var3, int var4) throws SqlException;

    public final boolean loggingEnabled() {
        return this.logWriter_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLogWriter(LogWriter logWriter) {
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            if (this.logWriter_ != null) {
                this.logWriter_.close();
            }
            this.logWriter_ = logWriter;
        }
    }

    public final PrintWriter getLogWriter() {
        return this.logWriter_ == null ? null : this.logWriter_.printWriter_;
    }

    public final void accumulateReadException(SqlException sqlException) {
        if (this.enableBatchedExceptionTracking_) {
            this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_] = true;
            this.labelAsBatchedException(sqlException, this.batchedExceptionLabelIndex_);
        }
        if (this.accumulatedReadExceptions_ == null) {
            this.accumulatedReadExceptions_ = sqlException;
        } else {
            this.accumulatedReadExceptions_.setNextException(sqlException);
        }
    }

    private void accumulateDisconnectException(DisconnectException disconnectException) {
        if (this.enableBatchedExceptionTracking_) {
            this.batchedExceptionGenerated_[this.batchedExceptionLabelIndex_] = true;
            this.labelAsBatchedException(disconnectException, this.batchedExceptionLabelIndex_);
        }
        if (this.accumulatedReadExceptions_ != null) {
            disconnectException.setNextException(this.accumulatedReadExceptions_);
        }
        this.accumulatedReadExceptions_ = null;
    }

    public final void accumulateChainBreakingReadExceptionAndThrow(DisconnectException disconnectException) throws DisconnectException {
        this.accumulateDisconnectException(disconnectException);
        this.markChainBreakingException_();
        throw disconnectException;
    }

    protected abstract void markChainBreakingException_();

    public abstract void checkForChainBreakingException_() throws SqlException;

    private final void enableBatchedExceptionTracking(int n) {
        this.enableBatchedExceptionTracking_ = true;
        this.batchedExceptionGenerated_ = new boolean[n];
        this.batchedExceptionLabelIndex_ = 0;
    }

    final void disableBatchedExceptionTracking() {
        this.enableBatchedExceptionTracking_ = false;
    }

    public final void setBatchedExceptionLabelIndex(int n) {
        this.batchedExceptionLabelIndex_ = n;
    }

    private final SqlException labelAsBatchedException(SqlException sqlException, int n) {
        SqlException sqlException2 = sqlException;
        while (sqlException != null) {
            sqlException.setBatchPositionLabel(n);
            sqlException = sqlException.getNextException();
        }
        return sqlException2;
    }

    protected final void checkForExceptions() throws SqlException {
        if (this.accumulatedReadExceptions_ != null) {
            SqlException sqlException = this.accumulatedReadExceptions_;
            this.accumulatedReadExceptions_ = null;
            throw sqlException;
        }
    }

    public final void flow(ClientStatement clientStatement) throws SqlException {
        this.endWriteChain();
        this.flush_();
        this.beginReadChain(clientStatement);
    }

    final void flowBatch(ClientStatement clientStatement, int n) throws SqlException {
        this.endBatchedWriteChain();
        this.flush_();
        this.beginBatchedReadChain(clientStatement, n);
    }

    public final void flowOutsideUOW() throws SqlException {
        this.endWriteChain();
        this.flush_();
        this.beginReadChainOutsideUOW();
    }

    public abstract void flush_() throws DisconnectException;

    public abstract void close_() throws SqlException;

    public void close() throws SqlException {
        this.close_();
        if (this.logWriter_ != null) {
            this.logWriter_.close();
        }
    }

    final void disconnectEvent() {
        try {
            this.close();
        }
        catch (SqlException sqlException) {
            // empty catch block
        }
        this.connection_.completeChainBreakingDisconnect();
    }

    public abstract void beginWriteChainOutsideUOW() throws SqlException;

    public void beginWriteChain(ClientStatement clientStatement) throws SqlException {
        this.connection_.writeTransactionStart(clientStatement);
    }

    final void beginBatchedWriteChain(ClientStatement clientStatement) throws SqlException {
        this.beginWriteChain(clientStatement);
    }

    protected abstract void endWriteChain();

    private final void endBatchedWriteChain() {
        this.endWriteChain();
    }

    protected void beginReadChain(ClientStatement clientStatement) throws SqlException {
        this.connection_.readTransactionStart();
    }

    private void beginBatchedReadChain(ClientStatement clientStatement, int n) throws SqlException {
        this.enableBatchedExceptionTracking(n);
        this.beginReadChain(clientStatement);
    }

    protected void beginReadChainOutsideUOW() throws SqlException {
    }

    public void endReadChain() throws SqlException {
        this.checkForExceptions();
    }

    final void endBatchedReadChain(long[] lArray, SqlException sqlException) throws BatchUpdateException {
        this.disableBatchedExceptionTracking();
        for (int i = 0; i < this.batchedExceptionGenerated_.length; ++i) {
            if (!this.batchedExceptionGenerated_[i]) continue;
            lArray[i] = -3L;
        }
        if (sqlException == null) {
            try {
                this.endReadChain();
            }
            catch (SqlException sqlException2) {
                sqlException = sqlException2;
            }
        }
        if (sqlException != null) {
            throw ClientDriver.getFactory().newBatchUpdateException(this.logWriter_, new ClientMessageId("XJ208.S"), null, lArray, sqlException);
        }
    }
}

