/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.internal.db.DBAdapterDescriptor;
import org.eclipse.net4j.util.registry.HashMapRegistry;

public class DBAdapterRegistry
extends HashMapRegistry<String, IDBAdapter> {
    public static final DBAdapterRegistry INSTANCE = new DBAdapterRegistry();
    private Map<String, DBAdapterDescriptor> descriptors = new HashMap<String, DBAdapterDescriptor>();

    public DBAdapterRegistry() {
    }

    public DBAdapterRegistry(int initialCapacity) {
        super(initialCapacity);
    }

    public DBAdapterRegistry(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public DBAdapterRegistry(Map<? extends String, ? extends IDBAdapter> m) {
        super(m);
    }

    public IDBAdapter get(Object key) {
        DBAdapterDescriptor descriptor;
        IDBAdapter adapter = (IDBAdapter)super.get(key);
        if (adapter == null && key instanceof String && (descriptor = this.descriptors.get(key)) != null && (adapter = descriptor.createDBAdapter()) != null) {
            this.put((String)key, adapter);
        }
        return adapter;
    }

    public DBAdapterDescriptor addDescriptor(DBAdapterDescriptor descriptor) {
        return this.descriptors.put(descriptor.getName(), descriptor);
    }

    public DBAdapterDescriptor removeDescriptor(String name) {
        return this.descriptors.remove(name);
    }
}

