/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.internal.util.om.InternalOMJob;
import org.eclipse.net4j.internal.util.om.OSGiBundle;
import org.eclipse.net4j.util.om.OMBundle;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OSGiPlatform
extends AbstractPlatform {
    private final Map<InternalOMJob, Job> eclipseJobs = Collections.synchronizedMap(new HashMap());
    BundleContext systemContext;

    public OSGiPlatform(Object systemContext) {
        this.systemContext = (BundleContext)systemContext;
        try {
            this.setDebugging(Platform.inDebugMode());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public boolean isOSGiRunning() {
        return true;
    }

    @Override
    public String getProperty(String key) {
        return this.systemContext != null ? this.systemContext.getProperty(key) : null;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = this.getProperty(key);
        return property != null ? property : defaultValue;
    }

    @Override
    public String[] getCommandLineArgs() {
        return Platform.getCommandLineArgs();
    }

    public void setCommandLineArgs(String[] args) {
        throw new UnsupportedOperationException("Set command line arguements inside the OSGi enviorment is not needed.");
    }

    @Override
    public void scheduleJob(final InternalOMJob job) {
        Job eclipseJob = new Job(job.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus iStatus = job.run(monitor);
                    return iStatus;
                }
                finally {
                    OSGiPlatform.this.eclipseJobs.remove(job);
                }
            }
        };
        this.eclipseJobs.put(job, eclipseJob);
        eclipseJob.setSystem(job.isSystem());
        eclipseJob.schedule();
    }

    @Override
    public void cancelJob(InternalOMJob job) {
        Job eclipseJob = this.eclipseJobs.get(job);
        if (eclipseJob != null) {
            eclipseJob.cancel();
        }
    }

    @Override
    public void renameJob(InternalOMJob job, String name) {
        Job eclipseJob = this.eclipseJobs.get(job);
        if (eclipseJob != null) {
            eclipseJob.setName(name);
        }
    }

    @Override
    protected OMBundle createBundle(String bundleID, Class<?> accessor) {
        return new OSGiBundle(this, bundleID, accessor);
    }

    @Override
    protected String getDebugOption(String bundleID, String option) {
        try {
            DebugOptions debugOptions = this.getDebugOptions();
            return debugOptions.getOption(String.valueOf(bundleID) + "/" + option);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    protected void setDebugOption(String bundleID, String option, String value, boolean ifAbsent) {
        try {
            DebugOptions debugOptions = this.getDebugOptions();
            option = String.valueOf(bundleID) + "/" + option;
            if (ifAbsent && debugOptions.getOption(option) != null) {
                return;
            }
            debugOptions.setOption(option, value);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    protected DebugOptions getDebugOptions() throws NoClassDefFoundError, NullPointerException {
        ServiceReference ref = this.systemContext.getServiceReference(DebugOptions.class.getName());
        return (DebugOptions)this.systemContext.getService(ref);
    }
}

