/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.text.Collator;
import java.util.Locale;
import org.h2.util.StringUtils;
import org.h2.value.CompareModeDefault;
import org.h2.value.CompareModeIcu4J;

public class CompareMode {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    private static CompareMode lastUsed;
    private static boolean canUseICU4J;
    private final String name;
    private final int strength;

    protected CompareMode(String string, int n) {
        this.name = string;
        this.strength = n;
    }

    public static synchronized CompareMode getInstance(String string, int n) {
        if (lastUsed != null && StringUtils.equals(CompareMode.lastUsed.name, string) && CompareMode.lastUsed.strength == n) {
            return lastUsed;
        }
        if (string == null || string.equals(OFF)) {
            lastUsed = new CompareMode(string, n);
        } else {
            boolean bl;
            if (string.startsWith(ICU4J)) {
                bl = true;
                string = string.substring(ICU4J.length());
            } else if (string.startsWith(DEFAULT)) {
                bl = false;
                string = string.substring(DEFAULT.length());
            } else {
                bl = canUseICU4J;
            }
            lastUsed = bl ? new CompareModeIcu4J(string, n) : new CompareModeDefault(string, n);
        }
        return lastUsed;
    }

    public boolean equalsChars(String string, int n, String string2, int n2, boolean bl) {
        char c = string.charAt(n);
        char c2 = string2.charAt(n2);
        if (bl) {
            c = Character.toUpperCase(c);
            c2 = Character.toUpperCase(c2);
        }
        return c == c2;
    }

    public int compareString(String string, String string2, boolean bl) {
        if (bl) {
            return string.compareToIgnoreCase(string2);
        }
        return string.compareTo(string2);
    }

    public static String getName(Locale locale) {
        Locale locale2 = Locale.ENGLISH;
        String string = locale.getDisplayLanguage(locale2) + ' ' + locale.getDisplayCountry(locale2) + ' ' + locale.getVariant();
        string = StringUtils.toUpperEnglish(string.trim().replace(' ', '_'));
        return string;
    }

    static boolean compareLocaleNames(Locale locale, String string) {
        return string.equalsIgnoreCase(locale.toString()) || string.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String string) {
        String string2;
        String string3;
        Locale locale2;
        int n;
        Collator collator = null;
        if (string.startsWith(ICU4J)) {
            string = string.substring(ICU4J.length());
        } else if (string.startsWith(DEFAULT)) {
            string = string.substring(DEFAULT.length());
        }
        if (string.length() == 2) {
            Locale[] localeArray = new Locale(StringUtils.toLowerEnglish(string), "");
            if (CompareMode.compareLocaleNames((Locale)localeArray, string)) {
                collator = Collator.getInstance((Locale)localeArray);
            }
        } else if (string.length() == 5 && (n = string.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale2 = new Locale(string3 = StringUtils.toLowerEnglish(string.substring(0, n)), string2 = string.substring(n + 1)), string)) {
            collator = Collator.getInstance(locale2);
        }
        if (collator == null) {
            for (Locale locale2 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale2, string)) continue;
                collator = Collator.getInstance(locale2);
                break;
            }
        }
        return collator;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    static {
        try {
            Class.forName("com.ibm.icu.text.Collator");
            canUseICU4J = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

