/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FilePathRec;

class FileRec
extends FileBase {
    private final FilePathRec rec;
    private final FileChannel channel;
    private final String name;

    FileRec(FilePathRec filePathRec, FileChannel fileChannel, String string) {
        this.rec = filePathRec;
        this.channel = fileChannel;
        this.name = string;
    }

    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    public long position() throws IOException {
        return this.channel.position();
    }

    public long size() throws IOException {
        return this.channel.size();
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.channel.read(byteBuffer);
    }

    public FileChannel position(long l) throws IOException {
        this.channel.position(l);
        return this;
    }

    public FileChannel truncate(long l) throws IOException {
        this.rec.log(7, this.name, null, l);
        this.channel.truncate(l);
        return this;
    }

    public void force(boolean bl) throws IOException {
        this.channel.force(bl);
    }

    public int write(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.remaining();
        if (byteBuffer.position() != 0 || n != byArray.length) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, byteBuffer.position(), byArray2, 0, n);
            byArray = byArray2;
        }
        int n2 = this.channel.write(byteBuffer);
        this.rec.log(8, this.name, byArray, this.channel.position());
        return n2;
    }

    public synchronized FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return this.channel.tryLock();
    }
}

