/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.selector;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.List;

public final class CompositeServerSelector
implements ServerSelector {
    private final List<ServerSelector> serverSelectors;

    public CompositeServerSelector(List<? extends ServerSelector> serverSelectors) {
        Assertions.notNull("serverSelectors", serverSelectors);
        if (serverSelectors.isEmpty()) {
            throw new IllegalArgumentException("Server selectors can not be an empty list");
        }
        for (ServerSelector serverSelector : serverSelectors) {
            if (serverSelector != null) continue;
            throw new IllegalArgumentException("Can not have a null server selector in the list of composed selectors");
        }
        this.serverSelectors = new ArrayList<ServerSelector>();
        for (ServerSelector serverSelector : serverSelectors) {
            if (serverSelector instanceof CompositeServerSelector) {
                this.serverSelectors.addAll(((CompositeServerSelector)serverSelector).serverSelectors);
                continue;
            }
            this.serverSelectors.add(serverSelector);
        }
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        ClusterDescription curClusterDescription = clusterDescription;
        List<ServerDescription> choices = null;
        for (ServerSelector cur : this.serverSelectors) {
            choices = cur.select(curClusterDescription);
            curClusterDescription = new ClusterDescription(clusterDescription.getConnectionMode(), clusterDescription.getType(), choices);
        }
        return choices;
    }

    public String toString() {
        return "{serverSelectors=" + this.serverSelectors + '}';
    }
}

