/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db.offline;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.tests.db.offline.DBOfflineConfig;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.mysql.MYSQLAdapter;

public class MysqlOfflineConfig
extends DBOfflineConfig {
    private static final long serialVersionUID = 1L;
    public static final String HOST = "10.211.55.7:3306";
    public static final String USER = "root";
    public static final String PASS = null;
    private transient DataSource setupDataSource;
    private transient List<String> databases = new ArrayList<String>();

    public MysqlOfflineConfig() {
        super("MySqlOffline");
    }

    @Override
    public void initCapabilities(Set<String> capabilities) {
        super.initCapabilities(capabilities);
        capabilities.add("Mysql");
    }

    @Override
    protected IDBAdapter createDBAdapter() {
        return new MYSQLAdapter();
    }

    @Override
    protected DataSource createDataSource(String repoName) {
        MysqlDataSource ds = new MysqlDataSource();
        this.initDatabase("test_" + repoName);
        ds.setUrl("jdbc:mysql://10.211.55.7:3306/test_" + repoName);
        ds.setUser(USER);
        if (PASS != null) {
            ds.setPassword(PASS);
        }
        return ds;
    }

    private void initDatabase(String dbName) {
        block5: {
            this.dropDatabase(dbName);
            Connection connection = null;
            Statement stmt = null;
            try {
                try {
                    connection = this.getSetupDataSource().getConnection();
                    stmt = connection.createStatement();
                    stmt.execute("create database " + dbName);
                }
                catch (SQLException sQLException) {
                    DBUtil.close(stmt);
                    DBUtil.close((Connection)connection);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
            DBUtil.close((Statement)stmt);
            DBUtil.close((Connection)connection);
        }
    }

    private void dropDatabase(String dbName) {
        block5: {
            Connection connection = null;
            Statement stmt = null;
            try {
                try {
                    connection = this.getSetupDataSource().getConnection();
                    stmt = connection.createStatement();
                    stmt.execute("DROP database " + dbName);
                }
                catch (SQLException sQLException) {
                    DBUtil.close(stmt);
                    DBUtil.close((Connection)connection);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(stmt);
                DBUtil.close((Connection)connection);
                throw throwable;
            }
            DBUtil.close((Statement)stmt);
            DBUtil.close((Connection)connection);
        }
    }

    private DataSource getSetupDataSource() {
        if (this.setupDataSource == null) {
            MysqlDataSource ds = new MysqlDataSource();
            ds.setUrl("jdbc:mysql://10.211.55.7:3306/");
            ds.setUser(USER);
            if (PASS != null) {
                ds.setPassword(PASS);
            }
            this.setupDataSource = ds;
        }
        return this.setupDataSource;
    }

    protected void tearDownClean(String repoName) {
        for (String dbName : this.databases) {
            this.dropDatabase(dbName);
        }
    }
}

