/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetTimingsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealBasicNoPutResultSetStatistics;

abstract class RealNoRowsResultSetStatistics
implements ResultSetStatistics {
    protected String indent;
    protected String subIndent;
    protected int sourceDepth;
    public ResultSetStatistics sourceResultSetStatistics;
    public long executeTime;
    public long inspectOverall;
    public long inspectNum;
    public String inspectDesc;

    public RealNoRowsResultSetStatistics(long l, ResultSetStatistics resultSetStatistics) {
        if (resultSetStatistics instanceof RealBasicNoPutResultSetStatistics) {
            this.executeTime = l - ((RealBasicNoPutResultSetStatistics)resultSetStatistics).getTotalTime();
        }
    }

    protected void initFormatInfo(int n) {
        char[] cArray = new char[n];
        char[] cArray2 = new char[n + 1];
        this.sourceDepth = n + 1;
        cArray2[n] = 9;
        while (n > 0) {
            cArray2[n - 1] = 9;
            cArray[n - 1] = 9;
            --n;
        }
        this.indent = new String(cArray);
        this.subIndent = new String(cArray2);
    }

    protected String dumpTimeStats(String string) {
        return string + MessageService.getTextMessage("43Y29.U", new Object[0]) + " = " + this.executeTime + "\n";
    }

    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.sourceResultSetStatistics);
        return vector;
    }

    public abstract String getNodeName();

    @Override
    public double getEstimatedRowCount() {
        return 0.0;
    }

    @Override
    public String getRSXplainDetails() {
        return null;
    }

    @Override
    public Object getResultSetDescriptor(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return new XPLAINResultSetDescriptor((UUID)object, this.getRSXplainType(), this.getRSXplainDetails(), null, null, null, null, (UUID)object2, null, null, null, null, null, null, null, null, null, null, null, (UUID)object3, (UUID)object4, (UUID)object5, (UUID)object6);
    }

    @Override
    public Object getResultSetTimingsDescriptor(Object object) {
        return new XPLAINResultSetTimingsDescriptor((UUID)object, null, null, null, null, new Long(this.executeTime), null, null, null, null, null);
    }

    @Override
    public Object getSortPropsDescriptor(Object object) {
        return null;
    }

    @Override
    public Object getScanPropsDescriptor(Object object) {
        return null;
    }
}

