/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasCorrelatedCRsVisitor;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ProjectRestrictNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

abstract class FromTable
extends ResultSetNode
implements Optimizable {
    Properties tableProperties;
    String correlationName;
    TableName corrTableName;
    int tableNumber;
    int level;
    int[] hashKeyColumns;
    int initialCapacity = -1;
    float loadFactor = -1.0f;
    int maxCapacity = -1;
    AccessPathImpl currentAccessPath;
    AccessPathImpl bestAccessPath;
    AccessPathImpl bestSortAvoidancePath;
    AccessPathImpl trulyTheBestAccessPath;
    private int joinStrategyNumber;
    protected String userSpecifiedJoinStrategy;
    protected CostEstimate bestCostEstimate;
    private double perRowUsage = -1.0;
    private boolean considerSortAvoidancePath;
    private HashMap<Object, AccessPathImpl> bestPlanMap;
    protected static final short REMOVE_PLAN = 0;
    protected static final short ADD_PLAN = 1;
    protected static final short LOAD_PLAN = 2;
    protected TableName origTableName;
    private int _mergeTableID = 0;

    FromTable(String string, Properties properties, ContextManager contextManager) {
        super(contextManager);
        this.correlationName = string;
        this.tableProperties = properties;
        this.tableNumber = -1;
        this.bestPlanMap = null;
    }

    public String getCorrelationName() {
        return this.correlationName;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, CostEstimate costEstimate, RowOrdering rowOrdering) throws StandardException {
        this.updateBestPlanMap((short)1, this);
        CostEstimate costEstimate2 = this.estimateCost(optimizablePredicateList, null, costEstimate, optimizer, rowOrdering);
        this.getCostEstimate(optimizer);
        this.setCostEstimateCost(costEstimate2);
        this.optimizeSubqueries(this.getDataDictionary(), this.getCostEstimate().rowCount());
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, optimizablePredicateList, null, costEstimate, optimizer, this.getCostEstimate());
        optimizer.considerCost(this, optimizablePredicateList, this.getCostEstimate(), costEstimate);
        return this.getCostEstimate();
    }

    @Override
    public boolean nextAccessPath(Optimizer optimizer, OptimizablePredicateList optimizablePredicateList, RowOrdering rowOrdering) throws StandardException {
        int n = optimizer.getNumberOfJoinStrategies();
        boolean bl = false;
        AccessPath accessPath = this.getCurrentAccessPath();
        if (this.userSpecifiedJoinStrategy != null) {
            if (accessPath.getJoinStrategy() != null) {
                accessPath.setJoinStrategy(null);
                bl = false;
            } else {
                accessPath.setJoinStrategy(optimizer.getJoinStrategy(this.userSpecifiedJoinStrategy));
                if (accessPath.getJoinStrategy() == null) {
                    throw StandardException.newException("42Y56", this.userSpecifiedJoinStrategy, this.getBaseTableName());
                }
                bl = true;
            }
        } else if (this.joinStrategyNumber < n) {
            accessPath.setJoinStrategy(optimizer.getJoinStrategy(this.joinStrategyNumber));
            ++this.joinStrategyNumber;
            bl = true;
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceConsideringJoinStrategy(accessPath.getJoinStrategy(), this.tableNumber);
            }
        }
        this.tellRowOrderingAboutConstantColumns(rowOrdering, optimizablePredicateList);
        return bl;
    }

    protected boolean canBeOrdered() {
        return false;
    }

    @Override
    public AccessPath getCurrentAccessPath() {
        return this.currentAccessPath;
    }

    @Override
    public AccessPath getBestAccessPath() {
        return this.bestAccessPath;
    }

    @Override
    public AccessPath getBestSortAvoidancePath() {
        return this.bestSortAvoidancePath;
    }

    @Override
    public AccessPath getTrulyTheBestAccessPath() {
        return this.trulyTheBestAccessPath;
    }

    @Override
    public void rememberSortAvoidancePath() {
        this.considerSortAvoidancePath = true;
    }

    @Override
    public boolean considerSortAvoidancePath() {
        return this.considerSortAvoidancePath;
    }

    @Override
    public void rememberJoinStrategyAsBest(AccessPath accessPath) {
        Optimizer optimizer = accessPath.getOptimizer();
        accessPath.setJoinStrategy(this.getCurrentAccessPath().getJoinStrategy());
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceRememberingJoinStrategy(this.getCurrentAccessPath().getJoinStrategy(), this.tableNumber);
        }
        if (accessPath == this.bestAccessPath) {
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceRememberingBestAccessPathSubstring(accessPath, this.tableNumber);
            }
        } else if (accessPath == this.bestSortAvoidancePath) {
            if (this.optimizerTracingIsOn()) {
                this.getOptimizerTracer().traceRememberingBestSortAvoidanceAccessPathSubstring(accessPath, this.tableNumber);
            }
        } else if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceRememberingBestUnknownAccessPathSubstring(accessPath, this.tableNumber);
        }
    }

    @Override
    public TableDescriptor getTableDescriptor() {
        return null;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return false;
    }

    @Override
    public void pullOptPredicates(OptimizablePredicateList optimizablePredicateList) throws StandardException {
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet jBitSet) throws StandardException {
        return this;
    }

    @Override
    public boolean isCoveringIndex(ConglomerateDescriptor conglomerateDescriptor) throws StandardException {
        return false;
    }

    @Override
    public Properties getProperties() {
        return this.tableProperties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.tableProperties = properties;
    }

    @Override
    public void verifyProperties(DataDictionary dataDictionary) throws StandardException {
        if (this.tableProperties == null) {
            return;
        }
        Enumeration<Object> enumeration = this.tableProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.tableProperties.get(string);
            if (string.equals("joinStrategy")) {
                this.userSpecifiedJoinStrategy = StringUtil.SQLToUpperCase(string2);
                continue;
            }
            if (string.equals("hashInitialCapacity")) {
                this.initialCapacity = this.getIntProperty(string2, string);
                if (this.initialCapacity > 0) continue;
                throw StandardException.newException("42Y59", String.valueOf(this.initialCapacity));
            }
            if (string.equals("hashLoadFactor")) {
                try {
                    this.loadFactor = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw StandardException.newException("42Y58", string2, string);
                }
                if (!((double)this.loadFactor <= 0.0) && !((double)this.loadFactor > 1.0)) continue;
                throw StandardException.newException("42Y60", string2);
            }
            if (string.equals("hashMaxCapacity")) {
                this.maxCapacity = this.getIntProperty(string2, string);
                if (this.maxCapacity > 0) continue;
                throw StandardException.newException("42Y61", String.valueOf(this.maxCapacity));
            }
            throw StandardException.newException("42Y44", string, "joinStrategy");
        }
    }

    @Override
    public String getName() throws StandardException {
        return this.getExposedName();
    }

    @Override
    public String getBaseTableName() {
        return "";
    }

    @Override
    public int convertAbsoluteToRelativeColumnPosition(int n) {
        return n;
    }

    @Override
    public void updateBestPlanMap(short s, Object object) throws StandardException {
        if (s == 0) {
            if (this.bestPlanMap != null) {
                this.bestPlanMap.remove(object);
                if (this.bestPlanMap.isEmpty()) {
                    this.bestPlanMap = null;
                }
            }
            return;
        }
        AccessPath accessPath = this.getTrulyTheBestAccessPath();
        AccessPathImpl accessPathImpl = null;
        if (s == 1) {
            if (accessPath == null) {
                return;
            }
            if (this.bestPlanMap == null) {
                this.bestPlanMap = new HashMap();
            } else {
                accessPathImpl = this.bestPlanMap.get(object);
            }
            if (accessPathImpl == null) {
                accessPathImpl = object instanceof Optimizer ? new AccessPathImpl((Optimizer)object) : new AccessPathImpl(null);
            }
            accessPathImpl.copy(accessPath);
            this.bestPlanMap.put(object, accessPathImpl);
            return;
        }
        if (this.bestPlanMap == null) {
            return;
        }
        accessPathImpl = this.bestPlanMap.get(object);
        if (accessPathImpl == null || accessPathImpl.getCostEstimate() == null) {
            return;
        }
        accessPath.copy(accessPathImpl);
    }

    @Override
    public void rememberAsBest(int n, Optimizer optimizer) throws StandardException {
        Object object;
        AccessPath accessPath = null;
        switch (n) {
            case 1: {
                accessPath = this.getBestAccessPath();
                break;
            }
            case 2: {
                accessPath = this.getBestSortAvoidancePath();
                break;
            }
        }
        this.getTrulyTheBestAccessPath().copy(accessPath);
        if (!(this instanceof ProjectRestrictNode)) {
            this.updateBestPlanMap((short)1, optimizer);
        } else {
            object = (ProjectRestrictNode)this;
            if (!(((SingleChildResultSetNode)object).getChildResult() instanceof Optimizable)) {
                this.updateBestPlanMap((short)1, optimizer);
            }
        }
        if (this.isBaseTable()) {
            object = this.getDataDictionary();
            TableDescriptor tableDescriptor = this.getTableDescriptor();
            this.getTrulyTheBestAccessPath().initializeAccessPathName((DataDictionary)object, tableDescriptor);
        }
        this.setCostEstimateCost(accessPath.getCostEstimate());
        if (this.optimizerTracingIsOn()) {
            this.getOptimizerTracer().traceRememberingBestAccessPath(accessPath, this.tableNumber, n);
        }
    }

    @Override
    public void startOptimizing(Optimizer optimizer, RowOrdering rowOrdering) {
        this.resetJoinStrategies(optimizer);
        this.considerSortAvoidancePath = false;
        CostEstimate costEstimate = this.getBestAccessPath().getCostEstimate();
        if (costEstimate != null) {
            costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if ((costEstimate = this.getBestSortAvoidancePath().getCostEstimate()) != null) {
            costEstimate.setCost(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (!this.canBeOrdered()) {
            rowOrdering.addUnorderedOptimizable(this);
        }
    }

    protected void resetJoinStrategies(Optimizer optimizer) {
        this.joinStrategyNumber = 0;
        this.getCurrentAccessPath().setJoinStrategy(null);
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        return null;
    }

    @Override
    CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.getCandidateFinalCostEstimate() != null) {
            return this.getCandidateFinalCostEstimate();
        }
        if (this.getTrulyTheBestAccessPath() == null) {
            this.setCandidateFinalCostEstimate(this.getCostEstimate());
        } else {
            this.setCandidateFinalCostEstimate(this.getTrulyTheBestAccessPath().getCostEstimate());
        }
        return this.getCandidateFinalCostEstimate();
    }

    @Override
    public boolean isBaseTable() {
        return false;
    }

    @Override
    public boolean hasLargeObjectColumns() {
        for (ResultColumn resultColumn : this.getResultColumns()) {
            DataTypeDescriptor dataTypeDescriptor;
            if (!resultColumn.isReferenced() || (dataTypeDescriptor = resultColumn.getType()) == null || !dataTypeDescriptor.getTypeId().isLOBTypeId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMaterializable() throws StandardException {
        HasCorrelatedCRsVisitor hasCorrelatedCRsVisitor = new HasCorrelatedCRsVisitor();
        this.accept(hasCorrelatedCRsVisitor);
        return !hasCorrelatedCRsVisitor.hasCorrelatedCRs();
    }

    @Override
    public boolean supportsMultipleInstantiations() {
        return true;
    }

    @Override
    public int getTableNumber() {
        return this.tableNumber;
    }

    @Override
    public boolean hasTableNumber() {
        return this.tableNumber >= 0;
    }

    @Override
    public boolean forUpdate() {
        return false;
    }

    @Override
    public int initialCapacity() {
        return 0;
    }

    @Override
    public float loadFactor() {
        return 0.0f;
    }

    @Override
    public int maxCapacity(JoinStrategy joinStrategy, int n) throws StandardException {
        return joinStrategy.maxCapacity(this.maxCapacity, n, this.getPerRowUsage());
    }

    private double getPerRowUsage() throws StandardException {
        if (this.perRowUsage < 0.0) {
            FormatableBitSet formatableBitSet = this.getResultColumns().getReferencedFormatableBitSet(this.cursorTargetTable(), true, false);
            this.perRowUsage = 0.0;
            for (int i = 0; i < formatableBitSet.size(); ++i) {
                ResultColumn resultColumn;
                DataTypeDescriptor dataTypeDescriptor;
                if (!formatableBitSet.isSet(i) || (dataTypeDescriptor = (resultColumn = (ResultColumn)this.getResultColumns().elementAt(i)).getExpression().getTypeServices()) == null) continue;
                this.perRowUsage += dataTypeDescriptor.estimatedMemoryUsage();
            }
            ConglomerateDescriptor conglomerateDescriptor = this.getCurrentAccessPath().getConglomerateDescriptor();
            if (conglomerateDescriptor != null && conglomerateDescriptor.isIndex() && !this.isCoveringIndex(conglomerateDescriptor)) {
                this.perRowUsage += 12.0;
            }
        }
        return this.perRowUsage;
    }

    @Override
    public int[] hashKeyColumns() {
        return this.hashKeyColumns;
    }

    @Override
    public void setHashKeyColumns(int[] nArray) {
        this.hashKeyColumns = nArray;
    }

    @Override
    public boolean feasibleJoinStrategy(OptimizablePredicateList optimizablePredicateList, Optimizer optimizer) throws StandardException {
        return this.getCurrentAccessPath().getJoinStrategy().feasible(this, optimizablePredicateList, optimizer);
    }

    @Override
    public boolean memoryUsageOK(double d, int n) throws StandardException {
        if (this.userSpecifiedJoinStrategy != null) {
            return true;
        }
        int n2 = d > 2.147483647E9 ? Integer.MAX_VALUE : (int)d;
        return n2 <= this.maxCapacity(this.getCurrentAccessPath().getJoinStrategy(), n);
    }

    void isJoinColumnForRightOuterJoin(ResultColumn resultColumn) {
    }

    @Override
    public boolean legalJoinOrder(JBitSet jBitSet) {
        return true;
    }

    @Override
    public int getNumColumnsReturned() {
        return this.getResultColumns().size();
    }

    @Override
    public boolean isTargetTable() {
        return false;
    }

    @Override
    public boolean isOneRowScan() throws StandardException {
        return this.isOneRowResultSet();
    }

    @Override
    public void initAccessPaths(Optimizer optimizer) {
        if (this.currentAccessPath == null) {
            this.currentAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestAccessPath == null) {
            this.bestAccessPath = new AccessPathImpl(optimizer);
        }
        if (this.bestSortAvoidancePath == null) {
            this.bestSortAvoidancePath = new AccessPathImpl(optimizer);
        }
        if (this.trulyTheBestAccessPath == null) {
            this.trulyTheBestAccessPath = new AccessPathImpl(optimizer);
        }
    }

    @Override
    public double uniqueJoin(OptimizablePredicateList optimizablePredicateList) throws StandardException {
        return -1.0;
    }

    String getUserSpecifiedJoinStrategy() {
        if (this.tableProperties == null) {
            return null;
        }
        return this.tableProperties.getProperty("joinStrategy");
    }

    protected boolean cursorTargetTable() {
        return false;
    }

    protected CostEstimate getCostEstimate(Optimizer optimizer) {
        if (this.getCostEstimate() == null) {
            this.setCostEstimate(this.getOptimizerFactory().getCostEstimate());
        }
        return this.getCostEstimate();
    }

    protected CostEstimate getScratchCostEstimate(Optimizer optimizer) {
        if (this.getScratchCostEstimate() == null) {
            this.setScratchCostEstimate(this.getOptimizerFactory().getCostEstimate());
        }
        return this.getScratchCostEstimate();
    }

    protected void setCostEstimateCost(CostEstimate costEstimate) {
        this.getCostEstimate().setCost(costEstimate);
    }

    protected void assignCostEstimate(CostEstimate costEstimate) {
        this.setCostEstimate(costEstimate);
    }

    @Override
    public String toString() {
        return "";
    }

    ResultColumnList getResultColumnsForList(TableName tableName, ResultColumnList resultColumnList, TableName tableName2) throws StandardException {
        TableName tableName3 = this.correlationName == null ? tableName2 : (tableName != null ? this.makeTableName(tableName.getSchemaName(), this.correlationName) : this.makeTableName(null, this.correlationName));
        if (tableName != null && !tableName.equals(tableName3)) {
            return null;
        }
        TableName tableName4 = this.correlationName == null ? tableName2 : this.makeTableName(null, this.correlationName);
        ContextManager contextManager = this.getContextManager();
        ResultColumnList resultColumnList2 = new ResultColumnList(contextManager);
        for (ResultColumn resultColumn : resultColumnList) {
            ColumnReference columnReference = resultColumn.getReference();
            if (columnReference != null && columnReference.getMergeTableID() != 0) {
                tableName4 = columnReference.getQualifiedTableName();
            }
            ColumnReference columnReference2 = new ColumnReference(resultColumn.getName(), tableName4, contextManager);
            if (columnReference != null && columnReference.getMergeTableID() != 0) {
                columnReference2.setMergeTableID(columnReference.getMergeTableID());
            }
            ResultColumn resultColumn2 = new ResultColumn(resultColumn.getName(), (ValueNode)columnReference2, contextManager);
            resultColumnList2.addResultColumn(resultColumn2);
        }
        return resultColumnList2;
    }

    void pushExpressions(PredicateList predicateList) throws StandardException {
    }

    String getExposedName() throws StandardException {
        return null;
    }

    void setTableNumber(int n) {
        this.tableNumber = n;
    }

    TableName getTableName() throws StandardException {
        if (this.correlationName == null) {
            return null;
        }
        if (this.corrTableName == null) {
            this.corrTableName = this.makeTableName(null, this.correlationName);
        }
        return this.corrTableName;
    }

    void setLevel(int n) {
        this.level = n;
    }

    int getLevel() {
        return this.level;
    }

    @Override
    void decrementLevel(int n) {
        if (this.level > 0) {
            this.level -= n;
        }
    }

    SchemaDescriptor getSchemaDescriptor() throws StandardException {
        return this.getSchemaDescriptor(this.corrTableName);
    }

    SchemaDescriptor getSchemaDescriptor(TableName tableName) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(tableName.getSchemaName());
        return schemaDescriptor;
    }

    @Override
    FromTable getFromTableByName(String string, String string2, boolean bl) throws StandardException {
        if (string2 != null) {
            return null;
        }
        if (this.getExposedName().equals(string)) {
            return this;
        }
        return null;
    }

    boolean isFlattenableJoinNode() {
        return false;
    }

    boolean LOJ_reorderable(int n) throws StandardException {
        return false;
    }

    FromTable transformOuterJoins(ValueNode valueNode, int n) throws StandardException {
        return this;
    }

    @Override
    void fillInReferencedTableMap(JBitSet jBitSet) {
        if (this.tableNumber != -1) {
            jBitSet.set(this.tableNumber);
        }
    }

    protected void markUpdatableByCursor(List<String> list) {
        this.getResultColumns().markUpdatableByCursor(list);
    }

    FromList flatten(ResultColumnList resultColumnList, PredicateList predicateList, SubqueryList subqueryList, GroupByList groupByList, ValueNode valueNode) throws StandardException {
        return null;
    }

    void optimizeSubqueries(DataDictionary dataDictionary, double d) throws StandardException {
    }

    protected void tellRowOrderingAboutConstantColumns(RowOrdering rowOrdering, OptimizablePredicateList optimizablePredicateList) {
        if (optimizablePredicateList != null) {
            for (int i = 0; i < optimizablePredicateList.size(); ++i) {
                ColumnReference columnReference;
                Predicate predicate = (Predicate)optimizablePredicateList.getOptPredicate(i);
                if (!predicate.equalsComparisonWithConstantExpression(this) || (columnReference = predicate.getRelop().getColumnOperand(this)) == null) continue;
                rowOrdering.columnAlwaysOrdered(this, columnReference.getColumnNumber());
            }
        }
    }

    boolean needsSpecialRCLBinding() {
        return false;
    }

    void setOrigTableName(TableName tableName) {
        this.origTableName = tableName;
    }

    TableName getOrigTableName() {
        return this.origTableName;
    }

    void setMergeTableID(int n) {
        this._mergeTableID = n;
    }

    int getMergeTableID() {
        return this._mergeTableID;
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.origTableName != null) {
            this.origTableName = (TableName)this.origTableName.accept(visitor);
        }
        if (this.corrTableName != null) {
            this.corrTableName = (TableName)this.corrTableName.accept(visitor);
        }
    }
}

