/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.tests.config;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.net4j.tests.config.AbstractConfigTest;
import org.eclipse.net4j.tests.config.TestConfig;

public class Net4jTestSuite
extends TestSuite {
    private final Class<? extends TestConfig.Factory>[] configTypes;

    public Net4jTestSuite(String name, Class<? extends TestConfig.Factory> ... configTypes) {
        super(name);
        this.configTypes = configTypes;
    }

    public void addTestSuite(Class<? extends TestCase> testClass) {
        if (AbstractConfigTest.class.isAssignableFrom(testClass)) {
            Set<Class<? extends TestConfig.Factory>> excluded = Net4jTestSuite.getExcludedConfigs(testClass);
            Class<? extends TestConfig.Factory>[] classArray = this.configTypes;
            int n = this.configTypes.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    Class<? extends TestConfig.Factory> configType = classArray[n2];
                    if (!excluded.contains(configType)) {
                        TestConfig.Factory factory;
                        Constructor<? extends TestConfig.Factory> constructor;
                        try {
                            constructor = configType.getConstructor(new Class[0]);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            break block8;
                        }
                        try {
                            factory = constructor.newInstance(new Object[0]);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            break block8;
                        }
                        this.addTest((Test)new ConfigTestSuite(testClass, factory));
                    }
                }
                ++n2;
            }
        } else {
            this.addTest((Test)new TestSuite(testClass));
        }
    }

    public static Set<Class<? extends TestConfig.Factory>> getExcludedConfigs(Class<?> theClass) {
        HashSet<Class<? extends TestConfig.Factory>> result = new HashSet<Class<? extends TestConfig.Factory>>();
        ExcludedConfig[] annotations = (ExcludedConfig[])theClass.getAnnotationsByType(ExcludedConfig.class);
        if (annotations.length > 0) {
            ExcludedConfig[] excludedConfigArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends TestConfig.Factory>[] types;
                ExcludedConfig annotation = excludedConfigArray[n2];
                Class<? extends TestConfig.Factory>[] classArray = types = annotation.value();
                int n3 = types.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<? extends TestConfig.Factory> type = classArray[n4];
                    result.add(type);
                    ++n4;
                }
                ++n2;
            }
        }
        return result;
    }

    public static class ConfigTestSuite
    extends TestSuite {
        private final TestConfig.Factory configFactory;

        public ConfigTestSuite(Class<?> theClass, TestConfig.Factory configFactory) {
            super(theClass);
            this.configFactory = configFactory;
            this.setName(String.valueOf(theClass.getName()) + " [" + configFactory.getClass().getSimpleName() + "]");
        }

        public void runTest(Test test, TestResult result) {
            if (test instanceof AbstractConfigTest) {
                ((AbstractConfigTest)test).setConfig(this.configFactory.createConfig());
            }
            super.runTest(test, result);
        }
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ExcludedConfig {
        public Class<? extends TestConfig.Factory>[] value();
    }
}

