/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db.postgresql;

import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import org.eclipse.net4j.db.DBType;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.internal.postgresql.bundle.OM;
import org.eclipse.net4j.spi.db.DBAdapter;

public class PostgreSQLAdapter
extends DBAdapter {
    public static final String NAME = "postgresql";
    public static final String VERSION = "9.0";
    private static final String[] RESERVED_WORDS = new String[]{"ALL", "ANALYSE", "ANALYZE", "AND", "ANY", "AS", "ASC", "ATOMIC", "AUTHORIZATION", "BETWEEN", "BIGINT", "BINARY", "BIT", "BOOLEAN", "BOTH", "C", "CASE", "CAST", "CHAR", "CHARACTER", "CHECK", "COALESCE", "COLLATE", "COLUMN", "CONSTRAINT", "CONVERT", "CREATE", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "DEC", "DECIMAL", "DEFAULT", "DEFERRABLE", "DESC", "DISTINCT", "DO", "ELSE", "END", "EXCEPT", "EXECUTE", "EXISTS", "EXTRACT", "FALSE", "FLOAT", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "ILIKE", "IN", "INITIALLY", "INNER", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "NATURAL", "NCHAR", "NCLOB", "NEW", "NONE", "NOT", "NOTNULL", "NULL", "NULLIF", "NUMERIC", "OFF", "OFFSET", "OLD", "ON", "ONLY", "OR", "ORDER", "OUTER", "OVERLAPS", "OVERLAY", "PLACING", "POSITION", "PRIMARY", "REAL", "RECHECK", "REFERENCES", "RIGHT", "ROW", "SELECT", "SESSION_USER", "SETOF", "SIMILAR", "SMALLINT", "SOME", "SUBSTRING", "TABLE", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TREAT", "TRIM", "TRUE", "UNION", "UNIQUE", "USER", "USING", "VARCHAR", "VERBOSE", "WHEN", "WHERE"};

    public PostgreSQLAdapter() {
        super(NAME, VERSION);
    }

    protected PostgreSQLAdapter(String name, String version) {
        super(name, version);
    }

    public int getMaxTableNameLength() {
        return 63;
    }

    public int getMaxFieldNameLength() {
        return 63;
    }

    protected String getTypeName(IDBField field) {
        DBType type = field.getType();
        switch (type) {
            case BIT: {
                return "boolean";
            }
            case TINYINT: {
                return DBType.SMALLINT.toString();
            }
            case VARCHAR: 
            case LONGVARCHAR: 
            case CLOB: {
                return "text";
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: 
            case BLOB: {
                return "bytea";
            }
            case DOUBLE: {
                return "double precision";
            }
        }
        return super.getTypeName(field);
    }

    public String[] getReservedWords() {
        return RESERVED_WORDS;
    }

    public boolean isDuplicateKeyException(SQLException ex) {
        return super.isDuplicateKeyException(ex) || "23505".equals(ex.getSQLState());
    }

    public boolean isTableNotFoundException(SQLException ex) {
        return "42P01".equals(ex.getSQLState());
    }

    public boolean isColumnNotFoundException(SQLException ex) {
        return "42703".equals(ex.getSQLState());
    }

    protected void doCreateTable(IDBTable table, Statement statement) throws SQLException {
        Savepoint savepoint = statement.getConnection().setSavepoint();
        try {
            super.doCreateTable(table, statement);
        }
        catch (SQLException ex) {
            try {
                statement.getConnection().rollback(savepoint);
            }
            catch (SQLException ex1) {
                OM.LOG.error((Throwable)ex1);
            }
            throw ex;
        }
    }
}

