/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.lock;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.spi.common.lock.InternalCDOLockState;
import org.eclipse.net4j.util.concurrent.IRWLockManager;

public class CDOLockStateImpl
implements InternalCDOLockState {
    private static final Set<CDOLockOwner> NO_LOCK_OWNERS = Collections.emptySet();
    private final Object lockedObject;
    private Set<CDOLockOwner> readLockOwners;
    private CDOLockOwner writeLockOwner;
    private CDOLockOwner writeOptionOwner;

    public CDOLockStateImpl(Object lockedObject) {
        assert (lockedObject instanceof CDOID || lockedObject instanceof CDOIDAndBranch) : "lockedObject is of wrong type";
        assert (!CDOIDUtil.isNull(CDOLockUtil.getLockedObjectID(lockedObject))) : "lockedObject is null";
        this.lockedObject = lockedObject;
    }

    public CDOLockStateImpl copy() {
        return this.copy(this.lockedObject);
    }

    public CDOLockStateImpl copy(Object lockedObject) {
        CDOLockStateImpl newLockState = new CDOLockStateImpl(lockedObject);
        if (this.readLockOwners != null) {
            for (CDOLockOwner owner : this.readLockOwners) {
                newLockState.addReadLockOwner(owner);
            }
        }
        newLockState.writeLockOwner = this.writeLockOwner;
        newLockState.writeOptionOwner = this.writeOptionOwner;
        return newLockState;
    }

    @Override
    @Deprecated
    public void updateFrom(Object object, CDOLockState source) {
        this.updateFrom(source);
    }

    @Override
    public void updateFrom(CDOLockState source) {
        Set<CDOLockOwner> owners = source.getReadLockOwners();
        this.readLockOwners = owners.isEmpty() ? null : new HashSet<CDOLockOwner>(owners);
        this.writeLockOwner = source.getWriteLockOwner();
        this.writeOptionOwner = source.getWriteOptionOwner();
    }

    @Override
    public boolean isLocked(IRWLockManager.LockType lockType, CDOLockOwner lockOwner, boolean others) {
        if (this.lockedObject == null) {
            return false;
        }
        if (lockType == null) {
            return this.isReadLocked(lockOwner, others) || this.isWriteLocked(lockOwner, others) || this.isOptionLocked(lockOwner, others);
        }
        switch (lockType) {
            case READ: {
                return this.isReadLocked(lockOwner, others);
            }
            case WRITE: {
                return this.isWriteLocked(lockOwner, others);
            }
            case OPTION: {
                return this.isOptionLocked(lockOwner, others);
            }
        }
        return false;
    }

    private boolean isReadLocked(CDOLockOwner by, boolean others) {
        if (this.readLockOwners == null) {
            return false;
        }
        int n = this.readLockOwners.size();
        if (n == 0) {
            return false;
        }
        boolean contained = this.readLockOwners.contains(by);
        if (others) {
            int ownCount;
            int n2 = ownCount = contained ? 1 : 0;
            return n > ownCount;
        }
        return contained;
    }

    private boolean isWriteLocked(CDOLockOwner by, boolean others) {
        if (this.writeLockOwner == null) {
            return false;
        }
        return this.writeLockOwner.equals(by) ^ others;
    }

    private boolean isOptionLocked(CDOLockOwner by, boolean others) {
        if (this.writeOptionOwner == null) {
            return false;
        }
        return this.writeOptionOwner.equals(by) ^ others;
    }

    @Override
    public Set<CDOLockOwner> getReadLockOwners() {
        if (this.lockedObject == null || this.readLockOwners == null) {
            return NO_LOCK_OWNERS;
        }
        return Collections.unmodifiableSet(this.readLockOwners);
    }

    @Override
    public void addReadLockOwner(CDOLockOwner lockOwner) {
        if (this.readLockOwners == null) {
            this.readLockOwners = new HashSet<CDOLockOwner>();
        }
        this.readLockOwners.add(lockOwner);
    }

    @Override
    public boolean removeReadLockOwner(CDOLockOwner lockOwner) {
        if (this.readLockOwners == null) {
            return false;
        }
        boolean changed = this.readLockOwners.remove(lockOwner);
        if (changed && this.readLockOwners.isEmpty()) {
            this.readLockOwners = null;
        }
        return changed;
    }

    @Override
    public CDOLockOwner getWriteLockOwner() {
        return this.writeLockOwner;
    }

    @Override
    public void setWriteLockOwner(CDOLockOwner lockOwner) {
        this.writeLockOwner = lockOwner;
    }

    @Override
    public CDOLockOwner getWriteOptionOwner() {
        return this.writeOptionOwner;
    }

    @Override
    public void setWriteOptionOwner(CDOLockOwner lockOwner) {
        this.writeOptionOwner = lockOwner;
    }

    @Override
    public boolean removeOwner(CDOLockOwner lockOwner) {
        boolean changed = this.removeReadLockOwner(lockOwner);
        if (lockOwner.equals(this.writeLockOwner)) {
            this.writeLockOwner = null;
            changed = true;
        }
        if (lockOwner.equals(this.writeOptionOwner)) {
            this.writeOptionOwner = null;
            changed = true;
        }
        return changed;
    }

    @Override
    public Object getLockedObject() {
        return this.lockedObject;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lockedObject == null ? 0 : this.lockedObject.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CDOLockStateImpl)) {
            return false;
        }
        CDOLockStateImpl other = (CDOLockStateImpl)obj;
        if (this.lockedObject == null ? other.lockedObject != null : !this.lockedObject.equals(other.lockedObject)) {
            return false;
        }
        if (!this.getReadLockOwners().equals(other.getReadLockOwners())) {
            return false;
        }
        if (this.writeLockOwner == null && other.getWriteLockOwner() != null || this.writeLockOwner != null && other.getWriteLockOwner() == null || this.writeLockOwner != null && !this.writeLockOwner.equals(other.getWriteLockOwner())) {
            return false;
        }
        return !(this.writeOptionOwner == null && other.getWriteOptionOwner() != null || this.writeOptionOwner != null && other.getWriteOptionOwner() == null) && (this.writeOptionOwner == null || this.writeOptionOwner.equals(other.getWriteOptionOwner()));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CDOLockState[lockedObject=");
        builder.append(this.lockedObject);
        builder.append(", readLockOwners=");
        if (this.readLockOwners != null && this.readLockOwners.size() > 0) {
            boolean first = true;
            for (CDOLockOwner lockOwner : this.readLockOwners) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(lockOwner);
            }
            builder.deleteCharAt(builder.length() - 1);
        } else {
            builder.append("NONE");
        }
        builder.append(", writeLockOwner=");
        builder.append(this.writeLockOwner != null ? this.writeLockOwner : "NONE");
        builder.append(", writeOptionOwner=");
        builder.append(this.writeOptionOwner != null ? this.writeOptionOwner : "NONE");
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void dispose() {
        this.readLockOwners = null;
        this.writeLockOwner = null;
        this.writeOptionOwner = null;
    }
}

