/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.signal.Request;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.io.ExtendedIOUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

class RemoteExceptionRequest
extends Request {
    public static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_SIGNAL, RemoteExceptionRequest.class);
    private int correlationID;
    private boolean responding;
    private String message;
    private Throwable t;

    public RemoteExceptionRequest(SignalProtocol<?> protocol, int correlationID, boolean responding, String message, Throwable t) {
        super(protocol, (short)-1);
        this.correlationID = correlationID;
        this.message = message;
        this.t = t;
        this.responding = responding;
    }

    @Override
    protected void requesting(ExtendedDataOutputStream out) throws Exception {
        if (TRACER.isEnabled()) {
            String msg = RemoteExceptionRequest.getFirstLine(this.message);
            TRACER.format("Writing remote exception for signal {0}: {1}", new Object[]{this.correlationID, msg});
        }
        out.writeInt(this.correlationID);
        out.writeBoolean(this.responding);
        out.writeString(this.message);
        out.writeByteArray(ExtendedIOUtil.serializeThrowable((Throwable)this.t));
    }

    static String getFirstLine(String message) {
        if (message == null) {
            return null;
        }
        int nl = message.indexOf(10);
        if (nl == -1) {
            nl = message.length();
        }
        if (nl > 100) {
            nl = 100;
        }
        return message.substring(0, nl);
    }
}

