/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.FindAndModifyHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.codecs.Decoder;

public class FindAndDeleteOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;
    private WriteConcern writeConcern;

    @Deprecated
    public FindAndDeleteOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this(namespace, WriteConcern.ACKNOWLEDGED, decoder);
    }

    public FindAndDeleteOperation(MongoNamespace namespace, WriteConcern writeConcern, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndDeleteOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndDeleteOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndDeleteOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndDeleteOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public T execute(final WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<T>(){

            @Override
            public T call(Connection connection) {
                return CommandOperationHelper.executeWrappedCommandProtocol(binding, FindAndDeleteOperation.this.namespace.getDatabaseName(), FindAndDeleteOperation.this.asCommandDocument(connection.getDescription()), CommandResultDocumentCodec.create(FindAndDeleteOperation.this.decoder, "value"), connection, FindAndModifyHelper.<BsonDocument>transformer());
            }
        });
    }

    @Override
    public void executeAsync(final AsyncWriteBinding binding, final SingleResultCallback<T> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, FindAndDeleteOperation.this.namespace.getDatabaseName(), FindAndDeleteOperation.this.asCommandDocument(connection.getDescription()), CommandResultDocumentCodec.create(FindAndDeleteOperation.this.decoder, "value"), connection, FindAndModifyHelper.<BsonDocument>transformer(), OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection));
                }
            }
        });
    }

    private BsonDocument asCommandDocument(ConnectionDescription description) {
        BsonDocument command = new BsonDocument("findandmodify", new BsonString(this.namespace.getCollectionName()));
        DocumentHelper.putIfNotNull(command, "query", this.getFilter());
        DocumentHelper.putIfNotNull(command, "fields", this.getProjection());
        DocumentHelper.putIfNotNull(command, "sort", this.getSort());
        DocumentHelper.putIfNotZero(command, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        command.put("remove", BsonBoolean.TRUE);
        if (OperationHelper.serverIsAtLeastVersionThreeDotTwo(description) && this.writeConcern.isAcknowledged() && !this.writeConcern.isServerDefault()) {
            command.put("writeConcern", this.writeConcern.asDocument());
        }
        return command;
    }
}

