/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.util.Set;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchChangedEvent;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockChangeInfo;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.BranchNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ChangeCredentialsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ChangeSubscriptionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ChangeTagIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CloseViewIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitDelegationIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitTransactionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionCancelIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionPhase1Indication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionPhase2Indication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CommitXATransactionPhase3Indication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CreateBranchIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CredentialsChallengeRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.DisablePassiveUpdateIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.EnableLockNotificationIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.GetRemoteSessionsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.HandleRevisionsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadBranchIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadBranchesIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadChangeSetsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadChunkIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadCommitDataIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadCommitInfosIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadLobIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadMergeDataIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadObjectLifetimeIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadPackagesIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadPermissionsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadRevisionByVersionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadRevisionsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadSubBranchesIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LoadTagsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LockAreaIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LockDelegationIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LockNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LockObjectsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.LockStateIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ObjectLockedIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.OpenSessionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.OpenViewIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.OpenedSessionNotification;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.QueryCancelIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.QueryIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.QueryLobsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RefreshSessionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RemoteMessageIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RemoteMessageNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RemoteSessionNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RenameBranchIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ReplicateRepositoryIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ReplicateRepositoryRawIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RepositoryStateNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RepositoryTimeIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.RepositoryTypeNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.ResetTransactionIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.SetLockNotificationModeIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.SetPassiveUpdateModeIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.SwitchTargetIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.TagNotificationRequest;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.UnitIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.UnlockDelegationIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.UnlockObjectsIndication;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.UnsubscribeRemoteSessionsIndication;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDOAuthenticationResult;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.signal.security.AuthenticationRequest;
import org.eclipse.net4j.util.io.StringCompressor;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.security.CredentialsUpdateOperation;
import org.eclipse.net4j.util.security.DiffieHellman;

public class CDOServerProtocol
extends SignalProtocol<InternalSession>
implements ISessionProtocol {
    public static final long DEFAULT_NEGOTIATION_TIMEOUT = 15000L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, CDOServerProtocol.class);
    private static final boolean COMPRESS_PACKAGE_URIS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.protocol.compressPackageURIs", !StringCompressor.BYPASS);
    private StringIO packageURICompressor = COMPRESS_PACKAGE_URIS ? new StringCompressor(false) : StringIO.DIRECT;
    private long negotiationTimeout = 15000L;
    private IRepositoryProvider repositoryProvider;

    public CDOServerProtocol(IRepositoryProvider repositoryProvider) {
        super("cdo");
        this.repositoryProvider = repositoryProvider;
    }

    public int getVersion() {
        return PROTOCOL_VERSION;
    }

    public InternalSession getSession() {
        return (InternalSession)this.getInfraStructure();
    }

    public IRepositoryProvider getRepositoryProvider() {
        return this.repositoryProvider;
    }

    public StringIO getPackageURICompressor() {
        return this.packageURICompressor;
    }

    public long getNegotiationTimeout() {
        return this.negotiationTimeout;
    }

    public void setNegotiationTimeout(long negotiationTimeout) {
        this.negotiationTimeout = negotiationTimeout;
    }

    @Deprecated
    public CDOAuthenticationResult sendAuthenticationChallenge(byte[] randomToken) throws Exception {
        throw new UnsupportedOperationException();
    }

    public DiffieHellman.Client.Response sendAuthenticationChallenge(DiffieHellman.Server.Challenge challenge) throws Exception {
        return (DiffieHellman.Client.Response)new AuthenticationRequest((SignalProtocol)this, 2, challenge).send(this.negotiationTimeout, (OMMonitor)new Monitor());
    }

    public DiffieHellman.Client.Response sendCredentialsChallenge(DiffieHellman.Server.Challenge challenge, String userID, CredentialsUpdateOperation operation) throws Exception {
        return (DiffieHellman.Client.Response)new CredentialsChallengeRequest(this, challenge, userID, operation).send(this.negotiationTimeout, (OMMonitor)new Monitor());
    }

    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryTypeNotificationRequest(this, oldType, newType).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    @Deprecated
    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) throws Exception {
        this.sendRepositoryStateNotification(oldState, newState, null);
    }

    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState, CDOID rootResourceID) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RepositoryStateNotificationRequest(this, oldState, newState, rootResourceID).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    @Deprecated
    public void sendBranchNotification(InternalCDOBranch branch) throws Exception {
        this.sendBranchNotification(branch, CDOBranchChangedEvent.ChangeKind.CREATED);
    }

    public void sendBranchNotification(InternalCDOBranch branch, CDOBranchChangedEvent.ChangeKind changeKind) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new BranchNotificationRequest(this, (CDOBranch)branch, changeKind).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendTagNotification(int modCount, String oldName, String newName, CDOBranchPoint branchPoint) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new TagNotificationRequest(this, modCount, oldName, newName, branchPoint).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    @Deprecated
    public void sendCommitNotification(CDOCommitInfo commitInfo) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void sendCommitNotification(CDOCommitInfo commitInfo, boolean clearResourcePathCache) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void sendCommitNotification(CDOProtocol.CommitNotificationInfo info) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new CommitNotificationRequest(this, info).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RemoteSessionNotificationRequest(this, sender, opcode).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    public void sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new RemoteMessageNotificationRequest(this, sender, message).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    @Deprecated
    public void sendLockNotification(CDOLockChangeInfo lockChangeInfo) throws Exception {
        this.sendLockNotification(lockChangeInfo, null);
    }

    public void sendLockNotification(CDOLockChangeInfo lockChangeInfo, Set<CDOID> filter) throws Exception {
        if (LifecycleUtil.isActive((Object)this.getChannel())) {
            new LockNotificationRequest(this, lockChangeInfo, filter).sendAsync();
        } else {
            this.handleInactiveSession();
        }
    }

    protected void handleInactiveSession() {
        if (TRACER.isEnabled()) {
            TRACER.trace("Session channel is inactive: " + (Object)((Object)this));
        }
    }

    protected StringCompressor getStringCompressor() {
        if (COMPRESS_PACKAGE_URIS) {
            return (StringCompressor)this.packageURICompressor;
        }
        return super.getStringCompressor();
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 1: {
                return new OpenSessionIndication(this);
            }
            case 3: {
                return new OpenViewIndication(this);
            }
            case 4: {
                return new SwitchTargetIndication(this);
            }
            case 5: {
                return new CloseViewIndication(this);
            }
            case 6: {
                return new LoadPackagesIndication(this);
            }
            case 33: {
                return new CreateBranchIndication(this);
            }
            case 34: {
                return new LoadBranchIndication(this);
            }
            case 35: {
                return new LoadSubBranchesIndication(this);
            }
            case 36: {
                return new LoadBranchesIndication(this);
            }
            case 7: {
                return new LoadRevisionsIndication(this);
            }
            case 8: {
                return new LoadRevisionByVersionIndication(this);
            }
            case 9: {
                return new LoadChunkIndication(this);
            }
            case 46: {
                return new QueryLobsIndication(this);
            }
            case 47: {
                return new LoadLobIndication(this);
            }
            case 11: {
                return new CommitTransactionIndication(this);
            }
            case 12: {
                return new CommitDelegationIndication(this);
            }
            case 13: {
                return new CommitXATransactionPhase1Indication(this);
            }
            case 14: {
                return new CommitXATransactionPhase2Indication(this);
            }
            case 15: {
                return new CommitXATransactionPhase3Indication(this);
            }
            case 16: {
                return new CommitXATransactionCancelIndication(this);
            }
            case 17: {
                return new QueryIndication(this);
            }
            case 18: {
                return new QueryCancelIndication(this);
            }
            case 19: {
                return new RefreshSessionIndication(this);
            }
            case 20: {
                return new DisablePassiveUpdateIndication(this);
            }
            case 21: {
                return new SetPassiveUpdateModeIndication(this);
            }
            case 22: {
                return new ChangeSubscriptionIndication(this);
            }
            case 23: {
                return new RepositoryTimeIndication(this);
            }
            case 24: {
                return new LockObjectsIndication(this);
            }
            case 25: {
                return new UnlockObjectsIndication(this);
            }
            case 49: {
                return new LockDelegationIndication(this);
            }
            case 50: {
                return new UnlockDelegationIndication(this);
            }
            case 26: {
                return new ObjectLockedIndication(this);
            }
            case 27: {
                return new LockAreaIndication(this);
            }
            case 28: {
                return new GetRemoteSessionsIndication(this);
            }
            case 31: {
                return new UnsubscribeRemoteSessionsIndication(this);
            }
            case 29: {
                return new RemoteMessageIndication(this);
            }
            case 40: {
                return new LoadCommitInfosIndication(this);
            }
            case 41: {
                return new LoadCommitDataIndication(this);
            }
            case 42: {
                return new ReplicateRepositoryIndication(this);
            }
            case 43: {
                return new ReplicateRepositoryRawIndication(this);
            }
            case 44: {
                return new LoadChangeSetsIndication(this);
            }
            case 45: {
                return new LoadMergeDataIndication(this);
            }
            case 48: {
                return new HandleRevisionsIndication(this);
            }
            case 52: {
                return new LockStateIndication(this);
            }
            case 53: {
                return new EnableLockNotificationIndication(this);
            }
            case 54: {
                return new SetLockNotificationModeIndication(this);
            }
            case 55: {
                return new LoadPermissionsIndication(this);
            }
            case 56: {
                return new ChangeCredentialsIndication(this);
            }
            case 58: {
                return new RenameBranchIndication(this);
            }
            case 59: {
                return new LoadObjectLifetimeIndication(this);
            }
            case 60: {
                return new OpenedSessionNotification(this);
            }
            case 61: {
                return new ResetTransactionIndication(this);
            }
            case 62: {
                return new UnitIndication(this);
            }
            case 64: {
                return new ChangeTagIndication(this);
            }
            case 63: {
                return new LoadTagsIndication(this);
            }
        }
        return super.createSignalReactor(signalID);
    }
}

