/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcAllowedValues;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDefaultValue;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcHidden;
import org.eclipse.lyo.oslc4j.core.annotation.OslcMaxSize;
import org.eclipse.lyo.oslc4j.core.annotation.OslcMemberProperty;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcOccurs;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreDuplicatePropertyDefinitionException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidOccursException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyDefinitionException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidPropertyTypeException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidRepresentationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreInvalidValueTypeException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingAnnotationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreMissingSetMethodException;
import org.eclipse.lyo.oslc4j.core.model.IReifiedResource;
import org.eclipse.lyo.oslc4j.core.model.InheritedMethodAnnotationHelper;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Property;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ResourceShape;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

public class ResourceShapeFactory {
    protected static final String METHOD_NAME_START_GET = "get";
    protected static final String METHOD_NAME_START_IS = "is";
    protected static final String METHOD_NAME_START_SET = "set";
    protected static final int METHOD_NAME_START_GET_LENGTH = "get".length();
    protected static final int METHOD_NAME_START_IS_LENGTH = "is".length();
    protected static final Map<Class<?>, ValueType> CLASS_TO_VALUE_TYPE = new HashMap();

    protected ResourceShapeFactory() {
    }

    public static ResourceShape createResourceShape(String baseURI, String resourceShapesPath, String resourceShapePath, Class<?> resourceClass) throws OslcCoreApplicationException, URISyntaxException {
        HashSet verifiedClasses = new HashSet();
        verifiedClasses.add(resourceClass);
        return ResourceShapeFactory.createResourceShape(baseURI, resourceShapesPath, resourceShapePath, resourceClass, verifiedClasses);
    }

    private static ResourceShape createResourceShape(String baseURI, String resourceShapesPath, String resourceShapePath, Class<?> resourceClass, Set<Class<?>> verifiedClasses) throws OslcCoreApplicationException, URISyntaxException {
        String description;
        OslcResourceShape resourceShapeAnnotation = resourceClass.getAnnotation(OslcResourceShape.class);
        if (resourceShapeAnnotation == null) {
            throw new OslcCoreMissingAnnotationException(resourceClass, OslcResourceShape.class);
        }
        URI about = UriBuilder.fromUri((String)baseURI).path(resourceShapesPath).path(resourceShapePath).build(new Object[0]);
        ResourceShape resourceShape = new ResourceShape(about);
        OslcName nameAnnotation = resourceClass.getAnnotation(OslcName.class);
        if (nameAnnotation != null) {
            resourceShape.setName(nameAnnotation.value());
        } else {
            resourceShape.setName(resourceClass.getSimpleName());
        }
        String title = resourceShapeAnnotation.title();
        if (title != null && title.length() > 0) {
            resourceShape.setTitle(title);
        }
        if ((description = resourceShapeAnnotation.description()) != null && description.length() > 0) {
            resourceShape.setDescription(description);
        }
        for (String describesItem : resourceShapeAnnotation.describes()) {
            resourceShape.addDescribeItem(new URI(describesItem));
        }
        HashSet<String> propertyDefinitions = new HashSet<String>();
        for (Method method : resourceClass.getMethods()) {
            OslcPropertyDefinition propertyDefinitionAnnotation;
            if (method.getParameterTypes().length != 0) continue;
            String methodName = method.getName();
            int methodNameLength = methodName.length();
            if ((!methodName.startsWith(METHOD_NAME_START_GET) || methodNameLength <= METHOD_NAME_START_GET_LENGTH) && (!methodName.startsWith(METHOD_NAME_START_IS) || methodNameLength <= METHOD_NAME_START_IS_LENGTH) || (propertyDefinitionAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcPropertyDefinition.class)) == null) continue;
            String propertyDefinition = propertyDefinitionAnnotation.value();
            if (propertyDefinitions.contains(propertyDefinition)) {
                throw new OslcCoreDuplicatePropertyDefinitionException(resourceClass, propertyDefinitionAnnotation);
            }
            propertyDefinitions.add(propertyDefinition);
            Property property = ResourceShapeFactory.createProperty(baseURI, resourceClass, method, propertyDefinitionAnnotation, verifiedClasses);
            resourceShape.addProperty(property);
            ResourceShapeFactory.validateSetMethodExists(resourceClass, method);
        }
        return resourceShape;
    }

    private static Property createProperty(String baseURI, Class<?> resourceClass, Method method, OslcPropertyDefinition propertyDefinitionAnnotation, Set<Class<?>> verifiedClasses) throws OslcCoreApplicationException, URISyntaxException {
        OslcValueShape valueShapeAnnotation;
        OslcMaxSize maxSizeAnnotation;
        OslcReadOnly readOnlyAnnotation;
        OslcMemberProperty memberPropertyAnnotation;
        OslcHidden hiddenAnnotation;
        OslcDefaultValue defaultValueAnnotation;
        OslcAllowedValues allowedValuesAnnotation;
        Representation representation;
        OslcRepresentation representationAnnotation;
        OslcRange rangeAnnotation;
        OslcDescription descriptionAnnotation;
        OslcValueType valueTypeAnnotation;
        Type actualTypeArgument;
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type genericType;
        Occurs occurs;
        OslcName nameAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcName.class);
        String name = nameAnnotation != null ? nameAnnotation.value() : ResourceShapeFactory.getDefaultPropertyName(method);
        String propertyDefinition = propertyDefinitionAnnotation.value();
        if (!propertyDefinition.endsWith(name)) {
            throw new OslcCoreInvalidPropertyDefinitionException(resourceClass, method, propertyDefinitionAnnotation);
        }
        Class<?> returnType = method.getReturnType();
        OslcOccurs occursAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcOccurs.class);
        if (occursAnnotation != null) {
            occurs = occursAnnotation.value();
            ResourceShapeFactory.validateUserSpecifiedOccurs(resourceClass, method, occursAnnotation);
        } else {
            occurs = ResourceShapeFactory.getDefaultOccurs(returnType);
        }
        Class componentType = ResourceShapeFactory.getComponentType(resourceClass, method, returnType);
        if (IReifiedResource.class.isAssignableFrom(componentType) && (genericType = componentType.getGenericSuperclass()) instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
            componentType = (Class)actualTypeArgument;
        }
        ValueType valueType = (valueTypeAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcValueType.class)) != null ? valueTypeAnnotation.value() : ResourceShapeFactory.getDefaultValueType(resourceClass, method, componentType);
        Property property = new Property(name, occurs, new URI(propertyDefinition), valueType);
        property.setTitle(property.getName());
        OslcTitle titleAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcTitle.class);
        if (titleAnnotation != null) {
            property.setTitle(titleAnnotation.value());
        }
        if ((descriptionAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcDescription.class)) != null) {
            property.setDescription(descriptionAnnotation.value());
        }
        if ((rangeAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcRange.class)) != null) {
            for (String range : rangeAnnotation.value()) {
                property.addRange(new URI(range));
            }
        }
        if ((representationAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcRepresentation.class)) != null) {
            representation = representationAnnotation.value();
            property.setRepresentation(new URI(representation.toString()));
        } else {
            representation = ResourceShapeFactory.getDefaultRepresentation(componentType);
            if (representation != null) {
                property.setRepresentation(new URI(representation.toString()));
            }
        }
        OslcAllowedValue allowedValueAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcAllowedValue.class);
        if (allowedValueAnnotation != null) {
            property.setAllowedValuesCollection(Arrays.asList(allowedValueAnnotation.value()));
        }
        if ((allowedValuesAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcAllowedValues.class)) != null) {
            property.setAllowedValuesRef(new URI(allowedValuesAnnotation.value()));
        }
        if ((defaultValueAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcDefaultValue.class)) != null) {
            property.setDefaultValue(defaultValueAnnotation.value());
        }
        if ((hiddenAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcHidden.class)) != null) {
            property.setHidden(hiddenAnnotation.value());
        }
        if ((memberPropertyAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcMemberProperty.class)) != null) {
            property.setMemberProperty(memberPropertyAnnotation.value());
        }
        if ((readOnlyAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcReadOnly.class)) != null) {
            property.setReadOnly(readOnlyAnnotation.value());
        }
        if ((maxSizeAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcMaxSize.class)) != null) {
            property.setMaxSize(maxSizeAnnotation.value());
        }
        if ((valueShapeAnnotation = InheritedMethodAnnotationHelper.getAnnotation(method, OslcValueShape.class)) != null) {
            property.setValueShape(new URI(baseURI + "/" + valueShapeAnnotation.value()));
        }
        ResourceShapeFactory.validateUserSpecifiedValueType(resourceClass, method, valueType, representation, componentType);
        ResourceShapeFactory.validateUserSpecifiedRepresentation(resourceClass, method, representation, componentType);
        if ((ValueType.LocalResource.equals((Object)valueType) || ValueType.Resource.equals((Object)valueType) && null != representation && Representation.Inline.equals((Object)representation)) && verifiedClasses.add(componentType)) {
            ResourceShapeFactory.createResourceShape(baseURI, "resourceShapes", "unused", componentType, verifiedClasses);
        }
        return property;
    }

    protected static String getDefaultPropertyName(Method method) {
        String methodName = method.getName();
        int startingIndex = methodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_GET_LENGTH : METHOD_NAME_START_IS_LENGTH;
        int endingIndex = startingIndex + 1;
        String lowercasedFirstCharacter = methodName.substring(startingIndex, endingIndex).toLowerCase(Locale.ENGLISH);
        if (methodName.length() == endingIndex) {
            return lowercasedFirstCharacter;
        }
        return lowercasedFirstCharacter + methodName.substring(endingIndex);
    }

    private static ValueType getDefaultValueType(Class<?> resourceClass, Method method, Class<?> componentType) throws OslcCoreApplicationException {
        ValueType valueType = CLASS_TO_VALUE_TYPE.get(componentType);
        if (valueType == null) {
            throw new OslcCoreInvalidPropertyTypeException(resourceClass, method, componentType);
        }
        return valueType;
    }

    private static Representation getDefaultRepresentation(Class<?> componentType) {
        if (componentType.equals(URI.class)) {
            return Representation.Reference;
        }
        return null;
    }

    private static Occurs getDefaultOccurs(Class<?> type) {
        if (type.isArray() || Collection.class.isAssignableFrom(type)) {
            return Occurs.ZeroOrMany;
        }
        return Occurs.ZeroOrOne;
    }

    protected static Class<?> getComponentType(Class<?> resourceClass, Method method, Class<?> type) throws OslcCoreInvalidPropertyTypeException {
        if (type.isArray()) {
            return type.getComponentType();
        }
        if (Collection.class.isAssignableFrom(type)) {
            Type actualTypeArgument;
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Type genericReturnType = method.getGenericReturnType();
            if (genericReturnType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)genericReturnType).getActualTypeArguments()).length == 1 && (actualTypeArgument = actualTypeArguments[0]) instanceof Class) {
                return (Class)actualTypeArgument;
            }
            throw new OslcCoreInvalidPropertyTypeException(resourceClass, method, type);
        }
        return type;
    }

    protected static void validateSetMethodExists(Class<?> resourceClass, Method getMethod) throws OslcCoreMissingSetMethodException {
        String getMethodName = getMethod.getName();
        String setMethodName = getMethodName.startsWith(METHOD_NAME_START_GET) ? METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_GET_LENGTH) : METHOD_NAME_START_SET + getMethodName.substring(METHOD_NAME_START_IS_LENGTH);
        Class<?> returnType = getMethod.getReturnType();
        if (!ResourceShapeFactory.isCollectionType(returnType)) {
            try {
                resourceClass.getMethod(setMethodName, returnType);
            }
            catch (NoSuchMethodException exception) {
                throw new OslcCoreMissingSetMethodException(resourceClass, getMethod, exception);
            }
        } else {
            List methods = Arrays.stream(resourceClass.getMethods()).filter(m -> m.getName().equals(setMethodName)).collect(Collectors.toList());
            if (methods.size() == 0) {
                throw new OslcCoreMissingSetMethodException(resourceClass, getMethod, null);
            }
            if (methods.size() > 1) {
                throw new IllegalArgumentException("Multiple setters on the same RDF property are not yet supported");
            }
            Method method = (Method)methods.get(0);
            Type[] parameterTypes = method.getGenericParameterTypes();
            if (parameterTypes == null || parameterTypes.length == 0 || parameterTypes.length > 1) {
                throw new IllegalArgumentException(String.format("Method '%s' shall have exactly one argument", method.getName()));
            }
            ParameterizedType setterArgumentType = (ParameterizedType)parameterTypes[0];
            ParameterizedType genericReturnType = (ParameterizedType)getMethod.getGenericReturnType();
            if (!genericReturnType.getActualTypeArguments()[0].equals(setterArgumentType.getActualTypeArguments()[0])) {
                throw new OslcCoreMissingSetMethodException(resourceClass, getMethod, null);
            }
        }
    }

    static boolean isCollectionType(Class<?> returnType) {
        return Collection.class.isAssignableFrom(returnType);
    }

    private static void validateUserSpecifiedOccurs(Class<?> resourceClass, Method method, OslcOccurs occursAnnotation) throws OslcCoreInvalidOccursException {
        Class<?> returnType = method.getReturnType();
        Occurs occurs = occursAnnotation.value();
        if (returnType.isArray() || Collection.class.isAssignableFrom(returnType) ? !Occurs.ZeroOrMany.equals((Object)occurs) && !Occurs.OneOrMany.equals((Object)occurs) : !Occurs.ZeroOrOne.equals((Object)occurs) && !Occurs.ExactlyOne.equals((Object)occurs)) {
            throw new OslcCoreInvalidOccursException(resourceClass, method, occursAnnotation);
        }
    }

    protected static void validateUserSpecifiedValueType(Class<?> resourceClass, Method method, ValueType userSpecifiedValueType, Representation userSpecifiedRepresentation, Class<?> componentType) throws OslcCoreInvalidValueTypeException {
        ValueType calculatedValueType = CLASS_TO_VALUE_TYPE.get(componentType);
        if (userSpecifiedValueType.equals((Object)calculatedValueType) || ValueType.LocalResource.equals((Object)userSpecifiedValueType) || ValueType.Resource.equals((Object)userSpecifiedValueType) && null != userSpecifiedRepresentation && Representation.Inline.equals((Object)userSpecifiedRepresentation) || ValueType.XMLLiteral.equals((Object)userSpecifiedValueType) && ValueType.String.equals((Object)calculatedValueType) || ValueType.Decimal.equals((Object)userSpecifiedValueType) && (ValueType.Double.equals((Object)calculatedValueType) || ValueType.Float.equals((Object)calculatedValueType) || ValueType.Integer.equals((Object)calculatedValueType))) {
            return;
        }
        throw new OslcCoreInvalidValueTypeException(resourceClass, method, userSpecifiedValueType);
    }

    private static void validateUserSpecifiedRepresentation(Class<?> resourceClass, Method method, Representation userSpecifiedRepresentation, Class<?> componentType) throws OslcCoreInvalidRepresentationException {
        if (null == userSpecifiedRepresentation) {
            return;
        }
        if (Representation.Reference.equals((Object)userSpecifiedRepresentation) && !URI.class.equals(componentType) || Representation.Inline.equals((Object)userSpecifiedRepresentation) && CLASS_TO_VALUE_TYPE.containsKey(componentType)) {
            throw new OslcCoreInvalidRepresentationException(resourceClass, method, userSpecifiedRepresentation);
        }
    }

    static {
        CLASS_TO_VALUE_TYPE.put(Boolean.TYPE, ValueType.Boolean);
        CLASS_TO_VALUE_TYPE.put(Byte.TYPE, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Short.TYPE, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Integer.TYPE, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Long.TYPE, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Float.TYPE, ValueType.Float);
        CLASS_TO_VALUE_TYPE.put(Double.TYPE, ValueType.Double);
        CLASS_TO_VALUE_TYPE.put(Boolean.class, ValueType.Boolean);
        CLASS_TO_VALUE_TYPE.put(Byte.class, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Short.class, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Integer.class, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Long.class, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(BigInteger.class, ValueType.Integer);
        CLASS_TO_VALUE_TYPE.put(Float.class, ValueType.Float);
        CLASS_TO_VALUE_TYPE.put(Double.class, ValueType.Double);
        CLASS_TO_VALUE_TYPE.put(String.class, ValueType.String);
        CLASS_TO_VALUE_TYPE.put(Date.class, ValueType.DateTime);
        CLASS_TO_VALUE_TYPE.put(URI.class, ValueType.Resource);
    }
}

